/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.io.File;
import java.util.ServiceLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.store.Store;
import org.dita.dost.store.StoreBuilder;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;

public final class InitializeProjectTask
extends Task {
    private static ServiceLoader<StoreBuilder> storeBuilderLoader = ServiceLoader.load(StoreBuilder.class);
    private String storeType = "file";

    public void execute() throws BuildException {
        this.log("Initializing project", 2);
        File ditaDir = URLUtils.toFile(this.getProject().getProperty("dita.dir"));
        if (!ditaDir.isAbsolute()) {
            throw new IllegalArgumentException("DITA-OT installation directory " + ditaDir + " must be absolute");
        }
        CatalogUtils.setDitaDir(ditaDir);
        XMLUtils xmlUtils = (XMLUtils)this.getProject().getReference("xmlutils");
        if (xmlUtils == null) {
            xmlUtils = new XMLUtils();
            xmlUtils.setLogger(new DITAOTAntLogger(this.getProject()));
            this.getProject().addReference("xmlutils", (Object)xmlUtils);
        }
        Store store = this.getStore(xmlUtils);
        this.getProject().addReference("store", (Object)store);
    }

    private Store getStore(XMLUtils xmlUtils) {
        Store store = (Store)this.getProject().getReference("store");
        if (store != null) {
            return store;
        }
        File tempDir = URLUtils.toFile(this.getProject().getUserProperty("dita.temp.dir"));
        if (tempDir == null) {
            tempDir = URLUtils.toFile(this.getProject().getProperty("dita.temp.dir"));
        }
        for (StoreBuilder storeBuilder : storeBuilderLoader) {
            if (!storeBuilder.getType().equals(this.storeType)) continue;
            return storeBuilder.setTempDir(tempDir).setXmlUtils(xmlUtils).build();
        }
        throw new BuildException(String.format("Unsupported store type %s", this.storeType));
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }
}

