/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Get;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.platform.Alias;
import org.dita.dost.platform.Integrator;
import org.dita.dost.platform.Plugins;
import org.dita.dost.platform.Registry;
import org.dita.dost.platform.SemVer;
import org.dita.dost.platform.SemVerMatch;
import org.dita.dost.util.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class PluginInstallTask
extends Task {
    private List<String> registries;
    private File tempDir;
    private final ObjectMapper mapper = new ObjectMapper();
    private List<String> installedPlugins;
    private Path pluginFile;
    private URL pluginUrl;
    private String pluginName;
    private SemVerMatch pluginVersion;
    private boolean force;
    private Integrator integrator;

    public void init() {
        this.registries = Arrays.stream(Configuration.configuration.get("registry").trim().split("\\s+")).map(registry -> registry.endsWith("/") ? registry : registry + "/").collect(Collectors.toList());
        try {
            this.tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new BuildException("Failed to create temporary directory: " + e.getMessage(), (Throwable)e);
        }
        this.installedPlugins = Plugins.getInstalledPlugins();
        DITAOTAntLogger logger = new DITAOTAntLogger(this.getProject());
        logger.setTarget(this.getOwningTarget());
        logger.setTask(this);
        this.integrator = new Integrator(this.getProject().getBaseDir());
        this.integrator.setLogger(logger);
    }

    private void cleanUp() {
        if (this.tempDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void execute() throws BuildException {
        if (this.pluginFile == null && this.pluginUrl == null && this.pluginName == null) {
            throw new BuildException((Throwable)new IllegalStateException("pluginName argument not set"));
        }
        try {
            String name;
            HashMap<String, Object> installs = new HashMap<String, Object>();
            if (this.pluginFile != null && Files.exists(this.pluginFile, new LinkOption[0])) {
                File tempPluginDir = this.unzip(this.pluginFile.toFile());
                String name2 = this.getPluginName(tempPluginDir);
                installs.put(name2, tempPluginDir);
            } else if (this.pluginUrl != null) {
                File tempFile = this.get(this.pluginUrl, null);
                File tempPluginDir = this.unzip(tempFile);
                name = this.getPluginName(tempPluginDir);
                installs.put(name, tempPluginDir);
            } else {
                Set<Registry> plugins = this.readRegistry(this.pluginName, this.pluginVersion);
                for (Registry plugin : plugins) {
                    File tempFile = this.get(plugin.url, plugin.cksum);
                    File tempPluginDir = this.unzip(tempFile);
                    String name3 = plugin.name;
                    installs.put(name3, tempPluginDir);
                }
            }
            for (Map.Entry install : installs.entrySet()) {
                name = (String)install.getKey();
                File tempPluginDir = (File)install.getValue();
                File pluginDir = this.getPluginDir(name);
                if (pluginDir.exists()) {
                    if (this.force) {
                        this.log("Force install to " + pluginDir, 2);
                        this.integrator.addRemoved(name);
                        FileUtils.deleteDirectory((File)pluginDir);
                    } else {
                        throw new BuildException((Throwable)new IllegalStateException(String.format("Plug-in %s already installed: %s", name, pluginDir)));
                    }
                }
                FileUtils.copyDirectory((File)tempPluginDir, (File)pluginDir);
            }
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cleanUp();
        }
        try {
            this.integrator.execute();
        }
        catch (Exception e) {
            throw new BuildException("Integration failed: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFileHash(File file) {
        try (DigestInputStream digestInputStream = new DigestInputStream(new BufferedInputStream(new FileInputStream(file)), MessageDigest.getInstance("SHA-256"));){
            IOUtils.copy((InputStream)digestInputStream, (OutputStream)new NullOutputStream());
            MessageDigest digest = digestInputStream.getMessageDigest();
            byte[] sha256 = digest.digest();
            String string = this.printHexBinary(sha256);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new BuildException("Failed to calculate file checksum: " + e.getMessage(), (Throwable)e);
        }
    }

    private String printHexBinary(byte[] md5) {
        StringBuilder sb = new StringBuilder();
        for (byte b : md5) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString().toLowerCase();
    }

    private String getPluginName(File pluginDir) {
        File config = new File(pluginDir, "plugin.xml");
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(config);
            return doc.getDocumentElement().getAttribute("id");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new BuildException("Failed to read plugin name: " + e.getMessage(), (Throwable)e);
        }
    }

    private File getPluginDir(String id) {
        return Paths.get(this.getProject().getProperty("dita.dir"), "plugins", id).toFile();
    }

    private Set<Registry> readRegistry(String name, SemVerMatch version) {
        this.log(String.format("Reading registries for %s@%s", name, version), 2);
        Registry res = null;
        for (String registry : this.registries) {
            URI registryUrl = URI.create(registry + name + ".json");
            this.log(String.format("Read registry %s", registry), 2);
            try {
                BufferedInputStream in = new BufferedInputStream(registryUrl.toURL().openStream());
                Throwable throwable = null;
                try {
                    this.log("Parse registry", 2);
                    JsonFactory factory = this.mapper.getFactory();
                    JsonParser parser = factory.createParser((InputStream)in);
                    JsonNode obj = (JsonNode)this.mapper.readTree(parser);
                    Collection<Object> regs = obj.isArray() ? Arrays.asList((Object[])this.mapper.treeToValue((TreeNode)obj, Registry[].class)) : this.resolveAlias((Alias)this.mapper.treeToValue((TreeNode)obj, Alias.class));
                    Optional<Registry> reg = this.findPlugin(regs, version);
                    if (!reg.isPresent()) continue;
                    Registry plugin = reg.get();
                    this.log(String.format("Plugin found at %s@%s", registryUrl, plugin.vers), 2);
                    res = plugin;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (MalformedURLException e) {
                this.log(String.format("Invalid registry URL %s: %s", registryUrl, e.getMessage()), e, 0);
            }
            catch (FileNotFoundException e) {
                this.log(String.format("Registry configuration %s not found", registryUrl), e, 2);
            }
            catch (IOException e) {
                this.log(String.format("Failed to read registry configuration %s: %s", registryUrl, e.getMessage()), e, 0);
            }
        }
        if (res == null) {
            throw new BuildException("Unable to find plugin " + this.pluginFile + " in any configured registry.");
        }
        HashSet<Registry> results = new HashSet<Registry>();
        results.add(res);
        res.deps.stream().filter(dep -> !this.installedPlugins.contains(dep.name)).flatMap(dep -> this.readRegistry(dep.name, dep.req).stream()).forEach(results::add);
        return results;
    }

    private Collection<Registry> resolveAlias(Alias registry) {
        return this.readRegistry(registry.alias, null);
    }

    private File get(URL url, String expectedChecksum) {
        String checksum;
        File tempPluginFile = new File(this.tempDir, "plugin.zip");
        Get get = new Get();
        get.setProject(this.getProject());
        get.setTaskName("get");
        get.setSrc(url);
        get.setDest(tempPluginFile);
        get.setIgnoreErrors(false);
        get.setVerbose(false);
        get.execute();
        if (expectedChecksum != null && !(checksum = this.getFileHash(tempPluginFile)).equalsIgnoreCase(expectedChecksum)) {
            throw new BuildException((Throwable)new IllegalArgumentException(String.format("Downloaded plugin file checksum %s does not match expected value %s", checksum, expectedChecksum)));
        }
        return tempPluginFile;
    }

    private File unzip(File input) {
        File tempPluginDir = new File(this.tempDir, "plugin");
        Expand unzip = new Expand();
        unzip.setProject(this.getProject());
        unzip.setTaskName("unzip");
        unzip.setSrc(input);
        unzip.setDest(tempPluginDir);
        unzip.execute();
        return this.findBaseDir(tempPluginDir);
    }

    private File findBaseDir(File tempPluginDir) {
        File config = new File(tempPluginDir, "plugin.xml");
        if (config.exists()) {
            return tempPluginDir;
        }
        for (File dir : tempPluginDir.listFiles(File::isDirectory)) {
            File res = this.findBaseDir(dir);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private Optional<Registry> findPlugin(Collection<Registry> regs, SemVerMatch version) {
        if (version == null) {
            return regs.stream().filter(this::matchingPlatformVersion).max(Comparator.comparing(o -> o.vers));
        }
        return regs.stream().filter(this::matchingPlatformVersion).filter(reg -> version.contains(reg.vers)).findFirst();
    }

    @VisibleForTesting
    boolean matchingPlatformVersion(Registry reg) {
        Optional<Registry.Dependency> platformDependency = reg.deps.stream().filter(dep -> dep.name.equals("org.dita.base")).findFirst();
        if (platformDependency.isPresent()) {
            SemVer platform = new SemVer(Configuration.configuration.get("otversion"));
            Registry.Dependency dep2 = platformDependency.get();
            return dep2.req.contains(platform);
        }
        return true;
    }

    public void setPluginFile(String pluginFile) {
        try {
            this.pluginFile = Paths.get(pluginFile, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        try {
            URI uri = new URI(pluginFile);
            if (uri.isAbsolute()) {
                this.pluginUrl = uri.toURL();
            }
        }
        catch (MalformedURLException | URISyntaxException uri) {
            // empty catch block
        }
        if (pluginFile.contains("@")) {
            String[] tokens = pluginFile.split("@");
            this.pluginName = tokens[0];
            this.pluginVersion = new SemVerMatch(tokens[1]);
        } else {
            this.pluginName = pluginFile;
            this.pluginVersion = null;
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

