/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.chunk;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.chunk.ChunkOperation;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChunkModule
extends AbstractPipelineModuleImpl {
    static final String GEN_CHUNK_PREFIX = "Chunk";
    static final String GEN_UNIQUE_PREFIX = "unique_";
    private TempFileNameScheme tempFileNameScheme;
    private String rootChunkOverride;

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        this.init(input);
        try {
            this.processCombine();
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        return null;
    }

    private void processCombine() throws IOException {
        Job.FileInfo in = this.job.getFileInfo(fi -> fi.isInput).iterator().next();
        URI mapFile = this.job.tempDirURI.resolve(in.uri);
        this.logger.info("Processing {0}", mapFile);
        Document mapDoc = this.getInputMap(mapFile);
        Float ditaVersion = ChunkModule.getDitaVersion(mapDoc.getDocumentElement());
        if (ditaVersion == null || ditaVersion.floatValue() < 2.0f) {
            return;
        }
        List<ChunkOperation> chunks = this.collectChunkOperations(mapFile, mapDoc);
        HashMap<URI, URI> rewriteMap = new HashMap<URI, URI>();
        chunks = this.rewrite(mapFile, rewriteMap, chunks);
        this.rewriteTopicrefs(mapFile, chunks);
        this.logger.info("Writing {0}", mapFile);
        this.job.getStore().writeDocument(mapDoc, mapFile);
        this.generateChunks(chunks, Collections.unmodifiableMap(rewriteMap));
        this.removeChunkSources(chunks);
    }

    private void init(AbstractPipelineInput input) {
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(this.job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(this.job.getInputDir());
        if (input.getAttribute("root-chunk-override") != null) {
            this.rootChunkOverride = input.getAttribute("root-chunk-override");
        }
    }

    private Document getInputMap(URI mapFile) throws IOException {
        Document doc = this.job.getStore().getDocument(mapFile);
        if (this.rootChunkOverride != null) {
            this.logger.debug("Use override root chunk {0}", this.rootChunkOverride);
            doc.getDocumentElement().setAttribute("chunk", this.rootChunkOverride);
        }
        return doc;
    }

    private void removeChunkSources(List<ChunkOperation> chunks) {
        Set<URI> sources = this.collectResources(chunks, chunk -> chunk.src);
        Set<URI> destinations = this.collectResources(chunks, chunk -> chunk.dst);
        Set<URI> removed = sources.stream().filter(dst -> !destinations.contains(dst)).collect(Collectors.toSet());
        removed.forEach(tmp -> {
            this.logger.info("Remove {0}", tmp);
            try {
                this.job.getStore().delete((URI)tmp);
            }
            catch (IOException e) {
                this.logger.error("Failed to delete " + tmp, e);
            }
            this.job.remove(this.job.getFileInfo((URI)tmp));
        });
        Set<URI> added = destinations.stream().filter(dst -> !sources.contains(dst)).collect(Collectors.toSet());
        added.forEach(tmp -> {
            if (this.job.getFileInfo((URI)tmp) == null) {
                Job.FileInfo src = chunks.stream().filter(chunk -> chunk.src != null && chunk.dst != null && URLUtils.removeFragment(chunk.dst).equals(tmp)).findAny().flatMap(chunk -> Optional.ofNullable(this.job.getFileInfo(URLUtils.removeFragment(chunk.src)))).orElse(null);
                Job.FileInfo.Builder builder = src != null ? Job.FileInfo.builder(src) : Job.FileInfo.builder();
                URI dstRel = this.job.tempDirURI.relativize((URI)tmp);
                Job.FileInfo dstFi = builder.uri(dstRel).format("dita").build();
                this.job.add(dstFi);
            }
        });
    }

    private Set<URI> collectResources(List<ChunkOperation> chunks, Function<ChunkOperation, URI> pick) {
        HashSet<URI> sources = new HashSet<URI>();
        this.collectResources(chunks, pick, sources);
        return Collections.unmodifiableSet(sources);
    }

    private void collectResources(List<ChunkOperation> chunks, Function<ChunkOperation, URI> pick, Set<URI> res) {
        for (ChunkOperation chunk : chunks) {
            URI uri = pick.apply(chunk);
            if (uri != null) {
                res.add(URLUtils.removeFragment(uri));
            }
            this.collectResources(chunk.children, pick, res);
        }
    }

    private void generateChunks(List<ChunkOperation> chunks, Map<URI, URI> rewriteMap) {
        (this.parallel ? (Stream)chunks.stream().parallel() : chunks.stream()).forEach(chunk -> {
            this.logger.info("Generate chunk {0}", URLUtils.removeFragment(chunk.dst));
            try {
                Document chunkDoc = this.merge((ChunkOperation)chunk);
                this.rewriteLinks(chunkDoc, (ChunkOperation)chunk, rewriteMap);
                chunkDoc.normalizeDocument();
                URI dst = URLUtils.removeFragment(chunk.dst);
                this.logger.info("Writing {0}", dst);
                this.job.getStore().writeDocument(chunkDoc, dst);
            }
            catch (IOException e) {
                this.logger.error("Failed to generate chunk {0}", URLUtils.removeFragment(chunk.dst), e);
            }
        });
    }

    private void rewriteTopicrefs(URI mapFile, List<ChunkOperation> chunks) {
        for (ChunkOperation chunk : chunks) {
            URI dst = URLUtils.getRelativePath(mapFile.resolve("."), chunk.dst);
            if (!Constants.MAP_MAP.matches(chunk.topicref)) {
                chunk.topicref.setAttribute("href", dst.toString());
            }
            if (Constants.MAPGROUP_D_TOPICGROUP.matches(chunk.topicref)) {
                chunk.topicref.setAttribute("class", Constants.MAP_TOPICREF.toString());
            }
            this.rewriteTopicrefs(mapFile, chunk.children);
        }
    }

    private void rewriteLinks(Document chunkDoc, ChunkOperation chunk, Map<URI, URI> rewriteMap) {
        List<Element> elements = XMLUtils.toList(chunkDoc.getDocumentElement().getElementsByTagName("*"));
        for (Element link : elements) {
            URI rel;
            if (!Constants.TOPIC_LINK.matches(link) && !Constants.TOPIC_XREF.matches(link)) continue;
            URI href = URLUtils.toURI(link.getAttribute("href"));
            URI abs = chunk.src.resolve(href);
            URI rewrite = rewriteMap.get(abs);
            if (rewrite != null) {
                rel = URLUtils.getRelativePath(chunk.src.resolve("."), rewrite);
                link.setAttribute("href", rel.toString());
                continue;
            }
            rel = URLUtils.getRelativePath(chunk.src.resolve("."), abs);
            link.setAttribute("href", rel.toString());
        }
    }

    private List<ChunkOperation> rewrite(URI mapFile, Map<URI, URI> rewriteMap, List<ChunkOperation> chunks) {
        ArrayList<ChunkOperation> list = new ArrayList<ChunkOperation>();
        for (ChunkOperation rootChunk : chunks) {
            list.add(this.rewriteChunk(mapFile, rewriteMap, rootChunk).build());
        }
        return Collections.unmodifiableList(list);
    }

    private ChunkOperation.ChunkBuilder rewriteChunk(URI mapFile, Map<URI, URI> rewriteMap, ChunkOperation rootChunk) {
        URI dst;
        String id;
        if (Constants.MAP_MAP.matches(rootChunk.topicref)) {
            id = rootChunk.topicref.getAttribute("id");
            if (id.isEmpty()) {
                id = FileUtils.replaceExtension(FileUtils.getName(mapFile.getPath()), "");
            }
            dst = URI.create(FileUtils.replaceExtension(mapFile.toString(), ".dita"));
            Collection<URI> collection = rewriteMap.values();
        } else {
            id = rootChunk.src != null && rootChunk.src.getFragment() != null ? rootChunk.src.getFragment() : (rootChunk.src != null ? this.getRootTopicId(rootChunk.src) : null);
            dst = rootChunk.src != null ? URLUtils.setFragment(rootChunk.src, id) : mapFile.resolve("Chunk1.dita");
            Collection<URI> values = rewriteMap.values();
            int i = 1;
            while (id == null || values.contains(dst)) {
                id = GEN_CHUNK_PREFIX + i;
                dst = URLUtils.setFragment(rootChunk.src != null ? URLUtils.setFragment(rootChunk.src, id) : mapFile.resolve(id + ".dita"), id);
                ++i;
            }
        }
        ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(rootChunk.operation).topicref(rootChunk.topicref).src(rootChunk.src).dst(dst).id(id);
        rewriteMap.put(rootChunk.src, dst);
        for (ChunkOperation child : rootChunk.children) {
            ChunkOperation.ChunkBuilder childBuilder = this.rewriteChunkChild(rewriteMap, rootChunk.src != null ? rootChunk.src : dst, child);
            builder.addChild(childBuilder);
        }
        return builder;
    }

    private ChunkOperation.ChunkBuilder rewriteChunkChild(Map<URI, URI> rewriteMap, URI rootChunkSrc, ChunkOperation chunk) {
        String id = chunk.src != null && chunk.src.getFragment() != null ? chunk.src.getFragment() : (chunk.src != null ? this.getRootTopicId(chunk.src) : null);
        URI dst = URLUtils.setFragment(rootChunkSrc, id);
        Collection<URI> values = rewriteMap.values();
        int i = 1;
        while (id == null || values.contains(dst)) {
            id = GEN_UNIQUE_PREFIX + i;
            dst = URLUtils.setFragment(rootChunkSrc, id);
            ++i;
        }
        ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(chunk.operation).topicref(chunk.topicref).src(chunk.src).dst(dst).id(id);
        rewriteMap.put(chunk.src, dst);
        for (ChunkOperation child : chunk.children) {
            builder.addChild(this.rewriteChunkChild(rewriteMap, rootChunkSrc, child));
        }
        return builder;
    }

    private String getRootTopicId(URI src) {
        this.logger.debug("Get root ID from {0}", src);
        try {
            XdmNode node = this.job.getStore().getImmutableNode(src);
            Step firstTopicId = Steps.descendant(Constants.TOPIC_TOPIC.matcher()).first().then(Steps.attribute((String)"id"));
            return node.select(firstTopicId).asString();
        }
        catch (IOException e) {
            this.logger.error("Failed to read root ID from {0}", src, e);
            return null;
        }
    }

    private Document merge(ChunkOperation rootChunk) throws IOException {
        Document doc;
        if (rootChunk.src != null) {
            Element dstTopic = this.getElement(rootChunk.src);
            doc = dstTopic.getOwnerDocument();
            if (dstTopic.getNodeName().equals("dita")) {
                dstTopic = this.getLastChildTopic(dstTopic);
            } else {
                Element ditaWrapper = this.createDita(doc);
                doc.replaceChild(ditaWrapper, doc.getDocumentElement());
                if (dstTopic.getParentNode() != null) {
                    dstTopic = (Element)dstTopic.getParentNode().removeChild(dstTopic);
                }
                ditaWrapper.appendChild(dstTopic);
            }
            this.mergeTopic(rootChunk, rootChunk, dstTopic);
        } else {
            Element navtitle = this.getNavtitle(rootChunk.topicref);
            if (navtitle != null) {
                doc = XMLUtils.getDocumentBuilder().newDocument();
                Element ditaWrapper = this.createDita(doc);
                doc.appendChild(ditaWrapper);
                Element topic = this.createTopic(doc, rootChunk.id);
                topic.appendChild(this.createTitle(doc, navtitle));
                ditaWrapper.appendChild(topic);
                this.mergeTopic(rootChunk, rootChunk, topic);
            } else {
                doc = XMLUtils.getDocumentBuilder().newDocument();
                Element ditaWrapper = this.createDita(doc);
                doc.appendChild(ditaWrapper);
                this.mergeTopic(rootChunk, rootChunk, ditaWrapper);
            }
        }
        return doc;
    }

    private Element createTitle(Document doc, Element src) {
        Element title = doc.createElement(Constants.TOPIC_TITLE.localName);
        title.setAttribute("class", Constants.TOPIC_TITLE.toString());
        List<Node> children = XMLUtils.toList(src.getChildNodes());
        for (Node child : children) {
            title.appendChild(doc.importNode(child, true));
        }
        return title;
    }

    private Element createDita(Document doc) {
        Element ditaWrapper = doc.createElement("dita");
        ditaWrapper.setAttributeNS("http://dita.oasis-open.org/architecture/2005/", "ditaarch:DITAArchVersion", "2.0");
        return ditaWrapper;
    }

    private void mergeTopic(ChunkOperation rootChunk, ChunkOperation chunk, Element dstTopic) throws IOException {
        for (ChunkOperation child : chunk.children) {
            Element added;
            if (child.src != null) {
                Element root = this.getElement(child.src);
                if (root.getNodeName().equals("dita")) {
                    List<Element> rootTopics = XMLUtils.getChildElements(root, Constants.TOPIC_TOPIC);
                    boolean i = true;
                    for (Element topic : rootTopics) {
                        Element imported = (Element)dstTopic.getOwnerDocument().importNode(topic, true);
                        this.rewriteTopicId(imported, child.id);
                        this.relativizeLinks(imported, child.src, rootChunk.dst);
                        added = (Element)dstTopic.appendChild(imported);
                    }
                    this.mergeTopic(rootChunk, child, dstTopic);
                    continue;
                }
                Element imported = (Element)dstTopic.getOwnerDocument().importNode(root, true);
                this.rewriteTopicId(imported, child.id);
                this.relativizeLinks(imported, child.src, rootChunk.dst);
                added = (Element)dstTopic.appendChild(imported);
                this.mergeTopic(rootChunk, child, added);
                continue;
            }
            Element imported = this.createTopic(dstTopic.getOwnerDocument(), child.id);
            Element navtitle = this.getNavtitle(child.topicref);
            if (navtitle != null) {
                imported.appendChild(this.createTitle(dstTopic.getOwnerDocument(), navtitle));
            }
            added = (Element)dstTopic.appendChild(imported);
            this.mergeTopic(rootChunk, child, added);
        }
    }

    private Element getElement(URI src) throws IOException {
        this.logger.info("Reading {0}", src);
        Document chunkDoc = this.job.getStore().getDocument(src);
        if (src.getFragment() != null) {
            NodeList children = chunkDoc.getElementsByTagName("*");
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!Constants.TOPIC_TOPIC.matches(child) || !((Element)child).getAttribute("id").equals(src.getFragment())) continue;
                return (Element)child;
            }
            return null;
        }
        return chunkDoc.getDocumentElement();
    }

    private Element getLastChildTopic(Element dita) {
        List<Element> childElements = XMLUtils.getChildElements(dita, Constants.TOPIC_TOPIC);
        if (childElements.isEmpty()) {
            return null;
        }
        return childElements.get(childElements.size() - 1);
    }

    private Element createTopic(Document doc, String id) {
        Element imported = doc.createElement(Constants.TOPIC_TOPIC.localName);
        imported.setAttribute("class", Constants.TOPIC_TOPIC.toString());
        imported.setAttribute("id", id);
        return imported;
    }

    private void rewriteTopicId(Element topic, String id) {
        topic.setAttribute("id", id);
    }

    private void relativizeLinks(Element topic, URI src, URI dst) {
        List<Element> elements = XMLUtils.toList(topic.getElementsByTagName("*"));
        for (Element link : elements) {
            if (!Constants.TOPIC_LINK.matches(link) && !Constants.TOPIC_XREF.matches(link)) continue;
            URI href = URLUtils.toURI(link.getAttribute("href"));
            URI abs = src.resolve(href);
            URI rel = URLUtils.getRelativePath(dst.resolve("."), abs);
            link.setAttribute("href", rel.toString());
        }
    }

    private List<ChunkOperation> collectChunkOperations(URI mapFile, Document mapDoc) {
        this.logger.debug("Collect chunk operations");
        ArrayList<ChunkOperation> chunks = new ArrayList<ChunkOperation>();
        this.collectChunkOperations(mapFile, mapDoc.getDocumentElement(), chunks);
        return Collections.unmodifiableList(chunks);
    }

    private void collectChunkOperations(URI mapFile, Element elem, List<ChunkOperation> chunks) {
        String chunk = elem.getAttribute("chunk");
        if (chunk.equals(ChunkOperation.Operation.COMBINE.name)) {
            if (Constants.MAP_MAP.matches(elem)) {
                URI href = URI.create(FileUtils.replaceExtension(mapFile.toString(), ".dita"));
                ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).dst(href).topicref(elem);
                XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF).stream().flatMap(child -> this.collect(mapFile, (Element)child).stream()).forEachOrdered(builder::addChild);
                elem.removeAttribute("chunk");
                chunks.add(builder.build());
                return;
            }
            Attr hrefNode = elem.getAttributeNode("href");
            URI href = hrefNode != null ? mapFile.resolve(hrefNode.getValue()) : null;
            ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).src(href).topicref(elem);
            XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF).stream().flatMap(child -> this.collect(mapFile, (Element)child).stream()).forEachOrdered(builder::addChild);
            elem.removeAttribute("chunk");
            chunks.add(builder.build());
            return;
        }
        for (Element child2 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
            this.collectChunkOperations(mapFile, child2, chunks);
        }
    }

    private List<ChunkOperation.ChunkBuilder> collect(URI mapFile, Element elem) {
        Attr hrefNode = elem.getAttributeNode("href");
        Element navtitle = this.getNavtitle(elem);
        if (hrefNode != null && this.isDitaFormat(elem) && ChunkModule.isLocalScope(elem)) {
            URI href = mapFile.resolve(hrefNode.getValue());
            ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).src(href).topicref(elem);
            for (Element child2 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                for (ChunkOperation.ChunkBuilder chunkBuilder : this.collect(mapFile, child2)) {
                    builder.addChild(chunkBuilder);
                }
            }
            return Collections.singletonList(builder);
        }
        if (navtitle != null) {
            ChunkOperation.ChunkBuilder builder = new ChunkOperation.ChunkBuilder(ChunkOperation.Operation.COMBINE).topicref(elem);
            for (Element child3 : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                for (ChunkOperation.ChunkBuilder chunkBuilder : this.collect(mapFile, child3)) {
                    builder.addChild(chunkBuilder);
                }
            }
            return Collections.singletonList(builder);
        }
        return XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF).stream().flatMap(child -> this.collect(mapFile, (Element)child).stream()).collect(Collectors.toList());
    }

    private Element getNavtitle(Element topicref) {
        if (topicref != null) {
            return XMLUtils.getChildElement(topicref, Constants.MAP_TOPICMETA).flatMap(topicmeta -> XMLUtils.getChildElement(topicmeta, Constants.TOPIC_NAVTITLE)).orElse(null);
        }
        return null;
    }

    public boolean isDitaFormat(Element elem) {
        String format = elem.getAttribute("format");
        return this.isDitaFormat(format);
    }

    public boolean isDitaFormat(String format) {
        return format == null || format.isEmpty() || format.equals("dita");
    }

    public static boolean isLocalScope(Element elem) {
        String scope = elem.getAttribute("scope");
        return ChunkModule.isLocalScope(scope);
    }

    public static boolean isLocalScope(String scope) {
        return scope == null || scope.isEmpty() || scope.equals("local");
    }

    public static Float getDitaVersion(Element topic) {
        String ditaVersion = topic.getAttributeNS("http://dita.oasis-open.org/architecture/2005/", "DITAArchVersion");
        if (!ditaVersion.isEmpty()) {
            try {
                return new Float(ditaVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

