/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.chunk;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

class ChunkOperation {
    public final Operation operation;
    public final URI src;
    public final URI dst;
    public final String id;
    public final Element topicref;
    public final List<ChunkOperation> children;

    @VisibleForTesting
    ChunkOperation(Operation operation, URI src, URI dst, String id, Element topicref, List<ChunkOperation> children) {
        this.operation = operation;
        this.src = src;
        this.dst = dst;
        this.id = id;
        this.topicref = topicref;
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkOperation that = (ChunkOperation)o;
        return this.operation == that.operation && Objects.equals(this.src, that.src) && Objects.equals(this.dst, that.dst) && Objects.equals(this.id, that.id) && Objects.equals(this.topicref, that.topicref) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.src, this.dst, this.id, this.topicref, this.children});
    }

    public String toString() {
        return "ChunkOperation{operation=" + (Object)((Object)this.operation) + ", src=" + this.src + ", dst=" + this.dst + ", id=" + this.id + ", children=" + this.children + '}';
    }

    public static ChunkBuilder builder(Operation operation) {
        return new ChunkBuilder(operation);
    }

    public static class ChunkBuilder {
        private final Operation operation;
        private URI src;
        private URI dst;
        private String id;
        private Element topicref;
        private List<ChunkBuilder> children = new ArrayList<ChunkBuilder>();

        public ChunkBuilder(Operation operation) {
            this.operation = operation;
        }

        public ChunkBuilder src(URI src) {
            this.src = src;
            return this;
        }

        public ChunkBuilder dst(URI dst) {
            this.dst = dst;
            return this;
        }

        public ChunkBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ChunkBuilder topicref(Element topicref) {
            this.topicref = topicref;
            return this;
        }

        public ChunkBuilder addChild(ChunkBuilder child) {
            this.children.add(child);
            return this;
        }

        public ChunkOperation build() {
            URI src = this.src;
            URI dst = this.dst;
            List cos = this.children.stream().map(ChunkBuilder::build).collect(Collectors.toList());
            return new ChunkOperation(this.operation, src, dst, this.id, this.topicref, Collections.unmodifiableList(cos));
        }
    }

    public static enum Operation {
        COMBINE("combine"),
        SPLIT("split");

        public final String name;

        private Operation(String name) {
            this.name = name;
        }
    }
}

