/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.exception;

import org.dita.dost.exception.SAXExceptionWrapper;
import org.dita.dost.log.DITAOTLogger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DITAOTXMLErrorHandler
implements ErrorHandler {
    private final String filePath;
    private final DITAOTLogger logger;

    public DITAOTXMLErrorHandler(String file, DITAOTLogger logger) {
        this.filePath = file;
        this.logger = logger;
    }

    @Override
    public void error(SAXParseException saxException) throws SAXException {
        throw new SAXExceptionWrapper(this.filePath, saxException);
    }

    @Override
    public void fatalError(SAXParseException saxException) throws SAXException {
        throw new SAXExceptionWrapper(this.filePath, saxException);
    }

    @Override
    public void warning(SAXParseException saxException) throws SAXException {
        String msg = new SAXExceptionWrapper(this.filePath, saxException).getMessage();
        this.logger.warn(msg);
    }
}

