/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.dita.dost.invoker.ArgumentParser;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.Main;
import org.dita.dost.invoker.UsageBuilder;
import org.dita.dost.platform.Plugins;
import org.dita.dost.util.XMLUtils;

public class ConversionArguments
extends Arguments {
    private static final Set<String> LAUNCH_COMMANDS = ImmutableSet.of((Object)"-lib", (Object)"-cp", (Object)"-noclasspath", (Object)"-nouserlib", (Object)"-main");
    private static final Map<String, Arguments.Argument> ARGUMENTS = new HashMap<String, Arguments.Argument>();
    private static final Map<String, String> RESERVED_PROPERTIES;
    File projectFile;
    int repeat = 1;
    public final List<String> inputs = new ArrayList<String>();
    private final List<String> resources = new ArrayList<String>();
    private final Vector<String> targets = new Vector();
    private final Vector<String> listeners = new Vector(1);
    private final Vector<String> propertyFiles = new Vector(1);

    @Override
    ConversionArguments parse(String[] arguments) {
        ArrayDeque<String> args = new ArrayDeque<String>(Arrays.asList(arguments));
        while (!args.isEmpty()) {
            String arg = (String)args.pop();
            if (arg.equals("help") || this.isLongForm(arg, "-help") || arg.equals("-h")) {
                this.justPrintUsage = true;
                continue;
            }
            if (this.isLongForm(arg, "-project") || arg.equals("-p")) {
                this.handleArgProject(arg, args);
                continue;
            }
            if (this.isLongForm(arg, "-diagnostics")) {
                this.justPrintDiagnostics = true;
                continue;
            }
            if (this.isLongForm(arg, "-verbose") || arg.equals("-v")) {
                this.msgOutputLevel = 2;
                continue;
            }
            if (this.isLongForm(arg, "-debug") || arg.equals("-d")) {
                this.msgOutputLevel = 3;
                continue;
            }
            if (this.isLongForm(arg, "-noinput")) {
                this.allowInput = false;
                continue;
            }
            if (this.isLongForm(arg, "-logfile") || arg.equals("-l")) {
                this.handleArgLogFile(arg, args);
                continue;
            }
            if (this.isLongForm(arg, "-buildfile") || this.isLongForm(arg, "-file")) {
                this.handleArgBuildFile(args);
                continue;
            }
            if (this.isLongForm(arg, "-listener")) {
                this.handleArgListener(args);
                continue;
            }
            if (arg.startsWith("-D")) {
                this.definedProps.putAll(this.handleArgDefine(arg, args));
                continue;
            }
            if (this.isLongForm(arg, "-logger")) {
                this.handleArgLogger(args);
                continue;
            }
            if (this.isLongForm(arg, "-inputhandler")) {
                this.handleArgInputHandler(args);
                continue;
            }
            if (this.isLongForm(arg, "-emacs") || arg.equals("-e")) {
                this.emacsMode = true;
                continue;
            }
            if (this.isLongForm(arg, "-propertyfile")) {
                this.handleArgPropertyFile(arg, args);
                continue;
            }
            if (arg.equals("-k") || this.isLongForm(arg, "-keep-going")) {
                this.keepGoingMode = true;
                continue;
            }
            if (this.isLongForm(arg, "-nice")) {
                this.handleArgNice(args);
                continue;
            }
            if (this.isLongForm(arg, "-input") || arg.equals("-i")) {
                this.handleArgInput(arg, args, ARGUMENTS.get(this.getArgumentName(arg)));
                continue;
            }
            if (this.isLongForm(arg, "-filter")) {
                this.handleArgFilter(arg, args, ARGUMENTS.get(this.getArgumentName(arg)));
                continue;
            }
            if (this.isLongForm(arg, "-resource") || arg.equals("-r")) {
                this.handleArgResource(arg, args, ARGUMENTS.get(this.getArgumentName(arg)));
                continue;
            }
            if (this.isLongForm(arg, "-repeat")) {
                this.handleArgRepeat(arg, args);
                continue;
            }
            if (ARGUMENTS.containsKey(this.getArgumentName(arg))) {
                this.definedProps.putAll(this.handleParameterArg(arg, args, ARGUMENTS.get(this.getArgumentName(arg))));
                continue;
            }
            if (ArgumentParser.getPluginArguments().containsKey(this.getArgumentName(arg))) {
                this.definedProps.putAll(this.handleParameterArg(arg, args, ArgumentParser.getPluginArguments().get(this.getArgumentName(arg))));
                continue;
            }
            if (LAUNCH_COMMANDS.contains(arg)) {
                String msg = "Ant's Main method is being handed an option " + arg + " that is only for the launcher class.\nThis can be caused by a version mismatch between the ant script/.bat file and Ant itself.";
                throw new BuildException(msg);
            }
            if (this.isLongForm(arg, "-autoproxy")) {
                this.proxy = true;
                continue;
            }
            if (arg.startsWith("-") || arg.startsWith("/")) {
                this.parseCommonOptions(arg, args);
                continue;
            }
            this.targets.addElement(arg);
        }
        if (!this.inputs.isEmpty()) {
            this.definedProps.put("args.input", this.inputs.get(0));
        }
        if (!this.resources.isEmpty()) {
            this.definedProps.put("args.resources", String.join((CharSequence)File.pathSeparator, this.resources));
        }
        this.definedProps.putAll(this.loadPropertyFiles());
        return this;
    }

    private void handleArgProject(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null) {
            throw new BuildException("Missing value for project " + entry.getKey());
        }
        this.projectFile = new File(entry.getValue()).getAbsoluteFile();
    }

    private Map<String, Object> handleArgDefine(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg.substring(2), args);
        if (entry.getValue() == null) {
            throw new BuildException("Missing value for property " + entry.getKey());
        }
        if (RESERVED_PROPERTIES.containsKey(entry.getKey())) {
            throw new BuildException("Property " + entry.getKey() + " cannot be set with -D, use " + RESERVED_PROPERTIES.get(entry.getKey()) + " instead");
        }
        return ImmutableMap.of((Object)entry.getKey(), (Object)entry.getValue());
    }

    private void handleArgInput(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null) {
            throw new BuildException("Missing value for input " + entry.getKey());
        }
        this.inputs.add(argument.getValue(entry.getValue()));
    }

    private void handleArgFilter(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null) {
            throw new BuildException("Missing value for input " + entry.getKey());
        }
        Object prev = this.definedProps.get(argument.property);
        String value = prev != null ? prev + File.pathSeparator + argument.getValue(entry.getValue()) : argument.getValue(entry.getValue());
        this.definedProps.put(argument.property, value);
    }

    private void handleArgResource(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null) {
            throw new BuildException("Missing value for resource " + entry.getKey());
        }
        this.resources.add(argument.getValue(entry.getValue()));
    }

    private Map<String, Object> handleParameterArg(String arg, Deque<String> args, Arguments.Argument argument) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null) {
            throw new BuildException("Missing value for property " + entry.getKey());
        }
        return ImmutableMap.of((Object)argument.property, (Object)argument.getValue(entry.getValue()));
    }

    private String getArgumentName(String arg) {
        int pos = arg.indexOf("=");
        if (pos == -1) {
            pos = arg.indexOf(":");
        }
        return arg.substring(0, pos != -1 ? pos : arg.length());
    }

    private void handleArgLogger(Deque<String> args) {
        if (this.loggerClassname != null) {
            throw new BuildException("Only one logger class may be specified.");
        }
        this.loggerClassname = args.pop();
        if (this.loggerClassname == null) {
            throw new BuildException("You must specify a classname when using the -logger argument");
        }
    }

    private void handleArgInputHandler(Deque<String> args) {
        if (this.inputHandlerClassname != null) {
            throw new BuildException("Only one input handler class may be specified.");
        }
        this.inputHandlerClassname = args.pop();
        if (this.inputHandlerClassname == null) {
            throw new BuildException("You must specify a classname when using the --inputhandler argument");
        }
    }

    private void handleArgPropertyFile(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg.substring(2), args);
        if (entry.getValue() == null) {
            throw new BuildException("You must specify a property filename when using the --propertyfile argument");
        }
        this.propertyFiles.addElement(entry.getValue());
    }

    private void handleArgRepeat(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg.substring(2), args);
        if (entry.getValue() == null) {
            throw new BuildException("You must repeat number");
        }
        this.repeat = Integer.parseInt(entry.getValue());
    }

    private void handleArgNice(Deque<String> args) {
        String value = args.pop();
        if (value == null) {
            throw new BuildException("You must supply a niceness value (1-10) after the --nice option");
        }
        try {
            this.threadPriority = Integer.decode(value);
        }
        catch (NumberFormatException e) {
            throw new BuildException("Unrecognized niceness value: " + value);
        }
        if (this.threadPriority < 1 || this.threadPriority > 10) {
            throw new BuildException("Niceness value is out of the range 1-10");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadPropertyFiles() {
        HashMap<String, Object> definedProps = new HashMap<String, Object>();
        for (int propertyFileIndex = 0; propertyFileIndex < this.propertyFiles.size(); ++propertyFileIndex) {
            String filename = this.propertyFiles.elementAt(propertyFileIndex);
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filename);
                props.load(fis);
            }
            catch (IOException e) {
                try {
                    System.out.println("Could not load property file " + filename + ": " + e.getMessage());
                }
                catch (Throwable throwable) {
                    FileUtils.close(fis);
                    throw throwable;
                }
                FileUtils.close((InputStream)fis);
            }
            FileUtils.close((InputStream)fis);
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = propertyNames.nextElement().toString();
                if (definedProps.containsKey(name)) continue;
                Arguments.Argument arg = ArgumentParser.getPluginArguments().get("--" + name);
                String value = props.getProperty(name);
                if (arg != null) {
                    definedProps.put(name, arg.getValue(value));
                    continue;
                }
                definedProps.put(name, value);
            }
        }
        return definedProps;
    }

    @Override
    void printUsage(boolean compact) {
        UsageBuilder buf = UsageBuilder.builder(compact).usage(Main.locale.getString("conversion.usage.input")).usage(Main.locale.getString("conversion.usage.project")).subcommands("deliverables", Main.locale.getString("conversion.subcommand.deliverables")).subcommands("install", Main.locale.getString("conversion.subcommand.install")).subcommands("plugins", Main.locale.getString("conversion.subcommand.plugins")).subcommands("transtypes", Main.locale.getString("conversion.subcommand.transtypes")).subcommands("uninstall", Main.locale.getString("conversion.subcommand.uninstall")).subcommands("version", Main.locale.getString("conversion.subcommand.version")).arguments("i", "input", "file", Main.locale.getString("conversion.argument.input")).arguments("f", "format", "name", Main.locale.getString("conversion.argument.format")).arguments("p", "project", "file", Main.locale.getString("conversion.argument.project")).options("r", "resource", "file", Main.locale.getString("conversion.option.resource")).options(null, "filter", "files", Main.locale.getString("conversion.option.filter")).options("o", "output", "dir", Main.locale.getString("conversion.option.output"));
        if (!compact) {
            buf.options("l", "logfile", "file", Main.locale.getString("conversion.option.logfile")).options(null, "propertyfile", "file", Main.locale.getString("conversion.option.propertyfile")).options(null, "repeat", "num", Main.locale.getString("conversion.option.repeat")).options("t", "temp", "dir", Main.locale.getString("conversion.option.temp"));
            Set builtin = ARGUMENTS.values().stream().map(arg -> arg.property).collect(Collectors.toSet());
            List params = XMLUtils.toList(Plugins.getPluginConfiguration().getElementsByTagName("param"));
            params.stream().map(ArgumentParser::getArgument).filter(a -> !builtin.contains(a.property)).collect(Collectors.toMap(arg -> arg.property, arg -> arg, ArgumentParser::mergeArguments)).values().stream().sorted(Comparator.comparing(o -> o.property)).forEach(arg -> {
                if (arg instanceof Arguments.FileArgument) {
                    buf.options(null, arg.property, "file", arg.desc);
                } else if (arg instanceof Arguments.BooleanArgument) {
                    buf.options(null, arg.property, "yes|no", arg.desc);
                } else if (arg instanceof Arguments.EnumArgument) {
                    buf.options(null, arg.property, String.join((CharSequence)"|", ((Arguments.EnumArgument)arg).values), arg.desc);
                } else {
                    buf.options(null, arg.property, "value", arg.desc);
                }
            });
        } else {
            buf.footer(Main.locale.getString("conversion.footer"));
        }
        buf.print();
    }

    static {
        ARGUMENTS.put("-f", new Arguments.StringArgument("transtype", null));
        ARGUMENTS.put("--format", new Arguments.StringArgument("transtype", null));
        ARGUMENTS.put("--transtype", new Arguments.StringArgument("transtype", null));
        ARGUMENTS.put("--deliverable", new Arguments.StringArgument("project.deliverable", null));
        ARGUMENTS.put("-i", new Arguments.FileOrUriArgument("args.input", null));
        ARGUMENTS.put("--input", new Arguments.FileOrUriArgument("args.input", null));
        ARGUMENTS.put("-r", new Arguments.FileOrUriArgument("args.resources", null));
        ARGUMENTS.put("--resource", new Arguments.FileOrUriArgument("args.resources", null));
        ARGUMENTS.put("-o", new Arguments.AbsoluteFileArgument("output.dir", null));
        ARGUMENTS.put("--output", new Arguments.AbsoluteFileArgument("output.dir", null));
        ARGUMENTS.put("--filter", new Arguments.AbsoluteFileListArgument("args.filter", null));
        ARGUMENTS.put("-t", new Arguments.AbsoluteFileArgument("dita.temp.dir", null));
        ARGUMENTS.put("--temp", new Arguments.AbsoluteFileArgument("dita.temp.dir", null));
        ARGUMENTS.put("-p", new Arguments.AbsoluteFileArgument("project.file", null));
        ARGUMENTS.put("--project", new Arguments.AbsoluteFileArgument("project.file", null));
        for (Map.Entry<String, Arguments.Argument> e : new HashSet<Map.Entry<String, Arguments.Argument>>(ARGUMENTS.entrySet())) {
            if (!e.getKey().startsWith("--")) continue;
            ARGUMENTS.put(e.getKey().substring(1), e.getValue());
        }
        RESERVED_PROPERTIES = ImmutableMap.of((Object)"transtype", (Object)"-f", (Object)"args.input", (Object)"-i", (Object)"output.dir", (Object)"-o", (Object)"args.filter", (Object)"--filter", (Object)"dita.temp.dir", (Object)"-t");
    }
}

