/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

class DefaultLogger
implements BuildLogger {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BOLD = "\u001b[1m";
    private static final int LEFT_COLUMN_SIZE = 12;
    private PrintStream out;
    private PrintStream err;
    private int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();
    protected static final String lSep = StringUtils.LINE_SEP;
    private boolean emacsMode = false;
    private boolean useColor = false;

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = new PrintStream(err, true);
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void useColor(boolean useColor) {
        this.useColor = useColor;
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    private static void throwableMessage(StringBuilder m, Throwable error, boolean verbose) {
        String msg = error.getMessage();
        int i = msg.indexOf(": ");
        if (i != -1) {
            msg = msg.substring(i + 1).trim();
        }
        m.append(msg);
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuilder message = new StringBuilder();
        if (error != null) {
            message.append("Error: ");
            DefaultLogger.throwableMessage(message, error, 3 <= this.msgOutputLevel);
        }
        String msg = message.toString();
        if (error == null && !msg.trim().isEmpty()) {
            this.printMessage(msg, this.out, 3);
        } else if (!msg.isEmpty()) {
            this.printMessage(msg, this.err, 0);
        }
        this.log(msg);
    }

    protected String getBuildFailedMessage() {
        return "BUILD FAILED";
    }

    protected String getBuildSuccessfulMessage() {
        return "BUILD SUCCESSFUL";
    }

    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel && !event.getTarget().getName().equals("")) {
            String msg = StringUtils.LINE_SEP + event.getTarget().getName() + ":";
            this.printMessage(msg, this.out, event.getPriority());
            this.log(msg);
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void messageLogged(BuildEvent event) {
        priority = event.getPriority();
        if (priority <= this.msgOutputLevel) {
            block17: {
                message = new StringBuilder();
                if (event.getTask() != null && !this.emacsMode) {
                    name = event.getTask().getTaskName();
                    label = "[" + name + "] ";
                    size = 12 - label.length();
                    tmp = new StringBuilder();
                    for (i = 0; i < size; ++i) {
                        tmp.append(" ");
                    }
                    tmp.append(label);
                    label = tmp.toString();
                    r = null;
                    try {
                        r = new BufferedReader(new StringReader(event.getMessage()));
                        line = r.readLine();
                        first = true;
                        do {
                            if (first) {
                                if (line == null) {
                                    message.append(label);
                                    break;
                                }
                            } else {
                                message.append(StringUtils.LINE_SEP);
                            }
                            first = false;
                            message.append(label).append(line);
                        } while ((line = r.readLine()) != null);
                        ** if (r == null) goto lbl-1000
                    }
                    catch (IOException e) {
                        try {
                            message.append(label).append(event.getMessage());
                            ** if (r == null) goto lbl-1000
                        }
                        catch (Throwable var11_13) {
                            if (r != null) {
                                FileUtils.close(r);
                            }
                            throw var11_13;
                        }
lbl-1000:
                        // 1 sources

                        {
                            FileUtils.close((Reader)r);
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block17;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        FileUtils.close((Reader)r);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block17;
                    }
                }
                message.append(event.getMessage());
            }
            ex = event.getException();
            if (4 <= this.msgOutputLevel && ex != null) {
                message.append(StringUtils.getStackTrace((Throwable)ex));
            }
            msg = message.toString();
            if (priority != 0) {
                this.printMessage(msg, this.out, priority);
            } else {
                this.printMessage(msg, this.err, priority);
            }
            this.log(msg);
        }
    }

    protected static String formatTime(long millis) {
        return DateUtils.formatElapsedTime((long)millis);
    }

    private void printMessage(String message, PrintStream stream, int priority) {
        if (this.useColor && priority == 0) {
            stream.print(ANSI_RED);
            stream.print(message);
            stream.println(ANSI_RESET);
        } else {
            stream.println(message);
        }
    }

    private void log(String message) {
    }

    protected String getTimestamp() {
        Date date = new Date(System.currentTimeMillis());
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        return formatter.format(date);
    }

    protected String extractProjectName(BuildEvent event) {
        Project project = event.getProject();
        return project != null ? project.getName() : null;
    }
}

