/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.property.GetProperty;
import org.apache.tools.ant.property.ResolvePropertyMap;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ProxySetup;
import org.dita.dost.invoker.ArgumentParser;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.ConversionArguments;
import org.dita.dost.invoker.DefaultLogger;
import org.dita.dost.invoker.DeliverablesArguments;
import org.dita.dost.invoker.InstallArguments;
import org.dita.dost.invoker.PluginsArguments;
import org.dita.dost.invoker.TranstypesArguments;
import org.dita.dost.invoker.UninstallArguments;
import org.dita.dost.invoker.VersionArguments;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.platform.Plugins;
import org.dita.dost.project.Project;
import org.dita.dost.project.ProjectFactory;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.URLUtils;

public class Main
extends org.apache.tools.ant.Main
implements AntMain {
    private static final String ANT_ARGS_INPUT = "args.input";
    static final String ANT_ARGS_RESOURCES = "args.resources";
    static final String ANT_ARGS_INPUTS = "args.inputs";
    protected static final String ANT_OUTPUT_DIR = "output.dir";
    private static final String ANT_BASE_TEMP_DIR = "base.temp.dir";
    private static final String ANT_TRANSTYPE = "transtype";
    private static final String ANT_PLUGIN_FILE = "plugin.file";
    private static final String ANT_PLUGIN_ID = "plugin.id";
    private static final Map<String, String> RESERVED_PARAMS = ImmutableMap.of((Object)"output.dir", (Object)"output", (Object)"transtype", (Object)"transtype", (Object)"args.input", (Object)"input", (Object)"args.filter", (Object)"profiles");
    private File buildFile;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private final Vector<String> targets = new Vector();
    private List<Map<String, Object>> projectProps;
    private int repeat;
    private boolean readyToRun = false;
    private final ArgumentParser argumentParser = new ArgumentParser();
    private Arguments args;
    static final ResourceBundle locale = ResourceBundle.getBundle("cli", new Locale("en", "US"));

    private void printMessage(Throwable t) {
        String message = t.getMessage();
        if (message != null && !message.trim().isEmpty()) {
            this.printErrorMessage("" + message);
        }
    }

    private void printErrorMessage(String msg) {
        if (this.args != null && this.args.useColor) {
            System.err.print("\u001b[31m");
            System.err.print(String.format(locale.getString("error_msg"), msg));
            System.err.println("\u001b[0m");
        } else {
            System.err.println(String.format(locale.getString("error_msg"), msg));
        }
        System.err.println();
    }

    public static void start(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        Main m = new Main();
        m.startAnt(args, additionalUserProperties, coreLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnt(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        try {
            this.processArgs(args);
        }
        catch (BuildException exc) {
            this.handleLogfile();
            this.printMessage(exc);
            this.exit(1);
            return;
        }
        catch (RuntimeException e) {
            this.handleLogfile();
            e.printStackTrace();
            this.exit(1);
            return;
        }
        catch (Throwable exc) {
            this.handleLogfile();
            this.printMessage(exc);
            this.exit(1);
            return;
        }
        if (!this.readyToRun) {
            return;
        }
        if (additionalUserProperties != null) {
            for (Map<String, Object> props : this.projectProps) {
                Enumeration<Object> e = additionalUserProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String property = additionalUserProperties.getProperty(key);
                    props.put(key, property);
                }
            }
        }
        int exitCode = 1;
        try {
            int i;
            long[] durations = new long[this.repeat];
            for (i = 0; i < this.repeat; ++i) {
                long start;
                block22: {
                    start = System.currentTimeMillis();
                    try {
                        for (Map<String, Object> props : this.projectProps) {
                            this.runBuild(coreLoader, props);
                        }
                        exitCode = 0;
                    }
                    catch (ExitStatusException ese) {
                        exitCode = ese.getStatus();
                        if (exitCode == 0) break block22;
                        throw ese;
                    }
                }
                long end = System.currentTimeMillis();
                durations[i] = end - start;
            }
            if (this.repeat > 1) {
                for (i = 0; i < durations.length; ++i) {
                    System.out.println(String.format(locale.getString("conversion.repeatDuration"), i + 1, durations[i]));
                }
            }
        }
        catch (BuildException be) {
            if (err != System.err) {
                this.printMessage(be);
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            this.printMessage(exc);
        }
        finally {
            this.handleLogfile();
        }
        this.exit(exitCode);
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    private void handleLogfile() {
        if (this.args != null && this.args.logFile != null) {
            FileUtils.close((OutputStream)out);
            FileUtils.close((OutputStream)err);
        }
    }

    public static void main(String[] args) {
        Main.start(args, null, null);
    }

    private void processArgs(String[] arguments) {
        Arguments installArgs;
        this.args = this.argumentParser.processArgs(arguments);
        HashMap<String, Object> definedProps = new HashMap<String, Object>(this.args.definedProps);
        this.projectProps = Collections.singletonList(definedProps);
        this.buildFile = this.args.buildFile;
        this.repeat = 1;
        if (this.args.justPrintUsage) {
            this.args.printUsage(false);
            return;
        }
        if (this.args.justPrintDiagnostics) {
            Diagnostics.doReport((PrintStream)System.out, (int)this.args.msgOutputLevel);
            return;
        }
        File integratorFile = this.findBuildFile(System.getProperty("dita.dir"), "integrator.xml");
        if (this.args instanceof PluginsArguments) {
            this.printPlugins();
            return;
        }
        if (this.args instanceof VersionArguments) {
            this.printVersion();
            return;
        }
        if (this.args instanceof TranstypesArguments) {
            this.printTranstypes();
            return;
        }
        if (this.args instanceof DeliverablesArguments) {
            DeliverablesArguments deliverablesArgs = (DeliverablesArguments)this.args;
            if (deliverablesArgs.projectFile == null) {
                this.printErrorMessage(locale.getString("deliverables.error.project_not_defined"));
                this.args.printUsage(true);
                throw new BuildException("");
            }
            this.printDeliverables(deliverablesArgs.projectFile);
            return;
        }
        if (this.args instanceof InstallArguments) {
            installArgs = (InstallArguments)this.args;
            this.buildFile = integratorFile;
            this.targets.clear();
            if (installArgs.installFile != null) {
                this.targets.add("install");
                File f = new File(installArgs.installFile.replace('/', File.separatorChar)).getAbsoluteFile();
                if (f.exists()) {
                    definedProps.put(ANT_PLUGIN_FILE, f.getAbsolutePath());
                } else {
                    definedProps.put(ANT_PLUGIN_FILE, installArgs.installFile);
                }
            } else {
                this.targets.add("integrate");
            }
        } else if (this.args instanceof UninstallArguments) {
            installArgs = (UninstallArguments)this.args;
            if (((UninstallArguments)installArgs).uninstallId == null) {
                this.printErrorMessage(locale.getString("uninstall.error.identifier_not_defined"));
                this.args.printUsage(true);
                throw new BuildException("");
            }
            this.buildFile = integratorFile;
            this.targets.clear();
            this.targets.add("uninstall");
            definedProps.put(ANT_PLUGIN_ID, ((UninstallArguments)installArgs).uninstallId);
        } else if (this.args instanceof ConversionArguments) {
            ConversionArguments conversionArgs = (ConversionArguments)this.args;
            if (conversionArgs.projectFile == null) {
                String err = null;
                if (!definedProps.containsKey(ANT_TRANSTYPE) && !definedProps.containsKey(ANT_ARGS_INPUT)) {
                    err = locale.getString("conversion.error.input_and_transformation_not_defined");
                } else if (!definedProps.containsKey(ANT_TRANSTYPE)) {
                    err = locale.getString("conversion.error.transformation_not_defined");
                } else if (!definedProps.containsKey(ANT_ARGS_INPUT)) {
                    err = locale.getString("conversion.error.input_not_defined");
                }
                if (err != null) {
                    this.printErrorMessage(err);
                    this.args.printUsage(true);
                    throw new BuildException("");
                }
            } else {
                this.projectProps = this.handleProject(conversionArgs.projectFile, definedProps);
            }
            this.repeat = conversionArgs.repeat;
            if (!definedProps.containsKey(ANT_OUTPUT_DIR)) {
                definedProps.put(ANT_OUTPUT_DIR, new File(new File("."), "out").getAbsolutePath());
            }
            if (!definedProps.containsKey(ANT_BASE_TEMP_DIR) && !definedProps.containsKey("dita.temp.dir")) {
                definedProps.put(ANT_BASE_TEMP_DIR, new File(System.getProperty("java.io.tmpdir")).getAbsolutePath());
            }
        } else {
            throw new RuntimeException("Command or subcommand not supported: " + this.args.getClass().getCanonicalName());
        }
        if (!this.buildFile.exists() || this.buildFile.isDirectory()) {
            System.out.println("Buildfile " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        this.buildFile = FileUtils.getFileUtils().normalize(this.buildFile.getAbsolutePath());
        if (this.args.msgOutputLevel >= 3) {
            System.out.println("Buildfile " + this.buildFile);
        }
        if (this.args.logFile != null) {
            PrintStream logTo;
            try {
                logTo = new PrintStream(new FileOutputStream(this.args.logFile));
            }
            catch (IOException ioe) {
                throw new BuildException("Cannot write on the specified log file. Make sure the path exists and you have write permissions.");
            }
            out = logTo;
            err = logTo;
            System.setOut(out);
            System.setErr(err);
        }
        this.readyToRun = true;
    }

    private List<Map<String, Object>> handleProject(File projectFile, Map<String, Object> definedProps) {
        URI base = projectFile.toURI();
        Project project = this.readProjectFile(projectFile);
        String runDeliverable = (String)definedProps.get("project.deliverable");
        List<Map<String, Object>> projectProps = project.deliverables.stream().filter(deliverable -> runDeliverable != null ? Objects.equals(deliverable.id, runDeliverable) : true).map(deliverable -> {
            HashMap<String, Object> props = new HashMap<String, Object>(definedProps);
            Project.Context context = deliverable.context;
            URI input = base.resolve(context.inputs.inputs.get((int)0).href);
            props.put(ANT_ARGS_INPUT, input.toString());
            Path output = this.getOutputDir((Project.Deliverable)deliverable, (Map<String, Object>)props);
            props.put(ANT_OUTPUT_DIR, output.toString());
            Project.Publication publications = deliverable.publication;
            props.put(ANT_TRANSTYPE, publications.transtype);
            publications.params.forEach(param -> {
                if (props.containsKey(param.name)) {
                    return;
                }
                if (param.value != null) {
                    Arguments.Argument argument = ArgumentParser.getPluginArguments().getOrDefault(param.name, new Arguments.StringArgument(param.name, null));
                    String value = argument.getValue(param.value);
                    props.put(param.name, value);
                } else {
                    Arguments.Argument argument = ArgumentParser.getPluginArguments().get("--" + param.name);
                    String value = argument != null && (argument instanceof Arguments.FileArgument || argument instanceof Arguments.AbsoluteFileArgument) ? (param.href != null ? Paths.get(base.resolve(param.href)).toString() : Paths.get(base).resolve(param.path).toString()) : (param.href != null ? param.href.toString() : URLUtils.toFile(param.path.toString()).toString());
                    props.put(param.name, value);
                }
            });
            if (!context.profiles.ditavals.isEmpty()) {
                String filters = context.profiles.ditavals.stream().map(ditaVal -> Paths.get(base.resolve(ditaVal.href)).toString()).collect(Collectors.joining(File.pathSeparator));
                props.put("args.filter", filters);
            }
            return props;
        }).collect(Collectors.toList());
        if (runDeliverable != null && projectProps.isEmpty()) {
            this.printErrorMessage(String.format(locale.getString("project.error.deliverable_not_found"), runDeliverable));
            throw new BuildException("");
        }
        return projectProps;
    }

    @VisibleForTesting
    protected Path getOutputDir(Project.Deliverable deliverable, Map<String, Object> props) {
        URI outputDir = new File(props.getOrDefault(ANT_OUTPUT_DIR, "out").toString()).getAbsoluteFile().toURI();
        outputDir = outputDir.getPath().endsWith("/") ? outputDir : URLUtils.setPath(outputDir, outputDir.getPath() + "/");
        return Paths.get(deliverable.output != null ? outputDir.resolve(deliverable.output) : outputDir);
    }

    private Project readProjectFile(File projectFile) throws BuildException {
        if (!projectFile.exists()) {
            this.printErrorMessage(String.format(locale.getString("project.error.project_file_not_found"), projectFile));
            throw new BuildException("");
        }
        try {
            ProjectFactory factory = ProjectFactory.getInstance();
            factory.setLax(true);
            Project res = factory.load(projectFile.toURI());
            this.validateProject(res);
            return res;
        }
        catch (Exception e) {
            this.printErrorMessage(e.getMessage());
            throw new BuildException("");
        }
    }

    private void validateProject(Project project) throws IOException {
        for (Project.Deliverable deliverable : project.deliverables) {
            for (Project.Publication.Param param : deliverable.publication.params) {
                if (!RESERVED_PARAMS.containsKey(param.name)) continue;
                this.printErrorMessage(MessageUtils.getMessage("DOTJ085E", param.name, RESERVED_PARAMS.get(param.name)).toString());
            }
        }
    }

    private void printPlugins() {
        List<String> installedPlugins = Plugins.getInstalledPlugins();
        for (String plugin : installedPlugins) {
            System.out.println(plugin);
        }
    }

    private void printTranstypes() {
        for (String transtype : Configuration.transtypes) {
            System.out.println(transtype);
        }
    }

    private void printDeliverables(File projectFile) {
        List pairs = this.readProjectFile((File)projectFile).deliverables.stream().filter(deliverable -> deliverable.id != null).map(deliverable -> new AbstractMap.SimpleEntry<String, String>(deliverable.id, deliverable.name)).collect(Collectors.toList());
        int length = pairs.stream().map(Map.Entry::getKey).map(String::length).reduce(Integer::max).orElse(0);
        for (Map.Entry pair : pairs) {
            System.out.println(Strings.padEnd((String)((String)pair.getKey()), (int)length, (char)' ') + (pair.getValue() != null ? "  " + (String)pair.getValue() : ""));
        }
    }

    @Deprecated
    private File getParentFile(File file) {
        File parent = file.getParentFile();
        if (parent != null && this.args.msgOutputLevel >= 3) {
            System.out.println("Searching in " + parent.getAbsolutePath());
        }
        return parent;
    }

    private File findBuildFile(String start, String suffix) {
        if (this.args.msgOutputLevel >= 2) {
            System.out.println("Searching for " + suffix + " ...");
        }
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                return null;
            }
            file = new File(parent, suffix);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(ClassLoader coreLoader, Map<String, Object> definedProps) throws BuildException {
        org.apache.tools.ant.Project project = new org.apache.tools.ant.Project();
        project.setCoreLoader(coreLoader);
        Throwable error = null;
        try {
            this.addBuildListeners(project);
            this.addInputHandler(project);
            PrintStream savedErr = System.err;
            PrintStream savedOut = System.out;
            InputStream savedIn = System.in;
            SecurityManager oldsm = System.getSecurityManager();
            try {
                if (this.args.allowInput) {
                    project.setDefaultInputStream(System.in);
                }
                System.setIn((InputStream)new DemuxInputStream(project));
                System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(project, false)));
                System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
                project.fireBuildStarted();
                if (this.args.threadPriority != null) {
                    try {
                        project.log("Setting Ant's thread priority to " + this.args.threadPriority, 3);
                        Thread.currentThread().setPriority(this.args.threadPriority);
                    }
                    catch (SecurityException swallowed) {
                        project.log("A security manager refused to set the -nice value");
                    }
                }
                project.init();
                PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((org.apache.tools.ant.Project)project);
                HashMap<String, Object> props = new HashMap<String, Object>(definedProps);
                new ResolvePropertyMap(project, (GetProperty)propertyHelper, propertyHelper.getExpanders()).resolveAllProperties(props, null, false);
                for (Map.Entry<String, Object> ent : props.entrySet()) {
                    String arg = ent.getKey();
                    Object value = ent.getValue();
                    project.setUserProperty(arg, String.valueOf(value));
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                project.setUserProperty("ant.file.type", "file");
                project.setKeepGoingMode(this.args.keepGoingMode);
                if (this.args.proxy) {
                    ProxySetup proxySetup = new ProxySetup(project);
                    proxySetup.enableProxies();
                }
                ProjectHelper.configureProject((org.apache.tools.ant.Project)project, (File)this.buildFile);
                if (this.targets.size() == 0 && project.getDefaultTarget() != null) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            finally {
                if (oldsm != null) {
                    System.setSecurityManager(oldsm);
                }
                System.setOut(savedOut);
                System.setErr(savedErr);
                System.setIn(savedIn);
            }
        }
        catch (Error | RuntimeException exc) {
            error = exc;
            throw exc;
        }
        finally {
            try {
                project.fireBuildFinished(error);
            }
            catch (Throwable t) {
                this.printErrorMessage("Caught an exception while logging the end of the build.  Exception was:");
                t.printStackTrace();
                if (error != null) {
                    this.printErrorMessage("There has been an error prior to that:");
                    error.printStackTrace();
                }
                throw new BuildException(t);
            }
        }
    }

    protected void addBuildListeners(org.apache.tools.ant.Project project) {
        project.addBuildListener((BuildListener)this.createLogger());
        if (this.args.listeners != null) {
            for (String className : this.args.listeners) {
                BuildListener listener = (BuildListener)ClasspathUtils.newInstance((String)className, (ClassLoader)Main.class.getClassLoader(), BuildListener.class);
                project.setProjectReference((Object)listener);
                project.addBuildListener(listener);
            }
        }
    }

    private void addInputHandler(org.apache.tools.ant.Project project) throws BuildException {
        DefaultInputHandler handler;
        if (this.args.inputHandlerClassname == null) {
            handler = new DefaultInputHandler();
        } else {
            handler = (InputHandler)ClasspathUtils.newInstance((String)this.args.inputHandlerClassname, (ClassLoader)Main.class.getClassLoader(), InputHandler.class);
            project.setProjectReference((Object)handler);
        }
        project.setInputHandler((InputHandler)handler);
    }

    private BuildLogger createLogger() {
        DefaultLogger logger;
        if (this.args.loggerClassname != null) {
            try {
                logger = (BuildLogger)ClasspathUtils.newInstance((String)this.args.loggerClassname, (ClassLoader)Main.class.getClassLoader(), BuildLogger.class);
            }
            catch (BuildException e) {
                this.printErrorMessage("The specified logger class " + this.args.loggerClassname + " could not be used because " + e.getMessage());
                throw new RuntimeException();
            }
        } else {
            logger = new DefaultLogger();
            logger.useColor(this.args.useColor);
        }
        logger.setMessageOutputLevel(this.args.msgOutputLevel);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        logger.setEmacsMode(this.args.emacsMode);
        return logger;
    }

    private void printVersion() throws BuildException {
        System.out.println(String.format(locale.getString("version"), Configuration.configuration.get("otversion")));
    }
}

