/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dita.dost.invoker.Main;

public class UsageBuilder {
    private final StringBuilder buf = new StringBuilder();
    private final List<String> usages = new ArrayList<String>();
    private final Map<String, String> subcommands = new HashMap<String, String>();
    private final Map<Key, String> options = new HashMap<Key, String>();
    private final Map<Key, String> arguments = new LinkedHashMap<Key, String>();
    private final List<String> footers = new ArrayList<String>();

    private UsageBuilder(boolean compact) {
        this.options("h", "help", null, Main.locale.getString("help.option.help"));
        if (!compact) {
            this.options("d", "debug", null, Main.locale.getString("help.option.debug"));
            this.options("v", "verbose", null, Main.locale.getString("help.option.verbose"));
            this.options(null, "no-color", null, Main.locale.getString("help.option.no-color"));
        }
    }

    public static UsageBuilder builder(boolean compact) {
        return new UsageBuilder(compact);
    }

    public UsageBuilder usage(String usage) {
        this.usages.add(usage);
        return this;
    }

    public UsageBuilder subcommands(String subcommand, String desc) {
        this.subcommands.put(subcommand, desc);
        return this;
    }

    public UsageBuilder options(String shortKey, String longKey, String value, String desc) {
        this.options.put(new Key(shortKey, longKey, value), desc);
        return this;
    }

    public UsageBuilder arguments(String shortKey, String longKey, String value, String desc) {
        this.arguments.put(new Key(shortKey, longKey, value), desc);
        return this;
    }

    public UsageBuilder footer(String desc) {
        this.footers.add(desc);
        return this;
    }

    private String build() {
        String padding = this.getPadding();
        this.buf.append("\u001b[1m").append("Usage").append("\u001b[0m").append(":\n");
        for (String string : this.usages) {
            this.buf.append("  ").append(string).append("\n");
        }
        if (!this.subcommands.isEmpty()) {
            this.buf.append("\n").append("\u001b[1m").append("Subcommands").append("\u001b[0m").append(":\n");
            for (Map.Entry entry : this.sortSubCommands(this.subcommands)) {
                this.buf.append("  ").append((String)entry.getKey()).append(padding.substring(((String)entry.getKey()).length())).append((String)entry.getValue()).append("\n");
            }
            this.buf.append("\n  See 'dita <subcommand> --help' for details about a specific subcommand.\n");
        }
        if (!this.arguments.isEmpty()) {
            this.buf.append("\n").append("\u001b[1m").append("Arguments").append("\u001b[0m").append(":\n");
            for (Map.Entry entry : this.arguments.entrySet()) {
                this.buf.append("  ").append(entry.getKey()).append(padding.substring(((Key)entry.getKey()).toString().length())).append((String)entry.getValue()).append("\n");
            }
        }
        if (!this.options.isEmpty()) {
            this.buf.append("\n").append("\u001b[1m").append("Options").append("\u001b[0m").append(":\n");
            for (Map.Entry entry : this.sort(this.options)) {
                this.buf.append("  ").append(entry.getKey()).append(padding.substring(((Key)entry.getKey()).toString().length())).append((String)entry.getValue()).append("\n");
            }
        }
        if (!this.footers.isEmpty()) {
            this.buf.append("\n");
            for (String string : this.footers) {
                this.buf.append(string).append("\n");
            }
        }
        return this.buf.toString();
    }

    private List<Map.Entry<Key, String>> sort(Map<Key, String> arguments) {
        ArrayList<Map.Entry<Key, String>> entries = new ArrayList<Map.Entry<Key, String>>(arguments.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        return entries;
    }

    private List<Map.Entry<String, String>> sortSubCommands(Map<String, String> arguments) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(arguments.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        return entries;
    }

    /*
     * WARNING - void declaration
     */
    private String getPadding() {
        void var3_9;
        int max = 0;
        for (String string : this.subcommands.keySet()) {
            max = Math.max(max, string.length());
        }
        for (Key key : this.options.keySet()) {
            max = Math.max(max, key.toString().length());
        }
        for (Key key : this.arguments.keySet()) {
            max = Math.max(max, key.toString().length());
        }
        StringBuilder padding = new StringBuilder();
        int n = -2;
        while (var3_9 < max) {
            padding.append(' ');
            ++var3_9;
        }
        return padding.toString();
    }

    public void print() {
        System.out.println(this.build());
    }

    private static class Key
    implements Comparable<Key> {
        final String shortKey;
        final String longKey;
        final String value;
        final String string;

        private Key(String shortKey, String longKey, String value) {
            this.shortKey = shortKey;
            this.longKey = longKey;
            this.value = value;
            StringBuilder buf = new StringBuilder();
            if (shortKey != null) {
                buf.append("-").append(shortKey);
                if (value != null) {
                    buf.append(" <").append(value).append(">");
                }
            }
            if (shortKey != null && longKey != null) {
                buf.append(", ");
            }
            if (longKey != null) {
                buf.append("--").append(longKey);
                if (value != null) {
                    buf.append("=<").append(value).append(">");
                }
            }
            if (shortKey == null && longKey == null & value != null) {
                buf.append("<").append(value).append(">");
            }
            this.string = buf.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.shortKey, key.shortKey) && Objects.equals(this.longKey, key.longKey) && Objects.equals(this.value, key.value);
        }

        public int hashCode() {
            return Objects.hash(this.shortKey, this.longKey, this.value);
        }

        public String toString() {
            return this.string;
        }

        @Override
        public int compareTo(Key o) {
            if (this.longKey != null && o.longKey != null) {
                return this.longKey.compareTo(o.longKey);
            }
            if (this.value != null && o.value != null) {
                return this.value.compareTo(o.value);
            }
            return 0;
        }
    }
}

