/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.text.MessageFormat;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTLogger;
import org.slf4j.helpers.MarkerIgnoringBase;

public final class DITAOTAntLogger
extends MarkerIgnoringBase
implements DITAOTLogger {
    private final Project project;
    private Task task;
    private Target target;

    public DITAOTAntLogger(Project project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void info(String msg) {
        this.log(msg, null, 2);
    }

    public void info(String format, Object arg) {
        this.log(MessageFormat.format(format, arg), null, 2);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(MessageFormat.format(format, arg1, arg2), null, 2);
    }

    public void info(String format, Object ... arguments) {
        this.log(MessageFormat.format(format, arguments), null, 2);
    }

    public void info(String msg, Throwable t) {
        this.log(msg, t, 2);
    }

    public boolean isWarnEnabled() {
        return false;
    }

    public void warn(String msg) {
        this.log(msg, null, 1);
    }

    public void warn(String format, Object arg) {
        this.log(MessageFormat.format(format, arg), null, 1);
    }

    public void warn(String format, Object ... arguments) {
        this.log(MessageFormat.format(format, arguments), null, 1);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(MessageFormat.format(format, arg1, arg2), null, 1);
    }

    public void warn(String msg, Throwable t) {
        this.log(msg, t, 1);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.log(msg, null, 0);
    }

    public void error(String format, Object arg) {
        if (arg instanceof Throwable) {
            this.log(format, (Throwable)arg, 0);
        } else {
            this.log(MessageFormat.format(format, arg), null, 0);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (arg2 instanceof Throwable) {
            this.log(MessageFormat.format(format, arg1), (Throwable)arg2, 0);
        } else {
            this.log(MessageFormat.format(format, arg1, arg2), null, 0);
        }
    }

    public void error(String format, Object ... arguments) {
        Object last = arguments[arguments.length - 1];
        if (last instanceof Throwable) {
            Object[] init = new Object[arguments.length - 1];
            System.arraycopy(arguments, 0, init, 0, init.length);
            this.log(MessageFormat.format(format, init), (Throwable)last, 0);
        } else {
            this.log(MessageFormat.format(format, arguments), null, 0);
        }
    }

    public void error(String msg, Throwable t) {
        this.log(msg, t, 0);
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(String msg) {
        throw new UnsupportedOperationException();
    }

    public void trace(String format, Object arg) {
        throw new UnsupportedOperationException();
    }

    public void trace(String format, Object arg1, Object arg2) {
        throw new UnsupportedOperationException();
    }

    public void trace(String format, Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    public void trace(String msg, Throwable t) {
        throw new UnsupportedOperationException();
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        this.log(msg, null, 3);
    }

    public void debug(String format, Object arg) {
        this.log(MessageFormat.format(format, arg), null, 3);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(MessageFormat.format(format, arg1, arg2), null, 3);
    }

    public void debug(String format, Object ... arguments) {
        this.log(MessageFormat.format(format, arguments), null, 3);
    }

    public void debug(String msg, Throwable t) {
        this.log(msg, t, 3);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    private void log(String msg, Throwable t, int level) {
        if (this.task != null) {
            this.project.log(this.task, msg, level);
        } else if (this.target != null) {
            this.project.log(this.target, msg, level);
        } else {
            this.project.log(msg, level);
        }
    }
}

