/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.dita.dost.log.MessageBean;

public final class MessageUtils {
    private static final String ELEMENT_MESSAGE = "message";
    private static final String ELEMENT_REASON = "reason";
    private static final String ELEMENT_RESPONSE = "response";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String CLASSPATH_RESOURCE = "messages.xml";
    private static final String RESOURCE = "config" + File.separator + "messages.xml";
    public static final ResourceBundle msgs = ResourceBundle.getBundle("messages", new Locale("en", "US"), MessageUtils.class.getClassLoader());

    @VisibleForTesting
    MessageUtils() {
    }

    public static MessageBean getMessage(String id, String ... params) {
        if (!msgs.containsKey(id)) {
            throw new IllegalArgumentException("Message for ID '" + id + "' not found");
        }
        String msg = MessageFormat.format(msgs.getString(id), params);
        MessageBean.Type type = null;
        switch (id.substring(id.length() - 1)) {
            case "F": {
                type = MessageBean.Type.FATAL;
                break;
            }
            case "E": {
                type = MessageBean.Type.ERROR;
                break;
            }
            case "W": {
                type = MessageBean.Type.WARN;
                break;
            }
            case "I": {
                type = MessageBean.Type.INFO;
                break;
            }
            case "D": {
                type = MessageBean.Type.DEBUG;
            }
        }
        return new MessageBean(id, type, msg, null);
    }
}

