/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.UncheckedXPathException;
import org.apache.commons.io.FileUtils;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.RewriteRule;
import org.dita.dost.module.XmlFilterModule;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.dita.dost.writer.LinkFilter;
import org.dita.dost.writer.MapCleanFilter;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLFilter;

public class CleanPreprocessModule
extends AbstractPipelineModuleImpl {
    private static final String PARAM_USE_RESULT_FILENAME = "use-result-filename";
    private final LinkFilter filter = new LinkFilter();
    private final MapCleanFilter mapFilter = new MapCleanFilter();
    private boolean useResultFilename;
    private XsltTransformer rewriteTransformer;
    private RewriteRule rewriteClass;

    private void init(Map<String, String> input) {
        this.useResultFilename = Optional.ofNullable(input.get(PARAM_USE_RESULT_FILENAME)).map(Boolean::parseBoolean).orElse(false);
        CatalogResolver catalogResolver = CatalogUtils.getCatalogResolver();
        this.rewriteTransformer = Optional.ofNullable(input.get("result.rewrite-rule.xsl")).map(file -> {
            try {
                return catalogResolver.resolve(URLUtils.toURI(file).toString(), null);
            }
            catch (TransformerException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }).map(f -> {
            try {
                Processor processor = this.xmlUtils.getProcessor();
                XsltCompiler xsltCompiler = processor.newXsltCompiler();
                xsltCompiler.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
                XsltExecutable xsltExecutable = xsltCompiler.compile(f);
                return xsltExecutable.load();
            }
            catch (UncheckedXPathException e) {
                throw new RuntimeException("Failed to compile XSLT: " + e.getXPathException().getMessageAndLocation(), e);
            }
            catch (SaxonApiException e) {
                throw new RuntimeException("Failed to compile XSLT: " + e.getMessage(), e);
            }
        }).orElse(null);
        this.rewriteClass = Optional.ofNullable(input.get("result.rewrite-rule.class")).map(c -> {
            try {
                Class<?> cls = Class.forName(c);
                return (RewriteRule)cls.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
        this.filter.setLogger(this.logger);
        this.mapFilter.setLogger(this.logger);
    }

    @Override
    public AbstractPipelineOutput execute(Map<String, String> input) throws DITAOTException {
        this.init(input);
        URI base = this.getBaseDir();
        if (this.useResultFilename) {
            Collection original = this.job.getFileInfo().stream().filter(fi -> fi.result != null).map(fi -> Job.FileInfo.builder(fi).result(base.relativize(fi.result)).build()).collect(Collectors.toList());
            original.forEach(fi -> this.job.remove((Job.FileInfo)fi));
            Collection<Job.FileInfo> rewritten = this.rewrite(original);
            Job tempJob = new Job(this.job, Collections.emptyMap(), rewritten);
            this.filter.setJob(tempJob);
            this.mapFilter.setJob(tempJob);
            for (Job.FileInfo fi2 : rewritten) {
                try {
                    assert (!fi2.result.isAbsolute());
                    if (fi2.format != null && (fi2.format.equals("coderef") || fi2.format.equals("image"))) {
                        this.logger.debug("Skip format " + fi2.format);
                    } else {
                        File srcFile = new File(this.job.tempDirURI.resolve(fi2.uri));
                        if (this.job.getStore().exists(srcFile.toURI())) {
                            File destFile = new File(this.job.tempDirURI.resolve(fi2.result));
                            List<XMLFilter> processingPipe = this.getProcessingPipe(fi2, srcFile, destFile);
                            if (!processingPipe.isEmpty()) {
                                this.logger.info("Processing " + srcFile.toURI() + " to " + destFile.toURI());
                                this.job.getStore().transform(srcFile.toURI(), destFile.toURI(), processingPipe);
                                if (!srcFile.equals(destFile)) {
                                    this.logger.debug("Deleting " + srcFile.toURI());
                                    FileUtils.deleteQuietly((File)srcFile);
                                }
                            } else if (!srcFile.equals(destFile)) {
                                this.logger.info("Moving " + srcFile.toURI() + " to " + destFile.toURI());
                                FileUtils.moveFile((File)srcFile, (File)destFile);
                            }
                        }
                    }
                    Job.FileInfo res = Job.FileInfo.builder(fi2).uri(fi2.result).result(base.resolve(fi2.result)).build();
                    this.job.add(res);
                }
                catch (IOException e) {
                    this.logger.error("Failed to clean " + this.job.tempDirURI.resolve(fi2.uri) + ": " + e.getMessage(), e);
                }
            }
        }
        this.job.setProperty("uplevels", this.getUplevels(base));
        this.job.setInputDir(base);
        Job.FileInfo start = this.job.getFileInfo(f -> f.isInput).iterator().next();
        if (start != null) {
            this.job.setInputMap(start.uri);
        }
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException();
        }
        return null;
    }

    private Collection<Job.FileInfo> rewrite(Collection<Job.FileInfo> fis) throws DITAOTException {
        if (this.rewriteClass != null) {
            return this.rewriteClass.rewrite(fis);
        }
        if (this.rewriteTransformer != null) {
            try {
                DOMSource source = new DOMSource(this.serialize(fis));
                HashMap<URI, Job.FileInfo> files = new HashMap<URI, Job.FileInfo>();
                SAXDestination result = new SAXDestination((ContentHandler)new Job.JobHandler(new HashMap<String, Object>(), files));
                this.rewriteTransformer.setSource((Source)source);
                this.rewriteTransformer.setDestination((Destination)result);
                this.rewriteTransformer.transform();
                return files.values();
            }
            catch (IOException | SaxonApiException e) {
                throw new DITAOTException(e);
            }
        }
        return fis;
    }

    private Document serialize(Collection<Job.FileInfo> fis) throws IOException {
        try {
            Document doc = XMLUtils.getDocumentBuilder().newDocument();
            DOMResult result = new DOMResult(doc);
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(result);
            this.job.serialize(out, Collections.emptyMap(), fis);
            return (Document)result.getNode();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to serialize job file: " + e.getMessage());
        }
    }

    String getUplevels(URI base) {
        URI rel = base.relativize(this.job.getInputFile());
        int count = rel.toString().split("/").length - 1;
        return IntStream.range(0, count).boxed().map(i -> "../").collect(Collectors.joining(""));
    }

    @VisibleForTesting
    URI getBaseDir() {
        Collection<Job.FileInfo> fis = this.job.getFileInfo();
        URI baseDir = this.job.getFileInfo((Predicate<Job.FileInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBaseDir$8(org.dita.dost.util.Job$FileInfo ), (Lorg/dita/dost/util/Job$FileInfo;)Z)()).iterator().next().result.resolve(".");
        for (Job.FileInfo fi : fis) {
            if (fi.result == null) continue;
            URI res = fi.result.resolve(".");
            baseDir = Optional.ofNullable(this.getCommonBase(baseDir, res)).orElse(baseDir);
        }
        return baseDir;
    }

    @VisibleForTesting
    URI getCommonBase(URI left, URI right) {
        String rp;
        assert (left.isAbsolute());
        assert (right.isAbsolute());
        if (!left.getScheme().equals(right.getScheme())) {
            return null;
        }
        URI l = left.resolve(".");
        URI r = right.resolve(".");
        String lp = l.getPath();
        if (lp.equals(rp = r.getPath())) {
            return l;
        }
        if (lp.startsWith(rp)) {
            return r;
        }
        if (rp.startsWith(lp)) {
            return l;
        }
        String[] la = left.getPath().split("/");
        String[] ra = right.getPath().split("/");
        int len = Math.min(la.length, ra.length);
        for (int i = 0; i < len; ++i) {
            if (la[i].equals(ra[i])) continue;
            int common = Math.max(0, i);
            List<String> commons = Arrays.asList(la).subList(0, common);
            if (Constants.OS_NAME.toLowerCase().contains("windows") && commons.size() <= 1) {
                return null;
            }
            String path = commons.stream().collect(Collectors.joining("/")) + "/";
            return URLUtils.setPath(left, path);
        }
        return null;
    }

    private void init() {
        this.filter.setJob(this.job);
        this.filter.setLogger(this.logger);
        this.mapFilter.setJob(this.job);
        this.mapFilter.setLogger(this.logger);
    }

    private List<XMLFilter> getProcessingPipe(Job.FileInfo fi, File srcFile, File destFile) {
        ArrayList<XMLFilter> res = new ArrayList<XMLFilter>();
        if (fi.format == null || fi.format.equals("dita") || fi.format.equals("ditamap")) {
            this.filter.setCurrentFile(srcFile.toURI());
            this.filter.setDestFile(destFile.toURI());
            res.add(this.filter);
        }
        if (fi.format != null && fi.format.equals("ditamap")) {
            res.add(this.mapFilter);
        }
        for (XmlFilterModule.FilterPair p : this.filters) {
            if (!p.predicate.test(fi)) continue;
            AbstractXMLFilter f = p.newInstance();
            this.logger.debug("Configure filter " + f.getClass().getCanonicalName());
            f.setCurrentFile(srcFile.toURI());
            f.setJob(this.job);
            f.setLogger(this.logger);
            res.add(f);
        }
        return res;
    }

    private static /* synthetic */ boolean lambda$getBaseDir$8(Job.FileInfo fi) {
        return fi.isInput;
    }
}

