/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.stream.Collectors;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.ConrefPushReader;
import org.dita.dost.util.Job;
import org.dita.dost.writer.ConrefPushParser;
import org.w3c.dom.DocumentFragment;

final class ConrefPushModule
extends AbstractPipelineModuleImpl {
    ConrefPushModule() {
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) {
        Collection fis = this.job.getFileInfo(this.fileInfoFilter).stream().filter(f -> f.isConrefPush).collect(Collectors.toList());
        if (!fis.isEmpty()) {
            ConrefPushReader reader = new ConrefPushReader();
            reader.setLogger(this.logger);
            reader.setJob(this.job);
            for (Job.FileInfo f2 : fis) {
                File file = new File(this.job.tempDirURI.resolve(f2.uri));
                this.logger.info("Reading " + file.toURI());
                reader.read(file.getAbsoluteFile());
            }
            Map<File, Hashtable<ConrefPushReader.MoveKey, DocumentFragment>> pushSet = reader.getPushMap();
            for (Map.Entry<File, Hashtable<ConrefPushReader.MoveKey, DocumentFragment>> entry : pushSet.entrySet()) {
                ConrefPushParser parser = new ConrefPushParser();
                parser.setJob(this.job);
                parser.setLogger(this.logger);
                parser.setMoveTable((Map<ConrefPushReader.MoveKey, DocumentFragment>)entry.getValue());
                parser.setTempDir(this.job.tempDir);
                try {
                    parser.read(entry.getKey());
                }
                catch (DITAOTException e) {
                    this.logger.error("Failed to process push conref: " + e.getMessage(), e);
                }
            }
        }
        return null;
    }
}

