/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class MergeDitavalModule
extends AbstractPipelineModuleImpl {
    private final List<File> ditavalFiles = new LinkedList<File>();

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        try {
            this.parseInputParameters(input);
            this.setMergedProperty();
            this.writeMergedDitaval();
        }
        catch (DITAOTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        return null;
    }

    private void parseInputParameters(AbstractPipelineInput input) {
        File basedir = URLUtils.toFile(input.getAttribute("basedir"));
        if (input.getAttribute("ditaval") != null) {
            String[] allDitavalFiles;
            for (String oneDitavalFile : allDitavalFiles = input.getAttribute("ditaval").split(File.pathSeparator)) {
                this.logger.debug("Evaluating ditaval: " + oneDitavalFile);
                URI ditavalInput = URLUtils.toURI(oneDitavalFile);
                URI usingDitavalInput = ditavalInput.isAbsolute() ? ditavalInput : (ditavalInput.getPath() != null && ditavalInput.getPath().startsWith("/") ? URLUtils.setScheme(ditavalInput, "file") : basedir.toURI().resolve(ditavalInput));
                if (new File(usingDitavalInput).exists()) {
                    this.ditavalFiles.add(new File(usingDitavalInput));
                    continue;
                }
                this.logger.error(MessageUtils.getMessage("DOTJ071E", usingDitavalInput.toString()).toString());
            }
        }
    }

    private void setMergedProperty() {
        this.job.setProperty("dita.input.valfile", new File(this.job.tempDir, "ditaot.generated.ditaval").toString());
    }

    private void writeMergedDitaval() throws DITAOTException {
        DocumentBuilder ditavalbuilder = XMLUtils.getDocumentBuilder();
        ditavalbuilder.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
        XMLStreamWriter export = null;
        try (OutputStream exportStream = this.job.getStore().getOutputStream(new File(this.job.tempDir, "ditaot.generated.ditaval").toURI());){
            export = XMLOutputFactory.newInstance().createXMLStreamWriter(exportStream, "UTF-8");
            export.writeStartDocument();
            export.writeStartElement("val");
            export.writeNamespace("dita-ot", "http://dita-ot.sourceforge.net");
            for (File curDitaVal : this.ditavalFiles) {
                Document doc = ditavalbuilder.parse(curDitaVal);
                Element ditavalRoot = doc.getDocumentElement();
                NodeList rootChildren = ditavalRoot.getChildNodes();
                this.logger.debug("Writing conditions from ditaval: " + curDitaVal);
                this.writeConditions(export, rootChildren, curDitaVal.toURI().resolve("."));
            }
            export.writeEndElement();
            export.writeEndDocument();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to merge ditaval files: " + e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new DITAOTException("Failed to serialize merged ditaval file: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new DITAOTException("Failed to parse ditaval file: " + e.getMessage(), e);
        }
        finally {
            if (export != null) {
                try {
                    export.close();
                }
                catch (XMLStreamException e) {
                    this.logger.error("Failed to close merged ditaval file: " + e.getMessage(), e);
                }
            }
        }
    }

    private void writeConditions(XMLStreamWriter export, NodeList conditionElements, URI ditavalDirectory) {
        try {
            block6: for (int i = 0; i < conditionElements.getLength(); ++i) {
                Node node = conditionElements.item(i);
                switch (node.getNodeType()) {
                    case 1: {
                        int j;
                        Element elem = (Element)node;
                        export.writeStartElement(node.getNodeName());
                        NamedNodeMap atts = node.getAttributes();
                        for (j = 0; j < atts.getLength(); ++j) {
                            String prefix;
                            String ns;
                            String value = atts.item(j).getNodeValue().trim();
                            if (value.indexOf(58) == -1 || (ns = elem.lookupNamespaceURI(prefix = value.substring(0, value.indexOf(58)))) == null) continue;
                            export.writeNamespace(prefix, ns);
                        }
                        if (atts.getNamedItem("imageref") != null || atts.getNamedItem("img") != null) {
                            String imagerefAtt;
                            String string = imagerefAtt = atts.getNamedItem("imageref") != null ? atts.getNamedItem("imageref").getNodeValue() : atts.getNamedItem("img").getNodeValue();
                            if (URLUtils.toURI(imagerefAtt).isAbsolute()) {
                                export.writeAttribute("dita-ot", "http://dita-ot.sourceforge.net", "imagerefuri", imagerefAtt);
                            } else {
                                export.writeAttribute("dita-ot", "http://dita-ot.sourceforge.net", "imagerefuri", ditavalDirectory.resolve(imagerefAtt).toString());
                            }
                        }
                        for (j = 0; j < atts.getLength(); ++j) {
                            export.writeAttribute(atts.item(j).getNodeName(), atts.item(j).getNodeValue());
                        }
                        this.writeConditions(export, node.getChildNodes(), ditavalDirectory);
                        export.writeEndElement();
                        continue block6;
                    }
                    case 3: {
                        export.writeCharacters(node.getNodeValue());
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            this.logger.error("Failed to generate merged DITAVAL file: " + e.getMessage(), e);
        }
    }
}

