/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.saxon.s9api.Processor;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.XmlFilterModule;
import org.dita.dost.reader.GrammarPoolManager;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

abstract class SourceReaderModule
extends AbstractPipelineModuleImpl {
    private static final String FEATURE_GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    XMLReader reader;
    boolean validate;
    boolean gramcache = true;
    Processor processor;

    SourceReaderModule() {
    }

    XMLReader getXmlReader(String format) throws SAXException {
        if (format == null || format.equals("dita")) {
            return this.reader;
        }
        for (Map.Entry<String, String> e : Configuration.parserMap.entrySet()) {
            if (!format.equals(e.getKey())) continue;
            try {
                XMLReader r = (XMLReader)Class.forName(e.getValue()).newInstance();
                Map features = Configuration.parserFeatures.getOrDefault(e.getKey(), Collections.emptyMap());
                for (Map.Entry feature : features.entrySet()) {
                    try {
                        r.setFeature((String)feature.getKey(), (Boolean)feature.getValue());
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {}
                }
                return r;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new SAXException(ex);
            }
        }
        return this.reader;
    }

    void initXmlReader() throws SAXException {
        if (Configuration.parserMap.containsKey("dita")) {
            this.reader = XMLReaderFactory.createXMLReader(Configuration.parserMap.get("dita"));
            Map features = Configuration.parserFeatures.getOrDefault("dita", Collections.emptyMap());
            for (Map.Entry feature : features.entrySet()) {
                try {
                    this.reader.setFeature((String)feature.getKey(), (Boolean)feature.getValue());
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            }
        } else {
            this.reader = XMLUtils.getXMLReader();
        }
        this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        if (this.validate) {
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            try {
                this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (SAXNotRecognizedException features) {
                // empty catch block
            }
        }
        if (this.gramcache) {
            XMLGrammarPool grammarPool = GrammarPoolManager.getGrammarPool();
            try {
                this.reader.setProperty(FEATURE_GRAMMAR_POOL, grammarPool);
                this.logger.info("Using Xerces grammar pool for DTD and schema caching.");
            }
            catch (NoClassDefFoundError e) {
                this.logger.debug("Xerces not available, not using grammar caching");
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                this.logger.warn("Failed to set Xerces grammar pool for parser: " + e.getMessage());
            }
        }
        CatalogResolver catalogResolver = CatalogUtils.getCatalogResolver();
        this.reader.setEntityResolver((EntityResolver)catalogResolver);
        this.processor = this.xmlUtils.getProcessor();
    }

    List<XMLFilter> getProcessingPipe(URI fileToParse) {
        ArrayList<XMLFilter> pipe = new ArrayList<XMLFilter>();
        for (XmlFilterModule.FilterPair pair : this.filters) {
            AbstractXMLFilter filter = pair.newInstance();
            filter.setLogger(this.logger);
            filter.setJob(this.job);
            filter.setCurrentFile(fileToParse);
            pipe.add(filter);
        }
        return pipe;
    }
}

