/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.UncheckedXPathException;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.MergeMapParser;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.DelegatingURIResolver;
import org.dita.dost.util.Job;
import org.dita.dost.util.XMLUtils;

final class TopicMergeModule
extends AbstractPipelineModuleImpl {
    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        Job.FileInfo in = this.job.getFileInfo(fi -> fi.isInput).iterator().next();
        File ditaInput = new File(this.job.tempDirURI.resolve(in.uri));
        if (!this.job.getStore().exists(ditaInput.toURI())) {
            this.logger.error(MessageUtils.getMessage("DOTJ025E", new String[0]).toString());
            return null;
        }
        File style = input.getAttribute("style") != null ? new File(input.getAttribute("style")) : null;
        File out = new File(input.getAttribute("output")).getAbsoluteFile();
        MergeMapParser mapParser = new MergeMapParser();
        mapParser.setLogger(this.logger);
        mapParser.setJob(this.job);
        mapParser.setOutput(out);
        ByteArrayOutputStream midBuffer = new ByteArrayOutputStream();
        try {
            midBuffer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>".getBytes(StandardCharsets.UTF_8));
            midBuffer.write("<dita-merge xmlns:ditaarch='http://dita.oasis-open.org/architecture/2005/' xmlns:dita-ot='http://dita-ot.sourceforge.net/ns/201007/dita-ot'>".getBytes(StandardCharsets.UTF_8));
            mapParser.setOutputStream(midBuffer);
            mapParser.read(ditaInput, this.job.tempDir);
            midBuffer.write("</dita-merge>".getBytes(StandardCharsets.UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to merge topics: " + e.getMessage(), e);
        }
        File outputDir = out.getParentFile();
        if (!outputDir.exists()) {
            try {
                Files.createDirectories(outputDir.toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                this.logger.error("Failed to create directory " + outputDir.getAbsolutePath());
            }
        }
        try (BufferedOutputStream output = new BufferedOutputStream(this.job.getStore().getOutputStream(out.toURI()));){
            if (style != null) {
                Processor processor = this.xmlUtils.getProcessor();
                XsltCompiler xsltCompiler = processor.newXsltCompiler();
                XsltTransformer transformer = xsltCompiler.compile((Source)new StreamSource(style)).load();
                transformer.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
                transformer.setURIResolver((URIResolver)new DelegatingURIResolver(new URIResolver[]{CatalogUtils.getCatalogResolver(), this.job.getStore()}));
                transformer.setMessageListener(XMLUtils.toMessageListener(this.logger));
                StreamSource source = new StreamSource(new ByteArrayInputStream(midBuffer.toByteArray()));
                Serializer result = processor.newSerializer((OutputStream)output);
                transformer.setSource((Source)source);
                transformer.setDestination((Destination)result);
                transformer.transform();
            } else {
                ((OutputStream)output).write(midBuffer.toByteArray());
                ((OutputStream)output).flush();
            }
        }
        catch (UncheckedXPathException e) {
            throw new DITAOTException("Failed to process merged topics", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException | SaxonApiException e) {
            throw new DITAOTException("Failed to process merged topics: " + e.getMessage(), e);
        }
        return null;
    }
}

