/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Element;

public abstract class AbstractBranchFilterModule
extends AbstractPipelineModuleImpl {
    private final DitaValReader ditaValReader;
    TempFileNameScheme tempFileNameScheme;
    final SubjectSchemeReader subjectSchemeReader;
    private final Map<URI, FilterUtils> filterCache = new HashMap<URI, FilterUtils>();
    URI currentFile;
    final Set<URI> flagImageSet = new LinkedHashSet<URI>(128);
    final Set<URI> relFlagImagesSet = new LinkedHashSet<URI>(128);

    AbstractBranchFilterModule() {
        this.ditaValReader = new DitaValReader();
        this.subjectSchemeReader = new SubjectSchemeReader();
    }

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        try {
            String cls = Optional.ofNullable(job.getProperty("temp-file-name-scheme")).orElse(Configuration.configuration.get("temp-file-name-scheme"));
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(cls).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(job.getInputDir());
        this.ditaValReader.setJob(job);
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        super.setLogger(logger);
        this.ditaValReader.setLogger(logger);
        this.subjectSchemeReader.setLogger(logger);
    }

    SubjectScheme getSubjectScheme(Element root) {
        this.subjectSchemeReader.reset();
        this.logger.debug("Loading subject schemes");
        List subjectSchemes = XMLUtils.toList(root.getElementsByTagName("*"));
        subjectSchemes.stream().filter(Constants.SUBJECTSCHEME_ENUMERATIONDEF::matches).forEach(enumerationDef -> {
            Element schemeRoot = XMLUtils.ancestors(enumerationDef).filter(Constants.SUBMAP::matches).findFirst().orElse(root);
            this.subjectSchemeReader.processEnumerationDef(schemeRoot, (Element)enumerationDef);
        });
        return this.subjectSchemeReader.getSubjectSchemeMap();
    }

    List<FilterUtils> combineFilterUtils(Element topicref, List<FilterUtils> filters, SubjectScheme subjectSchemeMap) {
        return XMLUtils.getChildElement(topicref, Constants.DITAVAREF_D_DITAVALREF).map(ditavalRef -> this.getFilterUtils((Element)ditavalRef).refine(subjectSchemeMap)).map(f -> {
            ArrayList<FilterUtils> fs = new ArrayList<FilterUtils>(filters.size() + 1);
            fs.addAll(filters);
            fs.add((FilterUtils)f);
            return fs;
        }).orElse(filters);
    }

    private FilterUtils getFilterUtils(Element ditavalRef) {
        URI href = URLUtils.toURI(ditavalRef.getAttribute("href"));
        URI tmp = this.currentFile.resolve(href);
        Job.FileInfo fi = this.job.getFileInfo(tmp);
        URI ditaval = fi.src;
        return this.filterCache.computeIfAbsent(ditaval, this::getFilterUtils);
    }

    FilterUtils getFilterUtils(URI ditaval) {
        this.logger.info("Reading " + ditaval);
        this.ditaValReader.filterReset();
        this.ditaValReader.read(ditaval);
        this.flagImageSet.addAll(this.ditaValReader.getImageList());
        this.relFlagImagesSet.addAll(this.ditaValReader.getRelFlagImageList());
        Map<FilterUtils.FilterKey, FilterUtils.Action> filterMap = this.ditaValReader.getFilterMap();
        FilterUtils f = new FilterUtils(filterMap, this.ditaValReader.getForegroundConflictColor(), this.ditaValReader.getBackgroundConflictColor());
        f.setLogger(this.logger);
        return f;
    }

    void addFlagImagesSetToProperties(Job prop, Set<URI> set) {
        for (URI uRI : this.flagImageSet) {
            Job.FileInfo f = this.getOrCreateFileInfo(uRI);
            f.isFlagImage = true;
            f.format = "image";
            this.job.add(f);
        }
        LinkedHashSet<URI> newSet = new LinkedHashSet<URI>(128);
        for (URI file : set) {
            if (file.isAbsolute()) {
                newSet.add(file.normalize());
                continue;
            }
            newSet.add(file.normalize());
        }
        String string = "relflagimagelist".substring(0, "relflagimagelist".lastIndexOf("list")) + "file";
        prop.setProperty(string, "relflagimagelist".substring(0, "relflagimagelist".lastIndexOf("list")) + ".list");
        File list = this.job.tempDir.toPath().resolve(prop.getProperty(string)).toFile();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.job.getStore().getOutputStream(list.toURI())));){
            for (URI aNewSet : newSet) {
                bufferedWriter.write(aNewSet.getPath());
                ((Writer)bufferedWriter).write(10);
            }
            ((Writer)bufferedWriter).flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        prop.setProperty("relflagimagelist", StringUtils.join(newSet, ","));
    }

    private Job.FileInfo getOrCreateFileInfo(URI file) {
        assert (file.isAbsolute());
        assert (file.getFragment() == null);
        URI f = file.normalize();
        return Optional.ofNullable(this.job.getFileInfo(f)).map(Job.FileInfo.Builder::new).orElse(new Job.FileInfo.Builder().src(file)).uri(this.tempFileNameScheme.generateTempFileName(file)).build();
    }
}

