/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.reader;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.reader.AbstractReaderModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.DebugFilter;
import org.dita.dost.writer.NormalizeFilter;
import org.dita.dost.writer.ProfilingFilter;
import org.dita.dost.writer.ValidationFilter;
import org.xml.sax.XMLFilter;

public final class MapReaderModule
extends AbstractReaderModule {
    public MapReaderModule() {
        this.formatFilter = v -> Objects.equals(v, "ditamap") || Objects.equals(v, "ditaval");
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        try {
            this.parseInputParameters(input);
            this.init();
            this.readResourceFiles();
            this.readStartFile();
            this.processWaitList();
            this.handleConref();
            this.outputResult();
            this.job.write();
        }
        catch (RuntimeException | DITAOTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void readStartFile() throws DITAOTException {
        this.addToWaitList(new GenListModuleReader.Reference(this.rootFile));
    }

    @Override
    List<XMLFilter> getProcessingPipe(URI fileToParse) {
        assert (fileToParse.isAbsolute());
        ArrayList<XMLFilter> pipe = new ArrayList<XMLFilter>();
        if (this.genDebugInfo) {
            DebugFilter debugFilter = new DebugFilter();
            debugFilter.setLogger(this.logger);
            debugFilter.setCurrentFile(this.currentFile);
            pipe.add(debugFilter);
        }
        if (this.filterUtils != null) {
            ProfilingFilter profilingFilter = new ProfilingFilter();
            profilingFilter.setLogger(this.logger);
            profilingFilter.setJob(this.job);
            profilingFilter.setFilterUtils(this.filterUtils);
            profilingFilter.setCurrentFile(fileToParse);
            pipe.add(profilingFilter);
        }
        ValidationFilter validationFilter = new ValidationFilter();
        validationFilter.setLogger(this.logger);
        validationFilter.setValidateMap(this.validateMap);
        validationFilter.setCurrentFile(fileToParse);
        validationFilter.setJob(this.job);
        validationFilter.setProcessingMode(this.processingMode);
        pipe.add(validationFilter);
        NormalizeFilter normalizeFilter = new NormalizeFilter();
        normalizeFilter.setLogger(this.logger);
        pipe.add(normalizeFilter);
        if ("eclipsehelp".equals(this.transtype)) {
            this.exportAnchorsFilter.setCurrentFile(fileToParse);
            this.exportAnchorsFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger));
            pipe.add(this.exportAnchorsFilter);
        }
        this.keydefFilter.setCurrentDir(fileToParse.resolve("."));
        this.keydefFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger));
        pipe.add(this.keydefFilter);
        this.listFilter.setCurrentFile(fileToParse);
        this.listFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger));
        pipe.add(this.listFilter);
        this.ditaWriterFilter.setDefaultValueMap(this.defaultValueMap);
        this.ditaWriterFilter.setCurrentFile(this.currentFile);
        this.ditaWriterFilter.setOutputFile(this.outputFile);
        pipe.add(this.ditaWriterFilter);
        return pipe;
    }

    @Override
    void categorizeReferenceFile(GenListModuleReader.Reference file) {
        if (file.format == null || "dita".equals(file.format)) {
            return;
        }
        switch (file.format) {
            case "ditamap": {
                this.addToWaitList(file);
                break;
            }
            case "image": {
                this.formatSet.add(file);
                if (URLUtils.exists(file.filename)) break;
                this.logger.warn(MessageUtils.getMessage("DOTX008E", file.filename.toString()).toString());
                break;
            }
            case "ditaval": {
                this.formatSet.add(file);
                break;
            }
            default: {
                this.htmlSet.put((Object)file.format, (Object)file.filename);
            }
        }
    }
}

