/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.reader;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.chunk.ChunkModule;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.exception.UncheckedDITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.module.reader.AbstractReaderModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.DebugFilter;
import org.dita.dost.writer.NormalizeFilter;
import org.dita.dost.writer.ProfilingFilter;
import org.dita.dost.writer.ValidationFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public final class TopicReaderModule
extends AbstractReaderModule {
    static final QName QNAME_HREF = new QName("href");
    static final QName QNAME_SCOPE = new QName("scope");
    static final QName QNAME_FORMAT = new QName("format");
    static final QName QNAME_CLASS = new QName("class");
    static final QName QNAME_ORIG_FORMAT = new QName("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "orig-format");

    public TopicReaderModule() {
        this.formatFilter = v -> !Objects.equals(v, "ditamap") && !Objects.equals(v, "ditaval");
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        try {
            this.parseInputParameters(input);
            this.init();
            this.readResourceFiles();
            this.readStartFile();
            this.processWaitList();
            this.handleConref();
            this.outputResult();
            this.job.write();
        }
        catch (RuntimeException | DITAOTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    void init() throws SAXException {
        Document doc;
        super.init();
        if (this.filterUtils != null && (doc = this.getMapDocument()) != null) {
            SubjectSchemeReader subjectSchemeReader = new SubjectSchemeReader();
            subjectSchemeReader.setLogger(this.logger);
            subjectSchemeReader.setJob(this.job);
            this.logger.debug("Loading subject schemes");
            List subjectSchemes = XMLUtils.toList(doc.getDocumentElement().getElementsByTagName("*"));
            subjectSchemes.stream().filter(Constants.SUBJECTSCHEME_ENUMERATIONDEF::matches).forEach(enumerationDef -> {
                Element schemeRoot = XMLUtils.ancestors(enumerationDef).filter(Constants.SUBMAP::matches).findFirst().orElse(doc.getDocumentElement());
                subjectSchemeReader.processEnumerationDef(schemeRoot, (Element)enumerationDef);
            });
            SubjectScheme subjectScheme = subjectSchemeReader.getSubjectSchemeMap();
            this.filterUtils = this.filterUtils.refine(subjectScheme);
        }
    }

    @Override
    void readResourceFiles() throws DITAOTException {
        if (!this.resources.isEmpty()) {
            for (URI resource : this.resources) {
                this.additionalResourcesSet.add(resource);
                Job.FileInfo fi = this.job.getFileInfo(resource);
                if (fi == null) {
                    this.addToWaitList(new GenListModuleReader.Reference(resource));
                    continue;
                }
                if ("ditamap".equals(fi.format)) {
                    this.getStartDocuments(fi).forEach(this::addToWaitList);
                    continue;
                }
                if (fi.format == null) {
                    fi.format = "dita";
                    this.job.add(fi);
                }
                this.addToWaitList(new GenListModuleReader.Reference(resource, fi.format));
            }
            this.processWaitList();
            this.additionalResourcesSet.addAll(this.hrefTargetSet);
            this.additionalResourcesSet.addAll(this.conrefTargetSet);
            this.additionalResourcesSet.addAll(this.nonConrefCopytoTargetSet);
            this.additionalResourcesSet.addAll(this.outDitaFilesSet);
            this.additionalResourcesSet.addAll(this.conrefpushSet);
            this.additionalResourcesSet.addAll(this.keyrefSet);
            this.additionalResourcesSet.addAll(this.resourceOnlySet);
            this.additionalResourcesSet.addAll(this.fullTopicSet);
            this.additionalResourcesSet.addAll(this.fullMapSet);
            this.additionalResourcesSet.addAll(this.conrefSet);
            this.resourceOnlySet.clear();
        }
    }

    private Document getMapDocument() throws SAXException {
        Job.FileInfo fi = this.job.getFileInfo(f -> f.isInput).iterator().next();
        if (fi == null) {
            return null;
        }
        URI currentFile = this.job.tempDirURI.resolve(fi.uri);
        try {
            this.logger.debug("Reading " + currentFile);
            return this.job.getStore().getDocument(currentFile);
        }
        catch (IOException e) {
            throw new SAXException("Failed to parse " + currentFile, e);
        }
    }

    @Override
    public void readStartFile() throws DITAOTException {
        Job.FileInfo fi = this.job.getFileInfo(f -> f.isInput).iterator().next();
        if (fi == null) {
            this.addToWaitList(new GenListModuleReader.Reference(this.job.getInputFile()));
        } else if ("ditamap".equals(fi.format)) {
            this.getStartDocuments(fi).forEach(this::addToWaitList);
        } else {
            if (fi.format == null) {
                fi.format = "dita";
                this.job.add(fi);
            }
            this.addToWaitList(new GenListModuleReader.Reference(this.job.getInputFile(), fi.format));
        }
    }

    private List<GenListModuleReader.Reference> getStartDocuments(Job.FileInfo startFileInfo) throws DITAOTException {
        ArrayList<GenListModuleReader.Reference> res = new ArrayList<GenListModuleReader.Reference>();
        assert (startFileInfo.src != null);
        URI tmp = this.job.tempDirURI.resolve(startFileInfo.uri);
        try {
            XdmNode source = this.job.getStore().getImmutableNode(tmp);
            this.logger.info("Reading " + tmp);
            Predicate<XdmNode> isTopicref = xdmItem -> Constants.MAP_TOPICREF.matches(xdmItem.getAttributeValue(QNAME_CLASS));
            source.select(Steps.descendant(isTopicref)).forEach(xdmItem -> {
                URI href = this.getHref((XdmNode)xdmItem);
                if (href != null) {
                    Job.FileInfo fi = this.job.getFileInfo(startFileInfo.src.resolve(href));
                    if (fi == null) {
                        fi = this.job.getFileInfo(tmp.resolve(href));
                    }
                    assert (fi != null);
                    assert (fi.src != null);
                    String format = xdmItem.getAttributeValue(QNAME_ORIG_FORMAT);
                    if (format == null) {
                        format = xdmItem.getAttributeValue(QNAME_FORMAT);
                    }
                    res.add(new GenListModuleReader.Reference(fi.src, format));
                    this.nonConrefCopytoTargetSet.add(fi.src);
                }
            });
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        return res;
    }

    private URI getHref(XdmNode in) {
        URI href = URLUtils.toURI(in.getAttributeValue(QNAME_HREF));
        if (href == null) {
            return null;
        }
        String scope = in.getAttributeValue(QNAME_SCOPE);
        if (!ChunkModule.isLocalScope(scope)) {
            return null;
        }
        String format = in.getAttributeValue(QNAME_FORMAT);
        if (format != null && !"dita".equals(format)) {
            return null;
        }
        return URLUtils.stripFragment(href);
    }

    @Override
    List<XMLFilter> getProcessingPipe(URI fileToParse) {
        assert (fileToParse.isAbsolute());
        ArrayList<XMLFilter> pipe = new ArrayList<XMLFilter>();
        if (this.genDebugInfo) {
            DebugFilter debugFilter = new DebugFilter();
            debugFilter.setLogger(this.logger);
            debugFilter.setCurrentFile(this.currentFile);
            pipe.add(debugFilter);
        }
        if (this.filterUtils != null) {
            ProfilingFilter profilingFilter = new ProfilingFilter();
            profilingFilter.setLogger(this.logger);
            profilingFilter.setJob(this.job);
            profilingFilter.setFilterUtils(this.filterUtils);
            profilingFilter.setCurrentFile(fileToParse);
            pipe.add(profilingFilter);
        }
        ValidationFilter validationFilter = new ValidationFilter();
        validationFilter.setLogger(this.logger);
        validationFilter.setValidateMap(this.validateMap);
        validationFilter.setCurrentFile(fileToParse);
        validationFilter.setJob(this.job);
        validationFilter.setProcessingMode(this.processingMode);
        pipe.add(validationFilter);
        NormalizeFilter normalizeFilter = new NormalizeFilter();
        normalizeFilter.setLogger(this.logger);
        pipe.add(normalizeFilter);
        pipe.add(this.topicFragmentFilter);
        if ("eclipsehelp".equals(this.transtype)) {
            this.exportAnchorsFilter.setCurrentFile(fileToParse);
            this.exportAnchorsFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger));
            pipe.add(this.exportAnchorsFilter);
        }
        this.listFilter.setCurrentFile(fileToParse);
        this.listFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger));
        pipe.add(this.listFilter);
        this.ditaWriterFilter.setDefaultValueMap(this.defaultValueMap);
        this.ditaWriterFilter.setCurrentFile(this.currentFile);
        this.ditaWriterFilter.setOutputFile(this.outputFile);
        pipe.add(this.ditaWriterFilter);
        return pipe;
    }

    @Override
    void categorizeReferenceFile(GenListModuleReader.Reference file) {
        if (this.listFilter.getCoderefTargets().contains(file.filename)) {
            return;
        }
        if (this.formatFilter.test(file.format)) {
            if (GenListModuleReader.isFormatDita(file.format) && !this.job.crawlTopics() && !this.listFilter.getConrefTargets().contains(file.filename)) {
                return;
            }
            if (GenListModuleReader.isFormatDita(file.format) && (!this.job.getOnlyTopicInMap() || this.listFilter.getConrefTargets().contains(file.filename))) {
                this.addToWaitList(file);
            } else if ("image".equals(file.format)) {
                this.formatSet.add(file);
                if (!URLUtils.exists(file.filename)) {
                    if (this.processingMode == Configuration.Mode.STRICT) {
                        throw new UncheckedDITAOTException(MessageUtils.getMessage("DOTX008E", file.filename.toString()).toException());
                    }
                    this.logger.warn(MessageUtils.getMessage("DOTX008E", file.filename.toString()).toString());
                }
            } else {
                this.htmlSet.put((Object)file.format, (Object)file.filename);
            }
        }
    }
}

