/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.trans.UncheckedXPathException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.IAction;
import org.dita.dost.platform.Value;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

final class FileGenerator
extends XMLFilterImpl {
    private static final String EXTENSION_ID_ATTR = "id";
    private static final String EXTENSION_ELEM = "extension";
    private static final String EXTENSION_ATTR = "extension";
    private static final String BEHAVIOR_ATTR = "behavior";
    public static final String PARAM_LOCALNAME = "localname";
    public static final String PARAM_TEMPLATE = "template";
    private static final String DITA_OT_NS = "http://dita-ot.sourceforge.net";
    private static final String TEMPLATE_PREFIX = "_template.";
    private static final Map<String, String> DEFAULT_EXTENSIONS = Collections.emptyMap();
    private DITAOTLogger logger;
    private final Map<String, List<Value>> featureTable;
    private final Map<String, Features> pluginTable;
    private File templateFile;

    public FileGenerator() {
        this(null, null);
    }

    public FileGenerator(Hashtable<String, List<Value>> featureTbl, Map<String, Features> pluginTable) {
        this.featureTable = featureTbl;
        this.pluginTable = pluginTable;
        this.templateFile = null;
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void generate(File fileName) {
        File outputFile = this.removeTemplatePrefix(fileName);
        this.templateFile = fileName;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));){
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            XMLReader reader = parserFactory.newSAXParser().getXMLReader();
            this.setContentHandler(null);
            this.setParent(reader);
            reader = this;
            SAXSource source = new SAXSource(reader, new InputSource(in));
            source.setSystemId(fileName.toURI().toString());
            StreamResult result = new StreamResult(out);
            serializer.transform(source, result);
        }
        catch (UncheckedXPathException e) {
            this.logger.error(e.getXPathException().getMessageAndLocation());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (TransformerException e) {
            this.logger.error("Failed to transform " + fileName + ": " + e.getMessageAndLocation(), e);
        }
        catch (Exception e) {
            this.logger.error("Failed to transform " + fileName + ": " + e.getMessage(), e);
        }
    }

    private File removeTemplatePrefix(File templateFile) {
        String f = templateFile.getAbsolutePath();
        int i = f.lastIndexOf(TEMPLATE_PREFIX);
        if (i != -1) {
            return new File(f.substring(0, i) + f.substring(i + TEMPLATE_PREFIX.length() - 1));
        }
        throw new IllegalArgumentException("File " + templateFile + " does not contain template prefix");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!DITA_OT_NS.equals(uri) || !"extension".equals(localName)) {
            this.getContentHandler().endElement(uri, localName, qName);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (DITA_OT_NS.equals(uri) && "extension".equals(localName)) {
                IAction action = (IAction)Class.forName(attributes.getValue(BEHAVIOR_ATTR)).newInstance();
                action.setLogger(this.logger);
                action.addParam(PARAM_TEMPLATE, this.templateFile.getAbsolutePath());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    action.addParam(attributes.getLocalName(i), attributes.getValue(i));
                }
                String extension = attributes.getValue(EXTENSION_ID_ATTR);
                if (this.featureTable.containsKey(extension)) {
                    action.setInput(this.featureTable.get(extension));
                }
                action.setFeatures(this.pluginTable);
                action.getResult(this.getContentHandler());
            } else {
                Map<String, String> extensions = this.parseExtensions(attributes.getValue(DITA_OT_NS, "extension"));
                XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder();
                int attLen = attributes.getLength();
                for (int i = 0; i < attLen; ++i) {
                    String name = attributes.getLocalName(i);
                    if (DITA_OT_NS.equals(attributes.getURI(i))) {
                        if ("extension".equals(name)) continue;
                        if (extensions.containsKey(name)) {
                            IAction action = (IAction)Class.forName(extensions.get(name)).newInstance();
                            action.setLogger(this.logger);
                            action.setFeatures(this.pluginTable);
                            action.addParam(PARAM_TEMPLATE, this.templateFile.getAbsolutePath());
                            List<Value> value = Stream.of(attributes.getValue(i).split(",")).map(val -> new Value(null, (String)val)).collect(Collectors.toList());
                            action.setInput(value);
                            String result = action.getResult();
                            atts.add(name, result);
                            continue;
                        }
                        throw new IllegalArgumentException("Extension attribute " + name + " not defined");
                    }
                    atts.add(attributes.getURI(i), name, attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                }
                this.getContentHandler().startElement(uri, localName, qName, atts.build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
        }
    }

    private Map<String, String> parseExtensions(String extensions) {
        if (extensions == null) {
            return DEFAULT_EXTENSIONS;
        }
        HashMap<String, String> res = new HashMap<String, String>(DEFAULT_EXTENSIONS);
        StringTokenizer extensionTokenizer = new StringTokenizer(extensions);
        while (extensionTokenizer.hasMoreTokens()) {
            String thisExtension = extensionTokenizer.nextToken();
            String thisExtensionClass = extensionTokenizer.nextToken();
            res.put(thisExtension, thisExtensionClass);
        }
        return res;
    }
}

