/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.dita.dost.platform.ExtensionPoint;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.Value;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginParser {
    private static final String EXTENSION_POINT_ELEM = "extension-point";
    private static final String EXTENSION_POINT_NAME_ATTR = "name";
    private static final String EXTENSION_POINT_ID_ATTR = "id";
    private static final String TEMPLATE_ELEM = "template";
    private static final String TEMPLATE_FILE_ATTR = "file";
    private static final String META_ELEM = "meta";
    private static final String META_VALUE_ATTR = "value";
    private static final String META_TYPE_ATTR = "type";
    private static final String REQUIRE_ELEM = "require";
    private static final String REQUIRE_IMPORTANCE_ATTR = "importance";
    private static final String REQUIRE_PLUGIN_ATTR = "plugin";
    public static final String FEATURE_ELEM = "feature";
    private static final String TRANSTYPE_ELEM = "transtype";
    private static final String TRANSTYPE_ABSTRACT_ATTR = "abstract";
    private static final String TRANSTYPE_NAME_ATTR = "name";
    public static final String FEATURE_ID_ATTR = "extension";
    public static final String FEATURE_VALUE_ATTR = "value";
    public static final String PLUGIN_ELEM = "plugin";
    private static final String PLUGIN_ID_ATTR = "id";
    private static final String PLUGIN_VERSION_ATTR = "version";
    private final File ditaDir;
    private final DocumentBuilder builder;
    private File pluginDir;
    private Features features;
    private String currentPlugin = null;

    public PluginParser(File ditaDir) {
        assert (ditaDir.isAbsolute());
        this.ditaDir = ditaDir;
        this.builder = XMLUtils.getDocumentBuilder();
    }

    public void setPluginDir(File pluginDir) {
        assert (pluginDir.isAbsolute());
        this.pluginDir = pluginDir;
    }

    public Features getFeatures() {
        return this.features;
    }

    public Element parse(File file) throws Exception {
        Document doc;
        this.features = new Features(this.pluginDir, this.ditaDir);
        try {
            doc = this.builder.parse(file);
        }
        catch (IOException | SAXException e) {
            throw new Exception("Failed to parse " + file + ": " + e.getMessage(), e);
        }
        Element root = this.migrate(doc.getDocumentElement());
        this.currentPlugin = root.getAttribute("id");
        this.features.setPluginId(this.currentPlugin);
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element elem = (Element)children.item(i);
            String qName = elem.getTagName();
            if (EXTENSION_POINT_ELEM.equals(qName)) {
                this.addExtensionPoint(elem);
                continue;
            }
            if (TRANSTYPE_ELEM.equals(qName)) {
                this.addTranstype(elem);
                continue;
            }
            if (FEATURE_ELEM.equals(qName)) {
                this.features.addFeature(elem.getAttribute(FEATURE_ID_ATTR), elem);
                continue;
            }
            if (REQUIRE_ELEM.equals(qName)) {
                String importance = elem.getAttribute(REQUIRE_IMPORTANCE_ATTR);
                this.features.addRequire(elem.getAttribute("plugin"), importance.isEmpty() ? null : importance);
                continue;
            }
            if (META_ELEM.equals(qName)) {
                this.features.addMeta(elem.getAttribute(META_TYPE_ATTR), elem.getAttribute("value"));
                continue;
            }
            if (!TEMPLATE_ELEM.equals(qName)) continue;
            this.features.addTemplate(new Value(this.currentPlugin, elem.getAttribute(TEMPLATE_FILE_ATTR)));
        }
        return root;
    }

    private Element migrate(Element root) {
        if (root.getAttributeNode(PLUGIN_VERSION_ATTR) == null) {
            List features = XMLUtils.toList(root.getElementsByTagName(FEATURE_ELEM));
            String version = features.stream().filter(elem -> elem.getAttribute(FEATURE_ID_ATTR).equals("package.version")).findFirst().map(elem -> elem.getAttribute("value")).orElse("0.0.0");
            root.setAttribute(PLUGIN_VERSION_ATTR, version);
        }
        return root;
    }

    private void addTranstype(Element elem) {
        if (!Boolean.parseBoolean(elem.getAttribute(TRANSTYPE_ABSTRACT_ATTR))) {
            Document doc = elem.getOwnerDocument();
            for (String transtype : elem.getAttribute("name").split("\\s+")) {
                Element buf = doc.createElement(FEATURE_ELEM);
                buf.setAttribute("value", transtype);
                this.features.addFeature("dita.conductor.transtype.check", buf);
            }
        }
    }

    private void addExtensionPoint(Element elem) {
        String id = elem.getAttribute("id");
        if (id == null) {
            throw new IllegalArgumentException("id attribute not set on extension-point");
        }
        String name = elem.getAttribute("name");
        this.features.addExtensionPoint(new ExtensionPoint(id, name, this.currentPlugin));
    }
}

