/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Plugins {
    public static List<String> getInstalledPlugins() {
        List plugins = XMLUtils.toList(Plugins.getPluginConfiguration().getElementsByTagName("plugin"));
        return plugins.stream().map(elem -> elem.getAttributeNode("id")).filter(Objects::nonNull).map(Attr::getValue).sorted().collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getPluginConfiguration() {
        try (InputStream in = Plugins.class.getClassLoader().getResourceAsStream("plugins.xml");){
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Failed to read plugin configuration: " + e.getMessage(), e);
        }
    }
}

