/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dita.dost.platform.SemVer;
import org.dita.dost.platform.SemVerMatch;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Registry {
    public final String name;
    public final SemVer vers;
    public final List<Dependency> deps;
    public final URL url;
    public final String cksum;

    @JsonCreator
    public Registry(@JsonProperty(value="name") String name, @JsonProperty(value="vers") String vers, @JsonProperty(value="deps") Dependency[] deps, @JsonProperty(value="url") String url, @JsonProperty(value="cksum") String cksum) {
        this.name = name;
        this.vers = new SemVer(vers);
        this.deps = deps == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(deps));
        try {
            this.url = url != null ? new URL(url) : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.cksum = cksum;
    }

    public static class Dependency {
        public final String name;
        public final SemVerMatch req;

        @JsonCreator
        public Dependency(@JsonProperty(value="name") String name, @JsonProperty(value="req") String req) {
            this.name = name;
            this.req = new SemVerMatch(req);
        }
    }
}

