/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dita.dost.platform.SemVer;

public class SemVerMatch {
    private static final Pattern MATCH_PATTERN = Pattern.compile("(~|\\^|<=?|>=?)?([0-9.x*]+?)(-.+?(\\+.+?)?)?");
    public final Range start;
    public final Range end;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVerMatch that = (SemVerMatch)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public SemVerMatch(Range start, Range end) {
        this.start = start;
        this.end = end;
    }

    public SemVerMatch(String str) {
        Match match;
        if (str.equals("") || str.equals("*")) {
            this.start = new Range(Match.GE, 0, 0, 0);
            this.end = null;
            return;
        }
        Matcher matcher = MATCH_PATTERN.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        if (matcher.group(1) != null) {
            switch (matcher.group(1)) {
                case "~": {
                    match = Match.TILDE;
                    break;
                }
                case "^": {
                    match = Match.CARET;
                    break;
                }
                case "<": {
                    match = Match.LT;
                    break;
                }
                case "<=": {
                    match = Match.LE;
                    break;
                }
                case ">": {
                    match = Match.GT;
                    break;
                }
                case ">=": {
                    match = Match.GE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        } else {
            match = Match.EQ;
        }
        String[] tokens = matcher.group(2).split("\\.");
        Integer major = tokens.length >= 1 ? SemVerMatch.parseToken(tokens[0]) : null;
        Integer minor = tokens.length >= 2 ? SemVerMatch.parseToken(tokens[1]) : null;
        Integer patch = tokens.length >= 3 ? SemVerMatch.parseToken(tokens[2]) : null;
        switch (match) {
            case TILDE: {
                this.start = new Range(Match.GE, major != null ? major : 0, minor != null ? minor : 0, patch != null ? patch : 0);
                this.end = SemVerMatch.tilde(Match.LT, major, minor);
                break;
            }
            case CARET: {
                this.start = new Range(Match.GE, major != null ? major : 0, minor != null ? minor : 0, patch != null ? patch : 0);
                this.end = SemVerMatch.caret(Match.LT, major, minor, patch);
                break;
            }
            case LT: {
                this.start = new Range(Match.GE, 0, 0, 0);
                this.end = new Range(Match.LT, major != null ? major : 0, minor != null ? minor : 0, patch != null ? patch : 0);
                break;
            }
            case LE: {
                this.start = new Range(Match.GE, 0, 0, 0);
                this.end = new Range(Match.LE, major != null ? major : 0, minor != null ? minor : 0, patch != null ? patch : 0);
                break;
            }
            case GT: {
                this.start = new Range(Match.GT, major != null ? major : 0, minor != null ? minor : 0, patch != null ? patch : 0);
                this.end = null;
                break;
            }
            case GE: {
                this.start = new Range(Match.GE, major != null ? major : 0, minor != null ? minor : 0, patch != null ? patch : 0);
                this.end = null;
                break;
            }
            case EQ: {
                this.start = new Range(Match.GE, major != null ? major : 0, minor != null ? minor : 0, patch != null ? patch : 0);
                this.end = SemVerMatch.inc(Match.LT, major, minor, patch);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static Range inc(Match match, Integer major, Integer minor, Integer patch) {
        Integer major1 = major != null && minor == null && patch == null ? Integer.valueOf(major + 1) : major;
        Integer minor1 = null != minor && patch == null ? Integer.valueOf(minor + 1) : minor;
        Integer patch1 = patch != null ? Integer.valueOf(patch + 1) : patch;
        return new Range(match, major1 != null ? major1 : 0, minor1 != null ? minor1 : 0, patch1 != null ? patch1 : 0);
    }

    private static Range tilde(Match match, Integer major, Integer minor) {
        Integer major1 = major != null && minor == null ? Integer.valueOf(major + 1) : major;
        Integer minor1 = minor != null ? Integer.valueOf(minor + 1) : null;
        Integer patch1 = null;
        return new Range(match, major1 != null ? major1 : 0, minor1 != null ? minor1 : 0, patch1 != null ? patch1 : 0);
    }

    private static Range caret(Match match, Integer major, Integer minor, Integer patch) {
        int i;
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        if (major != null) {
            tokens.add(major);
            if (minor != null) {
                tokens.add(minor);
                if (patch != null) {
                    tokens.add(patch);
                }
            }
        }
        for (i = 0; i < tokens.size() && (Integer)tokens.get(i) == 0; ++i) {
        }
        if (i == tokens.size()) {
            i = tokens.size() - 1;
        }
        tokens.set(i, (Integer)tokens.get(i) + 1);
        ++i;
        while (i < tokens.size()) {
            tokens.set(i, 0);
            ++i;
        }
        return new Range(match, tokens.size() > 0 && tokens.get(0) != null ? (Integer)tokens.get(0) : Integer.valueOf(0), tokens.size() > 1 && tokens.get(1) != null ? (Integer)tokens.get(1) : Integer.valueOf(0), tokens.size() > 2 && tokens.get(2) != null ? (Integer)tokens.get(2) : Integer.valueOf(0));
    }

    private static Integer parseToken(String token) {
        switch (token) {
            case "x": 
            case "X": 
            case "*": {
                return null;
            }
        }
        return Integer.valueOf(token);
    }

    public boolean contains(SemVer semver) {
        if (this.start != null && !this.compare(this.start.version, semver, this.start.match)) {
            return false;
        }
        return this.end == null || this.compare(this.end.version, semver, this.end.match);
    }

    private boolean compare(SemVer self, SemVer other, Match ops) {
        int res = -1 * self.compareTo(other);
        switch (ops) {
            case LT: {
                return res < 0;
            }
            case LE: {
                return res <= 0;
            }
            case GT: {
                return res > 0;
            }
            case GE: {
                return res >= 0;
            }
            case EQ: {
                return res == 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.start != null) {
            buf.append(this.start);
        }
        if (this.start != null && this.end != null) {
            buf.append(" ");
        }
        if (this.end != null) {
            buf.append(this.end);
        }
        return buf.toString();
    }

    public static class Range {
        public final Match match;
        public final SemVer version;

        public Range(Match match, Integer major, Integer minor, Integer patch) {
            if (match == null || major == null || minor == null || patch == null) {
                throw new NullPointerException();
            }
            this.match = match;
            this.version = new SemVer(major, minor, patch);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.match != null) {
                switch (this.match) {
                    case TILDE: {
                        buf.append("~");
                        break;
                    }
                    case CARET: {
                        buf.append("^");
                        break;
                    }
                    case LT: {
                        buf.append("<");
                        break;
                    }
                    case LE: {
                        buf.append("<=");
                        break;
                    }
                    case GT: {
                        buf.append(">");
                        break;
                    }
                    case GE: {
                        buf.append(">=");
                        break;
                    }
                    case EQ: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            buf.append(this.version.toString());
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.match == range.match && Objects.equals(this.version, range.version);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.match, this.version});
        }
    }

    static enum Match {
        TILDE,
        CARET,
        EQ,
        LT,
        LE,
        GT,
        GE;

    }
}

