/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.project;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.dita.dost.project.Project;
import org.dita.dost.project.ProjectBuilder;
import org.dita.dost.project.XmlReader;
import org.dita.dost.util.FileUtils;
import org.slf4j.Logger;
import org.xml.sax.SAXParseException;

public class ProjectFactory {
    private static final ObjectReader jsonReader = new ObjectMapper().reader().forType(ProjectBuilder.class).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private static final ObjectReader yamlReader = new YAMLMapper().reader().forType(ProjectBuilder.class).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private final XmlReader xmlReader = new XmlReader();
    private Logger logger;
    private boolean lax;

    public static ProjectFactory getInstance() {
        return new ProjectFactory();
    }

    public Project load(URI file) throws IOException {
        try {
            return ProjectFactory.resolveReferences(this.load(file, Collections.emptySet()));
        }
        catch (SAXParseException e) {
            if (e.getLineNumber() != -1) {
                throw new IOException(String.format("Failed to read project file %s:%s:%s: %s", file, e.getLineNumber(), e.getColumnNumber(), e.getLocalizedMessage()), e);
            }
            throw new IOException(String.format("Failed to read project file %s: %s", file, e.getLocalizedMessage()), e);
        }
        catch (IOException e) {
            throw new IOException("Failed to read project file: " + e.getMessage(), e);
        }
    }

    @VisibleForTesting
    static Project resolveReferences(Project src) {
        return new Project(src.deliverables == null ? Collections.emptyList() : src.deliverables.stream().map(deliverable -> new Project.Deliverable(deliverable.name, deliverable.id, Optional.ofNullable(deliverable.context).flatMap(context -> Optional.ofNullable(context.idref)).map(idref -> {
            Project.Context pub = src.contexts.stream().filter(context -> Objects.equals(context.id, deliverable.context.idref)).findAny().orElseThrow(() -> new RuntimeException(String.format("Context not found: %s", deliverable.context.idref)));
            return pub;
        }).orElse(deliverable.context), deliverable.output, Optional.ofNullable(deliverable.publication).flatMap(publication -> Optional.ofNullable(publication.idref)).map(idref -> {
            Project.Publication pub = src.publications.stream().filter(publication -> Objects.equals(publication.id, deliverable.publication.idref)).findAny().orElseThrow(() -> new RuntimeException(String.format("Publication not found: %s", deliverable.publication.idref)));
            return pub;
        }).orElse(deliverable.publication))).collect(Collectors.toList()), src.includes, src.publications, src.contexts);
    }

    private Project load(URI file, Set<URI> processed) throws IOException, SAXParseException {
        ProjectBuilder builder;
        if (processed.contains(file)) {
            throw new RuntimeException("Recursive project file import: " + file);
        }
        switch (FileUtils.getExtension(file.getPath()).toLowerCase()) {
            case "xml": {
                this.xmlReader.setLogger(this.logger);
                this.xmlReader.setLax(this.lax);
                builder = this.xmlReader.read(file);
                break;
            }
            case "json": {
                builder = (ProjectBuilder)jsonReader.readValue(file.toURL());
                break;
            }
            case "yaml": {
                builder = (ProjectBuilder)yamlReader.readValue(file.toURL());
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized project file format: " + file);
            }
        }
        Project project = Project.build(builder, file);
        return this.resolveIncludes(project, file, (Set<URI>)ImmutableSet.builder().addAll(processed).add((Object)file).build());
    }

    private Project resolveIncludes(Project project, URI base, Set<URI> processed) throws IOException, SAXParseException {
        ArrayList<Project.Context> contexts;
        if (project.includes == null || project.includes.isEmpty()) {
            return project;
        }
        ArrayList<Project.Deliverable> deliverables = project.deliverables != null ? new ArrayList<Project.Deliverable>(project.deliverables) : new ArrayList();
        ArrayList<Project.Publication> publications = project.publications != null ? new ArrayList<Project.Publication>(project.publications) : new ArrayList();
        ArrayList<Project.Context> arrayList = contexts = project.contexts != null ? new ArrayList<Project.Context>(project.contexts) : new ArrayList();
        if (project.includes != null) {
            for (Project.ProjectRef projectRef : project.includes) {
                URI href = projectRef.href.isAbsolute() ? projectRef.href : base.resolve(projectRef.href);
                Project ref = this.load(href, processed);
                if (ref.deliverables != null) {
                    deliverables.addAll(ref.deliverables);
                }
                if (ref.publications != null) {
                    publications.addAll(ref.publications);
                }
                if (ref.contexts == null) continue;
                contexts.addAll(ref.contexts);
            }
        }
        return new Project(deliverables, project.includes, publications, contexts);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLax(boolean lax) {
        this.lax = lax;
    }
}

