/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.Constants;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractDomFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MapMetaReader
extends AbstractDomFilter {
    private final Map<URI, Map<String, Element>> resultTable = new HashMap<URI, Map<String, Element>>(16);
    private static final Set<String> uniqueSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_SOURCE.matcher, Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_SEARCHTITLE.matcher)));
    private static final Set<String> cascadeSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_METADATA.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_PUBLISHER.matcher)));
    private static final Set<String> metaSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_SEARCHTITLE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_SOURCE.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_KEYWORDS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_OTHERMETA.matcher, Constants.TOPIC_RESOURCEID.matcher, Constants.TOPIC_DATA.matcher, Constants.TOPIC_DATA_ABOUT.matcher, Constants.TOPIC_FOREIGN.matcher, Constants.TOPIC_UNKNOWN.matcher)));
    private static final List<String> metaPos = Collections.unmodifiableList(Arrays.asList(Constants.MAP_SEARCHTITLE.matcher, Constants.TOPIC_SEARCHTITLE.matcher, Constants.TOPIC_AUTHOR.matcher, Constants.TOPIC_SOURCE.matcher, Constants.TOPIC_PUBLISHER.matcher, Constants.TOPIC_COPYRIGHT.matcher, Constants.TOPIC_CRITDATES.matcher, Constants.TOPIC_PERMISSIONS.matcher, Constants.TOPIC_AUDIENCE.matcher, Constants.TOPIC_CATEGORY.matcher, Constants.TOPIC_KEYWORDS.matcher, Constants.TOPIC_PRODINFO.matcher, Constants.TOPIC_OTHERMETA.matcher, Constants.TOPIC_RESOURCEID.matcher, Constants.TOPIC_DATA.matcher, Constants.TOPIC_DATA_ABOUT.matcher, Constants.TOPIC_FOREIGN.matcher, Constants.TOPIC_UNKNOWN.matcher, Constants.MAP_LINKTEXT.matcher, Constants.TOPIC_LINKTEXT.matcher, Constants.MAP_SHORTDESC.matcher, Constants.TOPIC_SHORTDESC.matcher, Constants.TOPIC_NAVTITLE.matcher, Constants.TOPIC_METADATA.matcher, Constants.DELAY_D_EXPORTANCHORS.matcher));
    private final Map<String, Element> globalMeta = new HashMap<String, Element>(16);
    private Document doc = null;
    private Document resultDoc = XMLUtils.getDocumentBuilder().newDocument();
    private File filePath = null;

    public MapMetaReader() {
        this.resultTable.clear();
    }

    @Override
    public void read(File filename) throws DITAOTException {
        this.filePath = filename;
        this.globalMeta.clear();
        super.read(filename);
    }

    @Override
    public Document process(Document doc) {
        this.doc = doc;
        NodeList list = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem;
            Attr classAttr;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || (classAttr = (elem = (Element)node).getAttributeNode("class")) == null) continue;
            if (Constants.MAP_TOPICMETA.matches(classAttr.getNodeValue())) {
                this.handleGlobalMeta(elem);
                continue;
            }
            if (!Constants.MAP_TOPICREF.matches(classAttr.getNodeValue())) continue;
            this.handleTopicref(elem, this.globalMeta);
        }
        for (Map<String, Element> resultTableEntry : this.resultTable.values()) {
            for (Map.Entry<String, Element> mapEntry : resultTableEntry.entrySet()) {
                String key = mapEntry.getKey();
                if (!Constants.TOPIC_KEYWORDS.matcher.equals(key)) continue;
                this.removeIndexTermRecursive(mapEntry.getValue());
            }
        }
        return doc;
    }

    private void removeIndexTermRecursive(Element parent) {
        if (parent == null) {
            return;
        }
        NodeList children = parent.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            boolean hasEnd;
            if (children.item(i).getNodeType() != 1) continue;
            Element child = (Element)children.item(i);
            boolean isIndexTerm = Constants.TOPIC_INDEXTERM.matches(child);
            boolean hasStart = !child.getAttribute("start").isEmpty();
            boolean bl = hasEnd = !child.getAttribute("end").isEmpty();
            if (isIndexTerm && (hasStart || hasEnd)) {
                parent.removeChild(child);
                continue;
            }
            this.removeIndexTermRecursive(child);
        }
    }

    private void handleTopicref(Element topicref, Map<String, Element> inheritance) {
        Attr hrefAttr = topicref.getAttributeNode("href");
        Attr copytoAttr = topicref.getAttributeNode("copy-to");
        Attr scopeAttr = topicref.getAttributeNode("scope");
        Attr formatAttr = topicref.getAttributeNode("format");
        Map<String, Element> current = this.mergeMeta(null, inheritance, cascadeSet);
        Element metaNode = null;
        NodeList children = topicref.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element elem;
            Attr classAttr;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || (classAttr = (elem = (Element)node).getAttributeNode("class")) == null) continue;
            if (Constants.MAP_TOPICMETA.matches(classAttr.getNodeValue()) && hrefAttr != null && this.isLocalScope(scopeAttr) && this.isDitaFormat(formatAttr)) {
                metaNode = elem;
                current = this.handleMeta(elem, inheritance);
                continue;
            }
            if (!Constants.MAP_TOPICREF.matches(classAttr.getNodeValue())) continue;
            this.handleTopicref(elem, current);
        }
        if (!current.isEmpty() && hrefAttr != null && this.isDitaFormat(formatAttr) && this.isLocalScope(scopeAttr)) {
            URI topicPath;
            if (copytoAttr != null) {
                URI copyToUri = URLUtils.stripFragment(URLUtils.toURI(copytoAttr.getNodeValue()));
                topicPath = this.job.tempDirURI.relativize(this.filePath.toURI().resolve(copyToUri));
            } else {
                URI hrefUri = URLUtils.toURI(hrefAttr.getNodeValue());
                topicPath = this.job.tempDirURI.relativize(this.filePath.toURI().resolve(hrefUri));
            }
            if (this.resultTable.containsKey(topicPath)) {
                Map<String, Element> previous = this.resultTable.get(topicPath);
                this.resultTable.put(topicPath, this.mergeMeta(previous, current, metaSet));
            } else {
                this.resultTable.put(topicPath, this.cloneElementMap(current));
            }
            Map<String, Element> metas = this.resultTable.get(topicPath);
            if (!metas.isEmpty()) {
                if (metaNode != null) {
                    topicref.removeChild(metaNode);
                }
                Element newMeta = this.doc.createElement(Constants.MAP_TOPICMETA.localName);
                newMeta.setAttribute("class", "-" + Constants.MAP_TOPICMETA.matcher);
                for (String metaPo : metaPos) {
                    Node stub = metas.get(metaPo);
                    if (stub == null) continue;
                    NodeList clist = stub.getChildNodes();
                    for (int j = 0; j < clist.getLength(); ++j) {
                        newMeta.appendChild(topicref.getOwnerDocument().importNode(clist.item(j), true));
                    }
                }
                topicref.insertBefore(newMeta, topicref.getFirstChild());
            }
        }
    }

    private boolean isLocalScope(Attr scopeAttr) {
        return scopeAttr == null || scopeAttr.getNodeValue().equals("local");
    }

    private boolean isDitaFormat(Attr formatAttr) {
        return formatAttr == null || "dita".equals(formatAttr.getNodeValue()) || "ditamap".equals(formatAttr.getNodeValue());
    }

    private Map<String, Element> cloneElementMap(Map<String, Element> current) {
        HashMap<String, Element> topicMetaTable = new HashMap<String, Element>(16);
        for (Map.Entry<String, Element> topicMetaItem : current.entrySet()) {
            topicMetaTable.put(topicMetaItem.getKey(), (Element)this.resultDoc.importNode(topicMetaItem.getValue(), true));
        }
        return topicMetaTable;
    }

    private Map<String, Element> handleMeta(Element meta, Map<String, Element> inheritance) {
        HashMap<String, Element> topicMetaTable = new HashMap<String, Element>(16);
        this.getMeta(meta, topicMetaTable);
        return this.mergeMeta(topicMetaTable, inheritance, cascadeSet);
    }

    private void getMeta(Element meta, Map<String, Element> topicMetaTable) {
        NodeList children = meta.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element elem;
            Attr classAttr;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || (classAttr = (elem = (Element)node).getAttributeNode("class")) == null) continue;
            String classValue = classAttr.getNodeValue();
            String metaKey = classValue.substring(1, classValue.indexOf(" ", classValue.indexOf("/")) + 1);
            if (Constants.TOPIC_METADATA.matches(classValue)) {
                this.getMeta(elem, topicMetaTable);
                continue;
            }
            if (topicMetaTable.containsKey(metaKey)) {
                topicMetaTable.get(metaKey).appendChild(this.resultDoc.importNode(elem, true));
                continue;
            }
            if (Constants.TOPIC_NAVTITLE.matches(classValue)) {
                String locktitleAttr = ((Element)meta.getParentNode()).getAttributeNode("locktitle") != null ? ((Element)meta.getParentNode()).getAttributeNode("locktitle").getNodeValue() : "no";
                elem.setAttributeNS("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "dita-ot:locktitle", locktitleAttr);
            }
            Element stub = this.resultDoc.createElement("stub");
            stub.appendChild(this.resultDoc.importNode(elem, true));
            topicMetaTable.put(metaKey, stub);
        }
    }

    private Map<String, Element> mergeMeta(Map<String, Element> topicMetaTable, Map<String, Element> inheritance, Set<String> enableSet) {
        if (topicMetaTable == null) {
            topicMetaTable = new HashMap<String, Element>(16);
        }
        for (String key : enableSet) {
            Node inheritStub;
            if (!inheritance.containsKey(key)) continue;
            if (uniqueSet.contains(key)) {
                if (topicMetaTable.containsKey(key)) continue;
                topicMetaTable.put(key, inheritance.get(key));
                continue;
            }
            if (!topicMetaTable.containsKey(key)) {
                topicMetaTable.put(key, inheritance.get(key));
                continue;
            }
            Element stub = topicMetaTable.get(key);
            if (stub != (inheritStub = (Node)inheritance.get(key))) {
                NodeList children = inheritStub.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node item = children.item(i).cloneNode(true);
                    item = stub.getOwnerDocument().importNode(item, true);
                    stub.appendChild(item);
                }
            }
            topicMetaTable.put(key, stub);
        }
        return topicMetaTable;
    }

    private void handleGlobalMeta(Element metadata) {
        NodeList children = metadata.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element elem;
            Attr classAttr;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || (classAttr = (elem = (Element)node).getAttributeNode("class")) == null) continue;
            String classValue = classAttr.getNodeValue();
            String metaKey = classValue.substring(1, classValue.indexOf(" ", classValue.indexOf("/")) + 1);
            if (Constants.TOPIC_METADATA.matches(classValue)) {
                this.handleGlobalMeta(elem);
                continue;
            }
            if (cascadeSet.contains(metaKey) && this.globalMeta.containsKey(metaKey)) {
                this.globalMeta.get(metaKey).appendChild(this.resultDoc.importNode(elem, true));
                continue;
            }
            if (!cascadeSet.contains(metaKey)) continue;
            Element stub = this.resultDoc.createElement("stub");
            stub.appendChild(this.resultDoc.importNode(elem, true));
            this.globalMeta.put(metaKey, stub);
        }
    }

    public Map<URI, Map<String, Element>> getMapping() {
        return Collections.unmodifiableMap(this.resultTable);
    }
}

