/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SubjectSchemeReader {
    private DITAOTLogger logger;
    private Job job;
    private final Map<QName, Map<String, Set<Element>>> bindingMap;
    private final Map<QName, Map<String, Set<String>>> validValuesMap = new HashMap<QName, Map<String, Set<String>>>();
    private final Map<QName, Map<String, String>> defaultValueMap = new HashMap<QName, Map<String, String>>();

    public SubjectSchemeReader() {
        this.bindingMap = new HashMap<QName, Map<String, Set<Element>>>();
    }

    public void reset() {
        this.validValuesMap.clear();
        this.defaultValueMap.clear();
        this.bindingMap.clear();
    }

    public Map<QName, Map<String, Set<String>>> getValidValuesMap() {
        return this.validValuesMap;
    }

    public Map<QName, Map<String, String>> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    public SubjectScheme getSubjectSchemeMap() {
        return new SubjectScheme(this.bindingMap);
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public Map<URI, Set<URI>> readMapFromXML(File inputFile) throws IOException {
        HashMap graph = new HashMap();
        if (!inputFile.exists()) {
            return Collections.emptyMap();
        }
        Properties prop = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(this.job.getStore().getInputStream(inputFile.toURI()));){
            prop.loadFromXML(in);
        }
        catch (IOException e) {
            throw new IOException("Failed to read subject scheme graph: " + e.getMessage(), e);
        }
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            HashSet<URI> r = new HashSet<URI>();
            for (String v : StringUtils.restoreSet(value, ",")) {
                r.add(URLUtils.toURI(v));
            }
            graph.put(URLUtils.toURI(key), r);
        }
        return Collections.unmodifiableMap(graph);
    }

    public void writeMapToXML(Map<URI, Set<URI>> m, File outputFile) throws IOException {
        if (m == null) {
            return;
        }
        Properties prop = new Properties();
        for (Map.Entry<URI, Set<URI>> entry : m.entrySet()) {
            URI key = entry.getKey();
            String value = StringUtils.join(entry.getValue(), ",");
            prop.setProperty(key.getPath(), value);
        }
        try (OutputStream os = this.job.getStore().getOutputStream(outputFile.toURI());){
            prop.storeToXML(os, null);
        }
        catch (IOException e) {
            throw new IOException("Failed to write subject scheme graph: " + e.getMessage(), e);
        }
    }

    public void loadSubjectScheme(File scheme) {
        assert (scheme.isAbsolute());
        if (!this.job.getStore().exists(scheme.toURI())) {
            throw new IllegalStateException();
        }
        this.logger.debug("Load subject scheme " + scheme);
        try {
            Document doc = this.job.getStore().getDocument(scheme.toURI());
            Element schemeRoot = doc.getDocumentElement();
            if (schemeRoot == null) {
                return;
            }
            this.loadSubjectScheme(schemeRoot);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public void loadSubjectScheme(Element schemeRoot) {
        List<Element> rootChildren = XMLUtils.getChildElements(schemeRoot);
        for (Element child : rootChildren) {
            String attrValue = child.getAttribute("class");
            if (!Constants.SUBJECTSCHEME_ENUMERATIONDEF.matches(attrValue)) continue;
            this.processEnumerationDef(schemeRoot, child);
        }
    }

    public void processEnumerationDef(Element schemeRoot, Element enumerationDef) {
        List<Element> enumChildren = XMLUtils.getChildElements(enumerationDef);
        String elementName = "*";
        QName attributeName = null;
        for (Element child : enumChildren) {
            Set<Element> A;
            Element subTree;
            String keyValue;
            String attrValue = child.getAttribute("class");
            if (Constants.SUBJECTSCHEME_ELEMENTDEF.matches(attrValue)) {
                elementName = child.getAttribute("name");
                continue;
            }
            if (Constants.SUBJECTSCHEME_ATTRIBUTEDEF.matches(attrValue)) {
                String name = child.getAttribute("name");
                attributeName = name != null ? QName.valueOf(name) : null;
                Map map = this.bindingMap.computeIfAbsent(attributeName, k -> new HashMap());
                continue;
            }
            if (Constants.SUBJECTSCHEME_DEFAULTSUBJECT.matches(attrValue)) {
                keyValue = child.getAttribute("keyref");
                if (keyValue == null) continue;
                Map<String, String> S = this.defaultValueMap.get(attributeName);
                if (S == null) {
                    S = new HashMap<String, String>();
                }
                S.put(elementName, keyValue);
                this.defaultValueMap.put(attributeName, S);
                continue;
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(attrValue)) continue;
            keyValue = child.getAttribute("keyref");
            if (StringUtils.isEmptyString(keyValue)) {
                keyValue = child.getAttribute("keys");
            }
            if ((subTree = this.searchForKey(schemeRoot, keyValue)) == null) continue;
            Map<String, Set<Element>> S = this.bindingMap.get(attributeName);
            if (S == null) {
                S = new HashMap<String, Set<Element>>();
            }
            if ((A = S.get(elementName)) == null) {
                A = new HashSet<Element>();
            }
            if (!A.contains(subTree)) {
                this.putValuePairsIntoMap(subTree, elementName, attributeName, keyValue);
            }
            A.add(subTree);
            S.put(elementName, A);
            this.bindingMap.put(attributeName, S);
        }
    }

    private Element searchForKey(Element root, String keyValue) {
        if (root == null || keyValue == null) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.add(root);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.removeFirst();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.add((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || !keyValue.equals(key = node.getAttribute("keys"))) continue;
            return node;
        }
        return null;
    }

    private void putValuePairsIntoMap(Element subtree, String elementName, QName attName, String category) {
        Set<String> valueSet;
        if (subtree == null || attName == null) {
            return;
        }
        Map<String, Set<String>> valueMap = this.validValuesMap.get(attName);
        if (valueMap == null) {
            valueMap = new HashMap<String, Set<String>>();
        }
        if ((valueSet = valueMap.get(elementName)) == null) {
            valueSet = new HashSet<String>();
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(subtree);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.poll();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.offer((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || (key = node.getAttribute("keys")) == null || key.trim().isEmpty() || key.equals(category)) continue;
            valueSet.add(key);
        }
        valueMap.put(elementName, valueSet);
        this.validValuesMap.put(attName, valueMap);
    }
}

