/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.store;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.sf.saxon.s9api.XsltTransformer;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.store.Store;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.XMLFilter;

public abstract class AbstractStore
implements Store {
    static final boolean LOG = false;
    protected final XMLUtils xmlUtils;
    public final File tempDir;
    public final URI tempDirUri;

    public AbstractStore(File tempDir, XMLUtils xmlUtils) {
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        this.tempDirUri = tempDir.toURI();
        this.tempDir = tempDir;
        this.xmlUtils = xmlUtils;
    }

    @Override
    public URI getUri(URI path) {
        return this.tempDirUri.resolve(path).normalize();
    }

    protected boolean isTempFile(URI f) {
        return f.toString().startsWith(this.tempDirUri.toString());
    }

    @Override
    public void transform(URI input, URI output, List<XMLFilter> filters) throws DITAOTException {
        URI dst;
        URI src = input.normalize();
        if (src.equals(dst = output.normalize())) {
            this.transform(src, filters);
        } else {
            this.transformURI(src, dst, filters);
        }
    }

    @Override
    public void transform(URI src, List<XMLFilter> filters) throws DITAOTException {
        URI srcFile = URLUtils.setFragment(src, null);
        URI dst = URLUtils.toURI(srcFile.toString() + ".temp").normalize();
        this.transformURI(srcFile, dst, filters);
        try {
            this.move(dst, srcFile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to replace " + srcFile + ": " + e.getMessage());
        }
    }

    abstract void transformURI(URI var1, URI var2, List<XMLFilter> var3) throws DITAOTException;

    abstract void transformUri(URI var1, URI var2, XsltTransformer var3) throws DITAOTException;
}

