/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dita.dost.util.Configuration;

public final class CatalogUtils {
    private static CatalogResolver catalogResolver = null;
    private static File ditaDir;

    private CatalogUtils() {
    }

    public static synchronized void setDitaDir(File ditaDir) {
        catalogResolver = null;
        CatalogUtils.ditaDir = ditaDir;
    }

    public static synchronized CatalogResolver getCatalogResolver() {
        if (catalogResolver == null) {
            CatalogManager manager = new CatalogManager();
            manager.setIgnoreMissingProperties(true);
            manager.setUseStaticCatalog(false);
            manager.setPreferPublic(true);
            File catalogFilePath = new File(ditaDir, Configuration.pluginResourceDirs.get("org.dita.base") + File.separator + "catalog-dita.xml");
            manager.setCatalogFiles(catalogFilePath.toURI().toASCIIString());
            catalogResolver = new CatalogResolver(manager);
        }
        return catalogResolver;
    }
}

