/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dita.dost.platform.Integrator;
import org.dita.dost.util.FileUtils;

public final class Configuration {
    public static final boolean DEBUG = false;
    public static final Map<String, String> configuration;
    public static final List<String> printTranstype;
    public static final List<String> transtypes;
    public static final Map<String, File> pluginResourceDirs;
    public static final Map<String, String> parserMap;
    public static final Map<String, Map<String, Boolean>> parserFeatures;
    public static final Set<String> ditaFormat;

    private Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Properties properties;
        HashMap<String, String> c;
        block62: {
            Properties properties2;
            block61: {
                void var3_20;
                c = new HashMap<String, String>();
                Properties applicationProperties = new Properties();
                try {
                    Throwable throwable = null;
                    try (InputStream inputStream = Configuration.class.getClassLoader().getResourceAsStream("application.properties");){
                        if (inputStream != null) {
                            applicationProperties.load(inputStream);
                            for (Map.Entry<Object, Object> e : applicationProperties.entrySet()) {
                                c.put(e.getKey().toString(), e.getValue().toString());
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                properties2 = new Properties();
                InputStream inputStream = null;
                try {
                    ClassLoader loader = FileUtils.class.getClassLoader();
                    InputStream inputStream2 = loader.getResourceAsStream(Integrator.class.getPackage().getName() + "/" + "plugin.properties");
                    if (inputStream2 != null) {
                        properties2.load(inputStream2);
                    } else {
                        File configurationFile = new File("config", Integrator.class.getPackage().getName() + File.separator + "plugin.properties");
                        if (configurationFile.exists()) {
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(configurationFile));
                            properties2.load(bufferedInputStream);
                        }
                    }
                    if (var3_20 == null) break block61;
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    break block61;
                }
                try {
                    var3_20.close();
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
                break block61;
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {
                            System.err.println(ex.getMessage());
                        }
                    }
                }
            }
            for (Map.Entry<Object, Object> e : properties2.entrySet()) {
                c.put(e.getKey().toString(), e.getValue().toString());
            }
            properties = new Properties();
            InputStream configurationInputStream = null;
            try {
                ClassLoader loader = FileUtils.class.getClassLoader();
                configurationInputStream = loader.getResourceAsStream("configuration.properties");
                if (configurationInputStream != null) {
                    properties.load(configurationInputStream);
                    break block62;
                }
                File configurationFile = new File("config", "configuration.properties");
                if (configurationFile.exists()) {
                    configurationInputStream = new BufferedInputStream(new FileInputStream(configurationFile));
                    properties.load(configurationInputStream);
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            finally {
                if (configurationInputStream != null) {
                    try {
                        configurationInputStream.close();
                    }
                    catch (IOException ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        }
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            c.put(e.getKey().toString(), e.getValue().toString());
        }
        configuration = Collections.unmodifiableMap(c);
        ArrayList<String> types = new ArrayList<String>();
        Object printTranstypes = configuration.get("print_transtypes");
        if (printTranstypes != null) {
            if (((String)printTranstypes).trim().length() > 0) {
                for (String transtype : ((String)printTranstypes).split(";")) {
                    types.add(transtype.trim());
                }
            }
        } else {
            System.err.println("Failed to read print transtypes from configuration, using defaults.");
            types.add("pdf");
        }
        printTranstype = Collections.unmodifiableList(types);
        types = new ArrayList();
        printTranstypes = configuration.get("transtypes");
        if (printTranstypes != null) {
            if (((String)printTranstypes).trim().length() > 0) {
                for (String transtype : ((String)printTranstypes).split(";")) {
                    types.add(transtype.trim());
                }
            }
        } else {
            System.err.println("Failed to read transtypes from configuration, using empty list.");
        }
        transtypes = Collections.unmodifiableList(types);
        HashMap<String, File> ps = new HashMap<String, File>();
        for (Map.Entry entry : configuration.entrySet()) {
            String string = (String)entry.getKey();
            if (!string.startsWith("plugin.") || !string.endsWith(".dir")) continue;
            ps.put(string.substring(7, string.length() - 4), new File((String)entry.getValue()));
        }
        pluginResourceDirs = Collections.unmodifiableMap(ps);
        HashMap<String, String> m = new HashMap<String, String>();
        HashMap<String, Map> f = new HashMap<String, Map>();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("parser.") || key.indexOf(46, "parser.".length()) != -1) continue;
            String format = key.substring("parser.".length());
            String cls = entry.getValue();
            m.put(format, cls);
            String fs = configuration.get("parser." + format + ".features");
            if (fs == null) continue;
            for (String pairs : fs.split(";")) {
                String[] tokens = pairs.split("=");
                Map fm = f.getOrDefault(format, new HashMap());
                fm.put(tokens[0], Boolean.parseBoolean(tokens[1]));
                f.put(format, fm);
            }
        }
        parserMap = Collections.unmodifiableMap(m);
        parserFeatures = Collections.unmodifiableMap(f);
        HashSet<String> s = new HashSet<String>();
        Iterator<Map.Entry<String, String>> iterator = configuration.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ditaFormat = Collections.unmodifiableSet(s);
                return;
            }
            Map.Entry<String, String> entry = iterator.next();
            String string = entry.getKey();
            if (!string.startsWith("parser.") || string.indexOf(46, "parser.".length()) != -1) continue;
            s.add(string.substring("parser.".length()));
        }
    }

    public static enum Mode {
        STRICT,
        SKIP,
        LAX;

    }
}

