/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.ExportAnchorsFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DelayConrefUtils {
    private Document root = null;
    private DITAOTLogger logger;
    private Job job;

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public boolean findTopicId(File absolutePathToFile, String id) {
        if (!this.job.getStore().exists(absolutePathToFile.toURI())) {
            return false;
        }
        try {
            Document root = this.job.getStore().getImmutableDocument(absolutePathToFile.toURI());
            Element doc = root.getDocumentElement();
            LinkedList<Element> queue = new LinkedList<Element>();
            queue.offer(doc);
            while (!queue.isEmpty()) {
                Element pe = (Element)queue.poll();
                NodeList pchildrenList = pe.getChildNodes();
                for (int i = 0; i < pchildrenList.getLength(); ++i) {
                    Node node = pchildrenList.item(i);
                    if (node.getNodeType() != 1) continue;
                    queue.offer((Element)node);
                }
                String classValue = pe.getAttribute("class");
                if (classValue == null || !Constants.TOPIC_TOPIC.matches(classValue) || !pe.getAttribute("id").equals(id)) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Failed to read document: " + e.getMessage(), e);
            return false;
        }
    }

    public List<Boolean> checkExport(String href, String id, String key, File tempDir) {
        boolean keyrefExported;
        boolean idExported;
        block12: {
            File exportFile = new File(tempDir, "export.xml");
            idExported = false;
            keyrefExported = false;
            try {
                Element fileNode;
                if (this.root == null) {
                    this.root = this.job.getStore().getImmutableDocument(exportFile.toURI());
                }
                if ((fileNode = this.searchForKey(this.root.getDocumentElement(), href, "file")) == null) break block12;
                NodeList pList = fileNode.getChildNodes();
                for (int j = 0; j < pList.getLength(); ++j) {
                    Node node = pList.item(j);
                    if (1 == node.getNodeType()) {
                        Element child = (Element)node;
                        if (child.getNodeName().equals("keyref") && child.getAttribute("name").equals(key)) {
                            keyrefExported = true;
                        } else if (child.getNodeName().equals("topicid") && child.getAttribute("name").equals(id)) {
                            idExported = true;
                        } else if (child.getNodeName().equals("id") && child.getAttribute("name").equals(id)) {
                            idExported = true;
                        }
                    }
                    if (!idExported || !keyrefExported) {
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        list.add(idExported);
        list.add(keyrefExported);
        return list;
    }

    private Element searchForKey(Element root, String key, String tagName) {
        if (root == null || StringUtils.isEmptyString(key)) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Element pe = (Element)queue.poll();
            NodeList pchildrenList = pe.getChildNodes();
            for (int i = 0; i < pchildrenList.getLength(); ++i) {
                Node node = pchildrenList.item(i);
                if (node.getNodeType() != 1) continue;
                queue.offer((Element)node);
            }
            String value = pe.getNodeName();
            if (StringUtils.isEmptyString(value) || !value.equals(tagName) || StringUtils.isEmptyString(value = pe.getAttribute("name")) || !value.equals(key)) continue;
            return pe;
        }
        return null;
    }

    public void writeMapToXML(Map<String, Set<String>> m) {
        File outputFile = new File(this.job.tempDir, "pluginId.xml");
        if (m == null) {
            return;
        }
        Properties prop = new Properties();
        for (Map.Entry<String, Set<String>> entry : m.entrySet()) {
            String key = entry.getKey();
            String value = StringUtils.join(entry.getValue(), ",");
            prop.setProperty(key, value);
        }
        Document doc = XMLUtils.getDocumentBuilder().newDocument();
        Element properties = (Element)doc.appendChild(doc.createElement("properties"));
        Set<Object> keys = prop.keySet();
        for (Object e : keys) {
            String key = (String)e;
            Element entry = (Element)properties.appendChild(doc.createElement("entry"));
            entry.setAttribute("key", key);
            entry.appendChild(doc.createTextNode(prop.getProperty(key)));
        }
        try {
            this.job.getStore().writeDocument(doc, outputFile.toURI());
        }
        catch (IOException e) {
            this.logger.error("Failed to process map: " + e.getMessage(), e);
        }
    }

    public void writeExportAnchors(ExportAnchorsFilter exportAnchorsFilter, TempFileNameScheme tempFileNameScheme) throws DITAOTException {
        XMLStreamWriter export = null;
        try (BufferedOutputStream exportStream = new BufferedOutputStream(this.job.getStore().getOutputStream(new File(this.job.tempDir, "export.xml").toURI()));){
            export = XMLOutputFactory.newInstance().createXMLStreamWriter(exportStream, "UTF-8");
            export.writeStartDocument();
            export.writeStartElement("stub");
            for (ExportAnchorsFilter.ExportAnchor e : exportAnchorsFilter.getExportAnchors()) {
                export.writeStartElement("file");
                export.writeAttribute("name", tempFileNameScheme.generateTempFileName(URLUtils.toFile(e.file).toURI()).toString());
                for (String t : this.sort(e.topicids)) {
                    export.writeStartElement("topicid");
                    export.writeAttribute("name", t);
                    export.writeEndElement();
                }
                for (String i : this.sort(e.ids)) {
                    export.writeStartElement("id");
                    export.writeAttribute("name", i);
                    export.writeEndElement();
                }
                for (String k : this.sort(e.keys)) {
                    export.writeStartElement("keyref");
                    export.writeAttribute("name", k);
                    export.writeEndElement();
                }
                export.writeEndElement();
            }
            export.writeEndElement();
            export.writeEndDocument();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to write export anchor file: " + e.getMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new DITAOTException("Failed to serialize export anchor file: " + e.getMessage(), e);
        }
        finally {
            if (export != null) {
                try {
                    export.close();
                }
                catch (XMLStreamException e) {
                    this.logger.error("Failed to close export anchor file: " + e.getMessage(), e);
                }
            }
        }
    }

    private List<String> sort(Set<String> set) {
        ArrayList<String> sorted = new ArrayList<String>(set);
        Collections.sort(sorted);
        return sorted;
    }
}

