/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.URLUtils;

public final class FileUtils {
    @Deprecated
    public static final List<String> supportedImageExtensions;
    @Deprecated
    private static final List<String> supportedHTMLExtensions;
    @Deprecated
    private static final List<String> supportedResourceExtensions;

    private FileUtils() {
    }

    @Deprecated
    public static boolean isHTMLFile(String lcasefn) {
        for (String ext : supportedHTMLExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHHPFile(String lcasefn) {
        return lcasefn.endsWith(".hhp");
    }

    public static boolean isHHCFile(String lcasefn) {
        return lcasefn.endsWith(".hhc");
    }

    public static boolean isHHKFile(String lcasefn) {
        return lcasefn.endsWith(".hhk");
    }

    @Deprecated
    public static boolean isResourceFile(String lcasefn) {
        for (String ext : supportedResourceExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isSupportedImageFile(String lcasefn) {
        for (String ext : supportedImageExtensions) {
            if (!lcasefn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static File getRelativePath(File basePath, File refPath) {
        if (basePath.toPath().getRoot() == null || !basePath.toPath().getRoot().equals(refPath.toPath().getRoot())) {
            return refPath;
        }
        return basePath.toPath().getParent().relativize(refPath.toPath()).toFile();
    }

    @Deprecated
    public static String getRelativeUnixPath(String basePath, String refPath) {
        return FileUtils.getRelativePath(basePath, refPath, "/");
    }

    private static String getRelativePath(String basePath, String refPath, String sep) {
        StringBuilder upPathBuffer = new StringBuilder(128);
        StringBuilder downPathBuffer = new StringBuilder(128);
        StringTokenizer mapTokenizer = new StringTokenizer(FileUtils.normalizePath(basePath, File.separator), File.separator);
        StringTokenizer topicTokenizer = new StringTokenizer(FileUtils.normalizePath(refPath, File.separator), File.separator);
        while (mapTokenizer.countTokens() > 1 && topicTokenizer.countTokens() > 1) {
            String mapToken = mapTokenizer.nextToken();
            String topicToken = topicTokenizer.nextToken();
            boolean equals = Constants.OS_NAME.toLowerCase().contains("windows") ? mapToken.equalsIgnoreCase(topicToken) : mapToken.equals(topicToken);
            if (equals) continue;
            if (mapToken.endsWith(":") || topicToken.endsWith(":")) {
                return refPath;
            }
            upPathBuffer.append("..");
            upPathBuffer.append(sep);
            downPathBuffer.append(topicToken);
            downPathBuffer.append(sep);
            break;
        }
        while (mapTokenizer.countTokens() > 1) {
            mapTokenizer.nextToken();
            upPathBuffer.append("..");
            upPathBuffer.append(sep);
        }
        while (topicTokenizer.hasMoreTokens()) {
            downPathBuffer.append(topicTokenizer.nextToken());
            if (!topicTokenizer.hasMoreTokens()) continue;
            downPathBuffer.append(sep);
        }
        return upPathBuffer.append((CharSequence)downPathBuffer).toString();
    }

    @Deprecated
    public static String getRelativeUnixPath(String relativePath) {
        return FileUtils.getRelativePathForPath(relativePath, "/");
    }

    public static File getRelativePath(File relativePath) {
        String p = FileUtils.getRelativePathForPath(relativePath.getPath(), File.separator);
        return p != null ? new File(p) : null;
    }

    private static String getRelativePathForPath(String relativePath, String sep) {
        StringTokenizer tokenizer = new StringTokenizer(relativePath.replace("\\", "/"), "/");
        StringBuilder buffer = new StringBuilder();
        if (tokenizer.countTokens() == 1) {
            return null;
        }
        while (tokenizer.countTokens() > 1) {
            tokenizer.nextToken();
            buffer.append("..");
            buffer.append(sep);
        }
        return buffer.toString();
    }

    @Deprecated
    public static String resolveTopic(File rootPath, String relativePath) {
        return FileUtils.setFragment(FileUtils.resolve(rootPath, FileUtils.stripFragment(relativePath)).getPath(), FileUtils.getFragment(relativePath));
    }

    @Deprecated
    public static String resolveTopic(String rootPath, String relativePath) {
        return FileUtils.setFragment(FileUtils.resolve(rootPath, FileUtils.stripFragment(relativePath)).getPath(), FileUtils.getFragment(relativePath));
    }

    @Deprecated
    public static URI resolve(File rootPath, URI relativePath) {
        return URLUtils.toURI(FileUtils.resolve(rootPath != null ? rootPath.getPath() : null, relativePath.getPath()));
    }

    @Deprecated
    public static File resolve(String basedir, String filepath) {
        File pathname = new File(FileUtils.normalizePath(FileUtils.stripFragment(filepath), File.separator));
        if (basedir == null || basedir.length() == 0) {
            return pathname;
        }
        String normilizedPath = new File(basedir, pathname.getPath()).getPath();
        return new File(FileUtils.normalizePath(normilizedPath, File.separator));
    }

    @Deprecated
    public static File resolve(File basedir, String filepath) {
        return FileUtils.resolve(basedir != null ? basedir.getPath() : null, filepath);
    }

    public static File resolve(File basedir, File filepath) {
        return FileUtils.resolve(basedir != null ? basedir.getPath() : null, filepath.getPath());
    }

    private static String normalizePath(String path, String separator) {
        String p = path.replace("\\", separator).replace("/", separator);
        LinkedList<String> dirs = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(p, separator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (".".equals(token)) continue;
            dirs.add(token);
        }
        int dirNum = dirs.size();
        int i = 0;
        while (i < dirNum) {
            if (i > 0) {
                String lastDir = (String)dirs.get(i - 1);
                String dir = (String)dirs.get(i);
                if ("..".equals(dir) && !"..".equals(lastDir)) {
                    dirs.remove(i);
                    dirs.remove(i - 1);
                    dirNum = dirs.size();
                    --i;
                    continue;
                }
            }
            ++i;
        }
        StringBuilder buff = new StringBuilder(p.length());
        if (p.startsWith(separator + separator)) {
            buff.append(separator).append(separator);
        } else if (p.startsWith(separator)) {
            buff.append(separator);
        }
        Iterator iter = dirs.iterator();
        while (iter.hasNext()) {
            buff.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buff.append(separator);
        }
        if (p.endsWith(separator)) {
            buff.append(separator);
        }
        return buff.toString();
    }

    public static boolean isAbsolutePath(String path) {
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        if (File.separator.equals("/")) {
            return path.startsWith("/");
        }
        if (File.separator.equals("\\") && path.length() > 2) {
            return path.matches("([a-zA-Z]:|\\\\)\\\\.*");
        }
        return false;
    }

    public static String replaceExtension(String attValue, String extName) {
        int index = attValue.indexOf("#");
        if (attValue.startsWith("#")) {
            return attValue;
        }
        if (index != -1) {
            String fileName = attValue.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(0, fileExtIndex) + extName + attValue.substring(index) : attValue;
        }
        int fileExtIndex = attValue.lastIndexOf(".");
        return fileExtIndex != -1 ? attValue.substring(0, fileExtIndex) + extName : attValue;
    }

    public static String getExtension(String file) {
        int index = file.indexOf("#");
        if (file.startsWith("#")) {
            return null;
        }
        if (index != -1) {
            String fileName = file.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(fileExtIndex + 1) : null;
        }
        int fileExtIndex = file.lastIndexOf(".");
        return fileExtIndex != -1 ? file.substring(fileExtIndex + 1) : null;
    }

    public static String getName(String aURLString) {
        int pathnameEndIndex;
        if (FileUtils.isWindows()) {
            if (aURLString.contains("#")) {
                pathnameEndIndex = aURLString.lastIndexOf("#");
            } else {
                pathnameEndIndex = aURLString.lastIndexOf("\\");
                if (pathnameEndIndex == -1) {
                    pathnameEndIndex = aURLString.lastIndexOf("/");
                }
            }
        } else {
            if (aURLString.contains("#")) {
                pathnameEndIndex = aURLString.lastIndexOf("#");
            }
            pathnameEndIndex = aURLString.lastIndexOf("/");
        }
        String schemaLocation = aURLString.contains("#") ? aURLString.substring(0, pathnameEndIndex) : aURLString.substring(pathnameEndIndex + 1);
        return schemaLocation;
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Win");
    }

    public static String getFullPathNoEndSeparator(String aURLString) {
        int pathnameStartIndex = aURLString.indexOf("/");
        int pathnameEndIndex = aURLString.lastIndexOf("/");
        String aPath = aURLString.substring(0, pathnameEndIndex);
        return aPath;
    }

    @Deprecated
    public static String stripFragment(String path) {
        int i = path.indexOf("#");
        if (i != -1) {
            return path.substring(0, i);
        }
        return path;
    }

    @Deprecated
    public static String setFragment(String path, String fragment) {
        int i = path.indexOf("#");
        String p = i != -1 ? path.substring(0, i) : path;
        return p + (fragment != null ? "#" + fragment : "");
    }

    @Deprecated
    public static String getFragment(String path) {
        return FileUtils.getFragment(path, null);
    }

    @Deprecated
    public static String getFragment(String path, String defaultValue) {
        int i = path.indexOf("#");
        if (i != -1) {
            return path.substring(i + 1);
        }
        return defaultValue;
    }

    public static boolean directoryContains(File directory, File child) {
        File c;
        File d = new File(FilenameUtils.normalize((String)directory.getAbsolutePath()));
        if (d.equals(c = new File(FilenameUtils.normalize((String)child.getAbsolutePath())))) {
            return false;
        }
        return c.getPath().startsWith(d.getPath());
    }

    static {
        ArrayList<String> sie = new ArrayList<String>();
        String imageExtensions = Configuration.configuration.get("supported_image_extensions");
        if (imageExtensions != null && imageExtensions.length() > 0) {
            Collections.addAll(sie, imageExtensions.split(";"));
        } else {
            System.err.println("Failed to read supported image extensions from configuration, using defaults.");
            sie.add(".jpg");
            sie.add(".gif");
            sie.add(".eps");
            sie.add(".jpeg");
            sie.add(".png");
            sie.add(".svg");
            sie.add(".tiff");
            sie.add(".tif");
        }
        supportedImageExtensions = Collections.unmodifiableList(sie);
        ArrayList<String> she = new ArrayList<String>();
        String extensions = Configuration.configuration.get("supported_html_extensions");
        if (extensions != null && extensions.length() > 0) {
            Collections.addAll(she, extensions.split(";"));
        } else {
            System.err.println("Failed to read supported HTML extensions from configuration, using defaults.");
            she.add(".html");
            she.add(".htm");
        }
        supportedHTMLExtensions = Collections.unmodifiableList(she);
        ArrayList<String> sre = new ArrayList<String>();
        extensions = Configuration.configuration.get("supported_resource_extensions");
        if (extensions != null && extensions.length() > 0) {
            Collections.addAll(sre, extensions.split(";"));
        } else {
            System.err.println("Failed to read supported resource file extensions from configuration, using defaults.");
            sre.add(".swf");
            sre.add(".pdf");
        }
        supportedResourceExtensions = Collections.unmodifiableList(sre);
    }
}

