/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.store.Store;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.URLUtils;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Job {
    private static final String JOB_FILE = ".job.xml";
    private static final String ELEMENT_JOB = "job";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ELEMENT_MAP = "map";
    private static final String ELEMENT_SET = "set";
    private static final String ELEMENT_STRING = "string";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_FILES = "files";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTRIBUTE_SRC = "src";
    private static final String ATTRIBUTE_URI = "uri";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_RESULT = "result";
    private static final String ATTRIBUTE_FORMAT = "format";
    private static final String ATTRIBUTE_CHUNKED = "chunked";
    private static final String ATTRIBUTE_HAS_CONREF = "has-conref";
    private static final String ATTRIBUTE_HAS_KEYREF = "has-keyref";
    private static final String ATTRIBUTE_HAS_CODEREF = "has-coderef";
    private static final String ATTRIBUTE_RESOURCE_ONLY = "resource-only";
    private static final String ATTRIBUTE_TARGET = "target";
    private static final String ATTRIBUTE_CONREF_TARGET = "conref-target";
    private static final String ATTRIBUTE_CONREF_PUSH = "conrefpush";
    private static final String ATTRIBUTE_SUBJECT_SCHEME = "subjectscheme";
    private static final String ATTRIBUTE_HAS_LINK = "has-link";
    private static final String ATTRIBUTE_INPUT = "input";
    private static final String ATTRIBUTE_COPYTO_SOURCE_LIST = "copy-to-source";
    private static final String ATTRIBUTE_OUT_DITA_FILES_LIST = "out-dita";
    private static final String ATTRIBUTE_CHUNKED_DITAMAP_LIST = "chunked-ditamap";
    private static final String ATTRIBUTE_FLAG_IMAGE_LIST = "flag-image";
    private static final String ATTRIBUTE_SUBSIDIARY_TARGET_LIST = "subtarget";
    private static final String PROPERTY_OUTER_CONTROL = "outercontrol";
    private static final String PROPERTY_ONLY_TOPIC_IN_MAP = "onlytopicinmap";
    private static final String PROPERTY_LINK_CRAWLER = "crawl";
    private static final String PROPERTY_GENERATE_COPY_OUTER = "generatecopyouter";
    private static final String PROPERTY_OUTPUT_DIR = "outputdir";
    @Deprecated
    private static final String PROPERTY_INPUT_MAP = "InputMapDir";
    private static final String PROPERTY_INPUT_MAP_URI = "InputMapDir.uri";
    public static final String USER_INPUT_FILE_LIST_FILE = "usr.input.file.list";
    private static final Map<String, Field> attrToFieldMap = new HashMap<String, Field>();
    private final Map<String, Object> prop;
    public final File tempDir;
    public final URI tempDirURI;
    private final File jobFile;
    private final Map<URI, FileInfo> files = new ConcurrentHashMap<URI, FileInfo>();
    private long lastModified;
    private final Store store;

    public Job(File tempDir, Store store) throws IOException {
        if (!tempDir.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory " + tempDir + " must be absolute");
        }
        this.tempDir = tempDir;
        this.store = store;
        URI tmpDirUri = tempDir.toURI();
        this.tempDirURI = tmpDirUri.toString().endsWith("/") ? tmpDirUri : URI.create(tmpDirUri + "/");
        this.jobFile = new File(tempDir, JOB_FILE);
        this.prop = new HashMap<String, Object>();
        this.read();
        for (Map.Entry<String, String> e : Configuration.configuration.entrySet()) {
            if (this.prop.containsKey(e.getKey())) continue;
            this.prop.put(e.getKey(), e.getValue());
        }
    }

    public Job(Job job, Map<String, Object> prop, Collection<FileInfo> files) {
        this.tempDir = job.tempDir;
        this.store = job.store;
        this.tempDirURI = this.tempDir.toURI();
        this.jobFile = new File(this.tempDir, JOB_FILE);
        this.prop = prop;
        this.files.putAll(files.stream().collect(Collectors.toMap(fi -> fi.uri, Function.identity())));
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isStale() {
        return this.getStore().getLastModified(this.jobFile.toURI()) > this.lastModified;
    }

    private void read() throws IOException {
        block15: {
            this.lastModified = this.getStore().getLastModified(this.jobFile.toURI());
            if (this.getStore().exists(this.jobFile.toURI())) {
                try (FileInputStream in = new FileInputStream(this.jobFile);){
                    this.getStore().transform(this.jobFile.toURI(), new JobHandler(this.prop, this.files));
                    break block15;
                }
                catch (DITAOTException e) {
                    throw new IOException("Failed to read job file: " + e.getMessage());
                }
            }
            this.prop.put(PROPERTY_GENERATE_COPY_OUTER, Generate.NOT_GENERATEOUTTER.toString());
            this.prop.put(PROPERTY_ONLY_TOPIC_IN_MAP, Boolean.toString(false));
            this.prop.put(PROPERTY_OUTER_CONTROL, OutterControl.WARN.toString());
        }
    }

    public void write() throws IOException {
        try (BufferedWriter outStream = new BufferedWriter(new OutputStreamWriter(this.getStore().getOutputStream(this.jobFile.toURI()), StandardCharsets.UTF_8));){
            XMLStreamWriter out = null;
            try {
                out = XMLOutputFactory.newInstance().createXMLStreamWriter(outStream);
                this.serialize(out, this.prop, this.files.values());
            }
            catch (XMLStreamException e) {
                throw new IOException("Failed to serialize job file: " + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (XMLStreamException e) {
                        throw new IOException("Failed to close file: " + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to write file: " + e.getMessage());
        }
        this.lastModified = this.getStore().getLastModified(this.jobFile.toURI());
    }

    public Document serialize() throws IOException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            DOMResult result = new DOMResult(doc);
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(result);
            this.serialize(out, this.prop, this.files.values());
            return (Document)result.getNode();
        }
        catch (ParserConfigurationException | XMLStreamException e) {
            throw new IOException("Failed to serialize job file: " + e.getMessage());
        }
    }

    public void serialize(XMLStreamWriter out, Map<String, Object> props, Collection<FileInfo> fs) throws XMLStreamException {
        out.writeStartDocument();
        out.writeStartElement(ELEMENT_JOB);
        for (Map.Entry<String, Object> e : props.entrySet()) {
            Iterator<Map.Entry<String, Field>> s;
            out.writeStartElement(ELEMENT_PROPERTY);
            out.writeAttribute(ATTRIBUTE_NAME, e.getKey());
            if (e.getValue() instanceof String) {
                out.writeStartElement(ELEMENT_STRING);
                out.writeCharacters(e.getValue().toString());
                out.writeEndElement();
            } else if (e.getValue() instanceof Set) {
                out.writeStartElement(ELEMENT_SET);
                s = (Set)e.getValue();
                Iterator<Object> iterator = s.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    out.writeStartElement(ELEMENT_STRING);
                    out.writeCharacters(e2.toString());
                    out.writeEndElement();
                }
                out.writeEndElement();
            } else if (e.getValue() instanceof Map) {
                out.writeStartElement(ELEMENT_MAP);
                s = (Map)e.getValue();
                for (Map.Entry entry : s.entrySet()) {
                    out.writeStartElement(ELEMENT_ENTRY);
                    out.writeAttribute(ATTRIBUTE_KEY, entry.getKey().toString());
                    out.writeStartElement(ELEMENT_STRING);
                    out.writeCharacters(entry.getValue().toString());
                    out.writeEndElement();
                    out.writeEndElement();
                }
                out.writeEndElement();
            } else {
                out.writeStartElement(e.getValue().getClass().getName());
                out.writeCharacters(e.getValue().toString());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        out.writeStartElement(ELEMENT_FILES);
        for (FileInfo i : fs) {
            out.writeStartElement(ELEMENT_FILE);
            if (i.src != null) {
                out.writeAttribute(ATTRIBUTE_SRC, i.src.toString());
            }
            out.writeAttribute(ATTRIBUTE_URI, i.uri.toString());
            out.writeAttribute(ATTRIBUTE_PATH, i.file.getPath());
            if (i.result != null) {
                out.writeAttribute(ATTRIBUTE_RESULT, i.result.toString());
            }
            if (i.format != null) {
                out.writeAttribute(ATTRIBUTE_FORMAT, i.format);
            }
            try {
                for (Map.Entry<String, Field> e : attrToFieldMap.entrySet()) {
                    boolean bl = e.getValue().getBoolean(i);
                    if (!bl) continue;
                    out.writeAttribute(e.getKey(), Boolean.TRUE.toString());
                }
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            out.writeEndElement();
        }
        out.writeEndElement();
        out.writeEndElement();
        out.writeEndDocument();
    }

    public void add(FileInfo fileInfo) {
        this.files.put(fileInfo.uri, fileInfo);
    }

    public FileInfo remove(FileInfo fileInfo) {
        return this.files.remove(fileInfo.uri);
    }

    public String getProperty(String key) {
        return (String)this.prop.get(key);
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : this.prop.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            res.put(e.getKey(), (String)e.getValue());
        }
        return Collections.unmodifiableMap(res);
    }

    public Object setProperty(String key, String value) {
        return this.prop.put(key, value);
    }

    public URI getInputMap() {
        return this.files.values().stream().filter(fi -> fi.isInput).map(fi -> this.getInputDir().relativize(fi.src)).findAny().orElse(null);
    }

    public void setInputMap(URI map) {
        assert (!map.isAbsolute());
        this.setProperty("user.input.file.uri", map.toString());
        this.setProperty("user.input.file", URLUtils.toFile(map).getPath());
    }

    public URI getInputDir() {
        return URLUtils.toURI(this.getProperty("user.input.dir.uri"));
    }

    public void setInputDir(URI dir) {
        assert (dir.isAbsolute());
        this.setProperty("user.input.dir.uri", dir.toString());
        if (dir.getScheme().equals(ELEMENT_FILE)) {
            this.setProperty("user.input.dir", new File(dir).getAbsolutePath());
        }
    }

    public Map<File, FileInfo> getFileInfoMap() {
        HashMap<File, FileInfo> ret = new HashMap<File, FileInfo>();
        for (Map.Entry<URI, FileInfo> e : this.files.entrySet()) {
            ret.put(e.getValue().file, e.getValue());
        }
        return Collections.unmodifiableMap(ret);
    }

    public Collection<FileInfo> getFileInfo() {
        return Collections.unmodifiableCollection(new ArrayList<FileInfo>(this.files.values()));
    }

    public Collection<FileInfo> getFileInfo(Predicate<FileInfo> filter) {
        return this.files.values().stream().filter(filter).collect(Collectors.toList());
    }

    public FileInfo getFileInfo(URI file) {
        if (file == null) {
            return null;
        }
        if (this.files.containsKey(file)) {
            return this.files.get(file);
        }
        if (file.isAbsolute() && file.toString().startsWith(this.tempDirURI.toString())) {
            URI relative = URLUtils.getRelativePath(this.jobFile.toURI(), file);
            return this.files.get(relative);
        }
        return this.files.values().stream().filter(fileInfo -> file.equals(fileInfo.src) || file.equals(fileInfo.result)).findFirst().orElse(null);
    }

    public FileInfo getOrCreateFileInfo(URI file) {
        FileInfo i;
        assert (file.getFragment() == null);
        URI f = file.normalize();
        if (f.isAbsolute()) {
            f = this.tempDirURI.relativize(f);
        }
        if ((i = this.getFileInfo(file)) == null) {
            i = new FileInfo(f);
            this.add(i);
        }
        return i;
    }

    public void addAll(Collection<FileInfo> fs) {
        for (FileInfo f : fs) {
            this.add(f);
        }
    }

    public OutterControl getOutterControl() {
        return OutterControl.valueOf(this.prop.get(PROPERTY_OUTER_CONTROL).toString());
    }

    public void setOutterControl(String control) {
        this.prop.put(PROPERTY_OUTER_CONTROL, OutterControl.valueOf(control.toUpperCase()).toString());
    }

    public boolean getOnlyTopicInMap() {
        return Boolean.parseBoolean(this.prop.get(PROPERTY_ONLY_TOPIC_IN_MAP).toString());
    }

    public boolean crawlTopics() {
        if (this.prop.get(PROPERTY_LINK_CRAWLER) == null) {
            return true;
        }
        return this.prop.get(PROPERTY_LINK_CRAWLER).toString().equals("topic");
    }

    public void setOnlyTopicInMap(boolean flag) {
        this.prop.put(PROPERTY_ONLY_TOPIC_IN_MAP, Boolean.toString(flag));
    }

    public void setCrawl(String crawlvalue) {
        if (crawlvalue != null) {
            this.prop.put(PROPERTY_LINK_CRAWLER, crawlvalue);
        }
    }

    public Generate getGeneratecopyouter() {
        return Generate.valueOf(this.prop.get(PROPERTY_GENERATE_COPY_OUTER).toString());
    }

    public void setGeneratecopyouter(String flag) {
        this.setGeneratecopyouter(Generate.get(Integer.parseInt(flag)));
    }

    public void setGeneratecopyouter(Generate flag) {
        this.prop.put(PROPERTY_GENERATE_COPY_OUTER, flag.toString());
    }

    public File getOutputDir() {
        if (this.prop.containsKey(PROPERTY_OUTPUT_DIR)) {
            return new File(this.prop.get(PROPERTY_OUTPUT_DIR).toString());
        }
        return null;
    }

    public void setOutputDir(File outputDir) {
        this.prop.put(PROPERTY_OUTPUT_DIR, outputDir.getAbsolutePath());
    }

    public URI getInputFile() {
        return this.files.values().stream().filter(fi -> fi.isInput).map(fi -> fi.src).findAny().orElseGet(() -> Optional.ofNullable((String)this.prop.get(PROPERTY_INPUT_MAP_URI)).map(URLUtils::toURI).orElse(null));
    }

    public void setInputFile(URI inputFile) {
        assert (inputFile.isAbsolute());
        this.prop.put(PROPERTY_INPUT_MAP_URI, inputFile.toString());
        if (inputFile.getScheme().equals(ELEMENT_FILE)) {
            this.prop.put(PROPERTY_INPUT_MAP, new File(inputFile).getAbsolutePath());
        }
    }

    public TempFileNameScheme getTempFileNameScheme() {
        TempFileNameScheme tempFileNameScheme;
        try {
            String cls = Optional.ofNullable(this.getProperty("temp-file-name-scheme")).orElse(Configuration.configuration.get("temp-file-name-scheme"));
            tempFileNameScheme = (TempFileNameScheme)Class.forName(cls).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        tempFileNameScheme.setBaseDir(this.getInputDir());
        return tempFileNameScheme;
    }

    static {
        try {
            attrToFieldMap.put(ATTRIBUTE_CHUNKED, FileInfo.class.getField("isChunked"));
            attrToFieldMap.put(ATTRIBUTE_HAS_LINK, FileInfo.class.getField("hasLink"));
            attrToFieldMap.put(ATTRIBUTE_INPUT, FileInfo.class.getField("isInput"));
            attrToFieldMap.put(ATTRIBUTE_HAS_CONREF, FileInfo.class.getField("hasConref"));
            attrToFieldMap.put(ATTRIBUTE_HAS_KEYREF, FileInfo.class.getField("hasKeyref"));
            attrToFieldMap.put(ATTRIBUTE_HAS_CODEREF, FileInfo.class.getField("hasCoderef"));
            attrToFieldMap.put(ATTRIBUTE_RESOURCE_ONLY, FileInfo.class.getField("isResourceOnly"));
            attrToFieldMap.put(ATTRIBUTE_TARGET, FileInfo.class.getField("isTarget"));
            attrToFieldMap.put(ATTRIBUTE_CONREF_PUSH, FileInfo.class.getField("isConrefPush"));
            attrToFieldMap.put(ATTRIBUTE_SUBJECT_SCHEME, FileInfo.class.getField("isSubjectScheme"));
            attrToFieldMap.put(ATTRIBUTE_OUT_DITA_FILES_LIST, FileInfo.class.getField("isOutDita"));
            attrToFieldMap.put(ATTRIBUTE_FLAG_IMAGE_LIST, FileInfo.class.getField("isFlagImage"));
            attrToFieldMap.put(ATTRIBUTE_SUBSIDIARY_TARGET_LIST, FileInfo.class.getField("isSubtarget"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Generate {
        NOT_GENERATEOUTTER(1),
        OLDSOLUTION(3);

        public final int type;

        private Generate(int type) {
            this.type = type;
        }

        public static Generate get(int type) {
            for (Generate g : Generate.values()) {
                if (g.type != type) continue;
                return g;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum OutterControl {
        FAIL,
        WARN,
        QUIET;

    }

    public static final class FileInfo {
        public URI src;
        public final URI uri;
        public final File file;
        public URI result;
        public String format;
        public boolean hasConref;
        public boolean isChunked;
        public boolean hasLink;
        public boolean isResourceOnly;
        public boolean isTarget;
        public boolean isConrefPush;
        public boolean hasKeyref;
        public boolean hasCoderef;
        public boolean isSubjectScheme;
        public boolean isSubtarget;
        public boolean isFlagImage;
        public boolean isOutDita;
        public boolean isInput;
        public boolean isInputResource;

        FileInfo(URI src, URI uri, File file) {
            if (uri == null && file == null) {
                throw new IllegalArgumentException(new NullPointerException());
            }
            this.src = src;
            this.uri = uri != null ? uri : URLUtils.toURI(file);
            this.file = uri != null ? URLUtils.toFile(uri) : file;
            this.result = src;
        }

        FileInfo(URI uri) {
            if (uri == null) {
                throw new IllegalArgumentException(new NullPointerException());
            }
            this.src = null;
            this.uri = uri;
            this.file = URLUtils.toFile(uri);
            this.result = this.src;
        }

        public String toString() {
            return "FileInfo{src=" + this.src + ", result=" + this.result + ", uri=" + this.uri + ", file=" + this.file + ", format='" + this.format + '\'' + ", hasConref=" + this.hasConref + ", isChunked=" + this.isChunked + ", hasLink=" + this.hasLink + ", isResourceOnly=" + this.isResourceOnly + ", isTarget=" + this.isTarget + ", isConrefPush=" + this.isConrefPush + ", isInput=" + this.isInput + ", isInputResource=" + this.isInputResource + ", hasKeyref=" + this.hasKeyref + ", hasCoderef=" + this.hasCoderef + ", isSubjectScheme=" + this.isSubjectScheme + ", isSubtarget=" + this.isSubtarget + ", isFlagImage=" + this.isFlagImage + ", isOutDita=" + this.isOutDita + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            return this.hasConref == fileInfo.hasConref && this.isChunked == fileInfo.isChunked && this.hasLink == fileInfo.hasLink && this.isResourceOnly == fileInfo.isResourceOnly && this.isTarget == fileInfo.isTarget && this.isConrefPush == fileInfo.isConrefPush && this.hasKeyref == fileInfo.hasKeyref && this.hasCoderef == fileInfo.hasCoderef && this.isSubjectScheme == fileInfo.isSubjectScheme && this.isSubtarget == fileInfo.isSubtarget && this.isFlagImage == fileInfo.isFlagImage && this.isOutDita == fileInfo.isOutDita && this.isInput == fileInfo.isInput && this.isInputResource == fileInfo.isInputResource && Objects.equals(this.src, fileInfo.src) && Objects.equals(this.uri, fileInfo.uri) && Objects.equals(this.file, fileInfo.file) && Objects.equals(this.result, fileInfo.result) && Objects.equals(this.format, fileInfo.format);
        }

        public int hashCode() {
            return Objects.hash(this.src, this.uri, this.file, this.result, this.format, this.hasConref, this.isChunked, this.hasLink, this.isResourceOnly, this.isTarget, this.isConrefPush, this.hasKeyref, this.hasCoderef, this.isSubjectScheme, this.isSubtarget, this.isFlagImage, this.isOutDita, this.isInput, this.isInputResource);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(FileInfo fileInfo) {
            return new Builder(fileInfo);
        }

        public static class Builder {
            private URI src;
            private URI uri;
            private File file;
            private URI result;
            private String format;
            private boolean hasConref;
            private boolean isChunked;
            private boolean hasLink;
            private boolean isResourceOnly;
            private boolean isTarget;
            private boolean isConrefPush;
            private boolean hasKeyref;
            private boolean hasCoderef;
            private boolean isSubjectScheme;
            private boolean isSubtarget;
            private boolean isFlagImage;
            private boolean isOutDita;
            private boolean isInput;
            private boolean isInputResource;

            public Builder() {
            }

            public Builder(FileInfo orig) {
                this.src = orig.src;
                this.uri = orig.uri;
                this.file = orig.file;
                this.result = orig.result;
                this.format = orig.format;
                this.hasConref = orig.hasConref;
                this.isChunked = orig.isChunked;
                this.hasLink = orig.hasLink;
                this.isResourceOnly = orig.isResourceOnly;
                this.isTarget = orig.isTarget;
                this.isConrefPush = orig.isConrefPush;
                this.hasKeyref = orig.hasKeyref;
                this.hasCoderef = orig.hasCoderef;
                this.isSubjectScheme = orig.isSubjectScheme;
                this.isSubtarget = orig.isSubtarget;
                this.isFlagImage = orig.isFlagImage;
                this.isOutDita = orig.isOutDita;
                this.isInput = orig.isInput;
                this.isInputResource = orig.isInputResource;
            }

            public Builder add(FileInfo orig) {
                if (orig.src != null) {
                    this.src = orig.src;
                }
                if (orig.uri != null) {
                    this.uri = orig.uri;
                }
                if (orig.file != null) {
                    this.file = orig.file;
                }
                if (orig.result != null) {
                    this.result = orig.result;
                }
                if (orig.format != null) {
                    this.format = orig.format;
                }
                if (orig.hasConref) {
                    this.hasConref = orig.hasConref;
                }
                if (orig.isChunked) {
                    this.isChunked = orig.isChunked;
                }
                if (orig.hasLink) {
                    this.hasLink = orig.hasLink;
                }
                if (orig.isResourceOnly) {
                    this.isResourceOnly = orig.isResourceOnly;
                }
                if (orig.isTarget) {
                    this.isTarget = orig.isTarget;
                }
                if (orig.isConrefPush) {
                    this.isConrefPush = orig.isConrefPush;
                }
                if (orig.hasKeyref) {
                    this.hasKeyref = orig.hasKeyref;
                }
                if (orig.hasCoderef) {
                    this.hasCoderef = orig.hasCoderef;
                }
                if (orig.isSubjectScheme) {
                    this.isSubjectScheme = orig.isSubjectScheme;
                }
                if (orig.isSubtarget) {
                    this.isSubtarget = orig.isSubtarget;
                }
                if (orig.isFlagImage) {
                    this.isFlagImage = orig.isFlagImage;
                }
                if (orig.isOutDita) {
                    this.isOutDita = orig.isOutDita;
                }
                if (orig.isInput) {
                    this.isInput = orig.isInput;
                }
                if (orig.isInputResource) {
                    this.isInputResource = orig.isInputResource;
                }
                return this;
            }

            public Builder addContentFields(FileInfo orig) {
                if (orig.format != null) {
                    this.format = orig.format;
                }
                if (orig.hasConref) {
                    this.hasConref = orig.hasConref;
                }
                if (orig.isChunked) {
                    this.isChunked = orig.isChunked;
                }
                if (orig.hasLink) {
                    this.hasLink = orig.hasLink;
                }
                if (orig.isConrefPush) {
                    this.isConrefPush = orig.isConrefPush;
                }
                if (orig.hasKeyref) {
                    this.hasKeyref = orig.hasKeyref;
                }
                if (orig.hasCoderef) {
                    this.hasCoderef = orig.hasCoderef;
                }
                return this;
            }

            public Builder src(URI src) {
                assert (src.isAbsolute());
                this.src = src;
                return this;
            }

            public Builder uri(URI uri) {
                this.uri = uri;
                this.file = null;
                return this;
            }

            public Builder file(File file) {
                this.file = file;
                this.uri = null;
                return this;
            }

            public Builder result(URI result) {
                this.result = result;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder hasConref(boolean hasConref) {
                this.hasConref = hasConref;
                return this;
            }

            public Builder isChunked(boolean isChunked) {
                this.isChunked = isChunked;
                return this;
            }

            public Builder hasLink(boolean hasLink) {
                this.hasLink = hasLink;
                return this;
            }

            public Builder isResourceOnly(boolean isResourceOnly) {
                this.isResourceOnly = isResourceOnly;
                return this;
            }

            public Builder isTarget(boolean isTarget) {
                this.isTarget = isTarget;
                return this;
            }

            public Builder isConrefPush(boolean isConrefPush) {
                this.isConrefPush = isConrefPush;
                return this;
            }

            public Builder hasKeyref(boolean hasKeyref) {
                this.hasKeyref = hasKeyref;
                return this;
            }

            public Builder hasCoderef(boolean hasCoderef) {
                this.hasCoderef = hasCoderef;
                return this;
            }

            public Builder isSubjectScheme(boolean isSubjectScheme) {
                this.isSubjectScheme = isSubjectScheme;
                return this;
            }

            public Builder isSubtarget(boolean isSubtarget) {
                this.isSubtarget = isSubtarget;
                return this;
            }

            public Builder isFlagImage(boolean isFlagImage) {
                this.isFlagImage = isFlagImage;
                return this;
            }

            public Builder isOutDita(boolean isOutDita) {
                this.isOutDita = isOutDita;
                return this;
            }

            public Builder isInput(boolean isInput) {
                this.isInput = isInput;
                return this;
            }

            public Builder isInputResource(boolean isInputResource) {
                this.isInputResource = isInputResource;
                return this;
            }

            public FileInfo build() {
                if (this.uri == null && this.file == null) {
                    throw new IllegalStateException("uri and file may not be null");
                }
                FileInfo fi = new FileInfo(this.src, this.uri, this.file);
                if (this.result != null) {
                    fi.result = this.result;
                }
                fi.format = this.format;
                fi.hasConref = this.hasConref;
                fi.isChunked = this.isChunked;
                fi.hasLink = this.hasLink;
                fi.isResourceOnly = this.isResourceOnly;
                fi.isTarget = this.isTarget;
                fi.isConrefPush = this.isConrefPush;
                fi.hasKeyref = this.hasKeyref;
                fi.hasCoderef = this.hasCoderef;
                fi.isSubjectScheme = this.isSubjectScheme;
                fi.isSubtarget = this.isSubtarget;
                fi.isFlagImage = this.isFlagImage;
                fi.isOutDita = this.isOutDita;
                fi.isInput = this.isInput;
                fi.isInputResource = this.isInputResource;
                return fi;
            }
        }
    }

    public static final class JobHandler
    extends DefaultHandler {
        private final Map<String, Object> prop;
        private final Map<URI, FileInfo> files;
        private StringBuilder buf;
        private String name;
        private String key;
        private Set<String> set;
        private Map<String, String> map;

        public JobHandler(Map<String, Object> prop, Map<URI, FileInfo> files) {
            this.prop = prop;
            this.files = files;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(ch, start, length);
            }
        }

        @Override
        public void startElement(String ns, String localName, String qName, Attributes atts) throws SAXException {
            String n;
            switch (n = localName != null ? localName : qName) {
                case "property": {
                    this.name = atts.getValue(Job.ATTRIBUTE_NAME);
                    break;
                }
                case "string": {
                    this.buf = new StringBuilder();
                    break;
                }
                case "set": {
                    this.set = new HashSet<String>();
                    break;
                }
                case "map": {
                    this.map = new HashMap<String, String>();
                    break;
                }
                case "entry": {
                    this.key = atts.getValue(Job.ATTRIBUTE_KEY);
                    break;
                }
                case "file": {
                    URI src = URLUtils.toURI(atts.getValue(Job.ATTRIBUTE_SRC));
                    URI uri = URLUtils.toURI(atts.getValue(Job.ATTRIBUTE_URI));
                    File path = URLUtils.toFile(atts.getValue(Job.ATTRIBUTE_PATH));
                    FileInfo i = uri != null ? new FileInfo(src, uri, URLUtils.toFile(uri)) : new FileInfo(src, URLUtils.toURI(path), path);
                    i.result = URLUtils.toURI(atts.getValue(Job.ATTRIBUTE_RESULT));
                    if (i.result == null) {
                        i.result = src;
                    }
                    i.format = atts.getValue(Job.ATTRIBUTE_FORMAT);
                    try {
                        for (Map.Entry e : attrToFieldMap.entrySet()) {
                            ((Field)e.getValue()).setBoolean(i, Boolean.parseBoolean(atts.getValue((String)e.getKey())));
                        }
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                    this.files.put(i.uri, i);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String n;
            switch (n = localName != null ? localName : qName) {
                case "property": {
                    this.name = null;
                    break;
                }
                case "string": {
                    if (this.set != null) {
                        this.set.add(this.buf.toString());
                    } else if (this.map != null) {
                        this.map.put(this.key, this.buf.toString());
                    } else {
                        this.prop.put(this.name, this.buf.toString());
                    }
                    this.buf = null;
                    break;
                }
                case "set": {
                    this.prop.put(this.name, this.set);
                    this.set = null;
                    break;
                }
                case "map": {
                    this.prop.put(this.name, this.map);
                    this.map = null;
                    break;
                }
                case "entry": {
                    this.key = null;
                }
            }
        }
    }
}

