/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;

public final class StringUtils {
    private StringUtils() {
    }

    public static String join(Collection coll, String delim) {
        StringBuilder buff = new StringBuilder(256);
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            buff.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            buff.append(delim);
        }
        return buff.toString();
    }

    public static String join(Map value, String delim) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Iterator i = value.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            buf.append((String)e.getKey()).append("=").append((String)e.getValue());
            if (!i.hasNext()) continue;
            buf.append(delim);
        }
        return buf.toString();
    }

    public static String replaceAll(String input, String pattern, String replacement) {
        int newIndex;
        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        while ((newIndex = input.indexOf(pattern, startIndex)) >= 0) {
            result.append(input, startIndex, newIndex);
            result.append(replacement);
            startIndex = newIndex + pattern.length();
        }
        result.append(input.substring(startIndex));
        return result.toString();
    }

    public static QName[][] getExtProps(String domains) {
        ArrayList<QName[]> propsBuffer = new ArrayList<QName[]>();
        int propsStart = domains.indexOf("a(props");
        int propsEnd = domains.indexOf(")", propsStart);
        while (propsStart != -1 && propsEnd != -1) {
            String propPath = domains.substring(propsStart + 2, propsEnd).trim();
            List<QName> propList = Stream.of(propPath.split("\\s+")).map(QName::valueOf).collect(Collectors.toList());
            propsBuffer.add(propList.toArray(new QName[0]));
            propsStart = domains.indexOf("a(props", propsEnd);
            propsEnd = domains.indexOf(")", propsStart);
        }
        return (QName[][])propsBuffer.toArray((T[])new QName[propsBuffer.size()][]);
    }

    public static QName[][] getExtPropsFromSpecializations(String specializations) {
        return (QName[][])Arrays.stream(specializations.trim().split("\\s+")).map(token -> Arrays.stream(token.substring(1).split("/")).map(QName::valueOf).collect(Collectors.toList()).toArray(new QName[0])).collect(Collectors.toList()).toArray((T[])new QName[0][]);
    }

    public static Set<String> restoreSet(String s, String delim) {
        HashSet<String> copytoSet = new HashSet<String>();
        if (StringUtils.isEmptyString(s)) {
            return copytoSet;
        }
        StringTokenizer st = new StringTokenizer(s, delim);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (StringUtils.isEmptyString(entry)) continue;
            copytoSet.add(entry);
        }
        return copytoSet;
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String setOrAppend(String target, String value, boolean withSpace) {
        if (target == null) {
            return value;
        }
        if (value == null) {
            return target;
        }
        if (withSpace && !target.endsWith(" ")) {
            return target + " " + value;
        }
        return target + value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Locale getLocale(String anEncoding) {
        String subtag2;
        Locale aLocale = null;
        String country = null;
        String language = null;
        StringTokenizer tokenizer = new StringTokenizer(anEncoding, "-");
        int numberOfTokens = tokenizer.countTokens();
        if (numberOfTokens == 1) {
            String tempString = tokenizer.nextToken().toLowerCase();
            int underscoreIndex = tempString.indexOf("_");
            if (underscoreIndex == -1) {
                language = tempString;
                return new Locale(language);
            } else {
                if (underscoreIndex != 2) {
                    if (underscoreIndex != 3) return new Locale(language);
                }
                language = tempString.substring(0, underscoreIndex);
            }
            return new Locale(language);
        }
        if (numberOfTokens == 2) {
            language = tokenizer.nextToken().toLowerCase();
            subtag2 = tokenizer.nextToken();
            if (subtag2.length() <= 3) {
                country = subtag2.toUpperCase();
                return new Locale(language, country);
            }
            if (subtag2.length() > 3 && subtag2.length() <= 8) {
                String variant = subtag2;
                return new Locale(language, "", variant);
            }
        } else {
            if (numberOfTokens < 3) return new Locale("en", "us");
            language = tokenizer.nextToken().toLowerCase();
            String subtag22 = tokenizer.nextToken();
            if (subtag22.length() <= 3) {
                country = subtag22.toUpperCase();
            } else if (subtag22.length() > 3 && subtag22.length() <= 8 || subtag22.length() > 8) {
                // empty if block
            }
            String variant = tokenizer.nextToken();
            return new Locale(language, country, variant);
        }
        if (subtag2.length() <= 8) return aLocale;
        return aLocale;
    }

    public static String escapeRegExp(String value) {
        StringBuilder buff = new StringBuilder();
        if (value == null || value.length() == 0) {
            return "";
        }
        block13: for (int index = 0; index < value.length(); ++index) {
            char current = value.charAt(index);
            switch (current) {
                case '.': {
                    buff.append("\\.");
                    continue block13;
                }
                case '\\': {
                    buff.append("[\\\\|/]");
                    continue block13;
                }
                case '(': {
                    buff.append("\\(");
                    continue block13;
                }
                case ')': {
                    buff.append("\\)");
                    continue block13;
                }
                case '[': {
                    buff.append("\\[");
                    continue block13;
                }
                case ']': {
                    buff.append("\\]");
                    continue block13;
                }
                case '{': {
                    buff.append("\\{");
                    continue block13;
                }
                case '}': {
                    buff.append("\\}");
                    continue block13;
                }
                case '^': {
                    buff.append("\\^");
                    continue block13;
                }
                case '+': {
                    buff.append("\\+");
                    continue block13;
                }
                case '$': {
                    buff.append("\\$");
                    continue block13;
                }
                default: {
                    buff.append(current);
                }
            }
        }
        return buff.toString();
    }

    public static void normalizeAndCollapseWhitespace(StringBuilder strBuffer) {
        WhiteSpaceState currentState = WhiteSpaceState.WORD;
        for (int i = strBuffer.length() - 1; i >= 0; --i) {
            char currentChar = strBuffer.charAt(i);
            if (Character.isWhitespace(currentChar)) {
                if (currentState == WhiteSpaceState.SPACE) {
                    strBuffer.delete(i, i + 1);
                } else if (currentChar != ' ') {
                    strBuffer.replace(i, i + 1, " ");
                }
                currentState = WhiteSpaceState.SPACE;
                continue;
            }
            currentState = WhiteSpaceState.WORD;
        }
    }

    public static Collection<String> split(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        String[] tokens = value.trim().split("\\s+");
        return Arrays.asList(tokens);
    }

    private static enum WhiteSpaceState {
        WORD,
        SPACE;

    }
}

