/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.DelayConrefUtils;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.KeyScope;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ConkeyrefFilter
extends AbstractXMLFilter {
    private KeyScope keys;
    private DelayConrefUtils delayConrefUtils;

    public void setKeyDefinitions(KeyScope keys) {
        this.keys = keys;
    }

    public void setDelayConrefUtils(DelayConrefUtils delayConrefUtils) {
        this.delayConrefUtils = delayConrefUtils;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        Attributes resAtts;
        block9: {
            String conkeyref;
            block10: {
                String id;
                KeyDef keyDef;
                String key;
                block11: {
                    resAtts = null;
                    conkeyref = atts.getValue("conkeyref");
                    if (conkeyref == null) break block9;
                    int keyIndex = conkeyref.indexOf("/");
                    key = keyIndex != -1 ? conkeyref.substring(0, keyIndex) : conkeyref;
                    keyDef = this.keys.get(key);
                    if (keyDef == null) break block10;
                    String string = id = keyIndex != -1 ? conkeyref.substring(keyIndex + 1) : null;
                    if (this.delayConrefUtils == null) break block11;
                    List<Boolean> list = this.delayConrefUtils.checkExport(URLUtils.stripFragment(keyDef.href).toString(), id, key, this.job.tempDir);
                    boolean idExported = list.get(0);
                    boolean keyrefExported = list.get(1);
                    if (idExported && keyrefExported) break block9;
                }
                resAtts = new AttributesImpl(atts);
                XMLUtils.removeAttribute((AttributesImpl)resAtts, "conkeyref");
                KeyDef k = this.keys.get(key);
                if (k.href != null && k.scope.equals("local")) {
                    URI target = this.getRelativePath(keyDef.source, k.href);
                    String keyFragment = k.href.getFragment();
                    if (id != null && keyFragment != null) {
                        target = URLUtils.setFragment(target, keyFragment + "/" + id);
                    } else if (id != null) {
                        target = URLUtils.setFragment(target, id);
                    } else if (keyFragment != null) {
                        target = URLUtils.setFragment(target, keyFragment);
                    }
                    XMLUtils.addOrSetAttribute((AttributesImpl)resAtts, "conref", target.toString());
                } else {
                    this.logger.warn(MessageUtils.getMessage("DOTJ060W", key, conkeyref).setLocation(atts).toString());
                }
                break block9;
            }
            this.logger.error(MessageUtils.getMessage("DOTJ046E", conkeyref).setLocation(atts).toString());
        }
        this.getContentHandler().startElement(uri, localName, name, resAtts != null ? resAtts : atts);
    }

    private URI getRelativePath(URI keyMap, URI href) {
        URI keyValue;
        URI inputMap = Optional.ofNullable(this.job.getFileInfo(keyMap)).map(fi -> fi.uri).orElse(null);
        if (inputMap != null) {
            URI tmpMap = this.job.tempDirURI.resolve(inputMap);
            keyValue = tmpMap.resolve(URLUtils.stripFragment(href));
        } else {
            keyValue = this.job.tempDirURI.resolve(URLUtils.stripFragment(href));
        }
        return URLUtils.getRelativePath(this.currentFile, keyValue);
    }
}

