/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.ConrefPushReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractDomFilter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConrefPushParser
extends AbstractDomFilter {
    private Map<ConrefPushReader.MoveKey, DocumentFragment> movetable;
    private boolean hasConref = false;
    private boolean hasKeyref = false;
    private File tempDir;

    public void setMoveTable(Map<ConrefPushReader.MoveKey, DocumentFragment> movetable) {
        this.movetable = movetable;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    @Override
    public void read(File filename) throws DITAOTException {
        this.hasConref = false;
        this.hasKeyref = false;
        super.read(filename);
        for (ConrefPushReader.MoveKey key : this.movetable.keySet()) {
            this.logger.warn(MessageUtils.getMessage("DOTJ043W", key.idPath, filename.getPath()).toString());
        }
        if (this.hasConref || this.hasKeyref) {
            this.updateList(filename);
        }
    }

    @Override
    protected Document process(Document doc) {
        this.walk(doc.getDocumentElement(), null);
        return doc;
    }

    private void updateList(File filename) {
        try {
            URI relativePath = URLUtils.toURI(filename.getAbsolutePath().substring(new File(FilenameUtils.normalize((String)this.tempDir.toString())).getPath().length() + 1));
            Job.FileInfo f = this.job.getOrCreateFileInfo(relativePath);
            if (this.hasConref) {
                f.hasConref = true;
            }
            if (this.hasKeyref) {
                f.hasKeyref = true;
            }
            this.job.write();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private boolean isPushedTypeMatch(DitaClass targetClassAttribute, DocumentFragment content) {
        if (content.hasChildNodes()) {
            NodeList nodeList = content.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem;
                DitaClass cls;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (cls = DitaClass.getInstance(elem = (Element)node)) == null) continue;
                return targetClassAttribute.matches(cls);
            }
        }
        return false;
    }

    private DocumentFragment replaceElementName(DitaClass targetClassAttribute, DocumentFragment content) {
        if (content.hasChildNodes()) {
            NodeList nodeList = content.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element elem = (Element)node;
                DitaClass cls = DitaClass.getInstance(elem);
                String type = targetClassAttribute.toString().substring(1, targetClassAttribute.toString().indexOf("/")).trim();
                if (!cls.equals(targetClassAttribute) && targetClassAttribute.matches(cls)) {
                    String targetElementName = targetClassAttribute.toString().substring(targetClassAttribute.toString().indexOf("/") + 1).trim();
                    if (elem.getAttributeNode("conref") != null) {
                        this.hasConref = true;
                    }
                    if (elem.getAttributeNode("keyref") != null) {
                        this.hasKeyref = true;
                    }
                    elem.getOwnerDocument().renameNode(elem, elem.getNamespaceURI(), targetElementName);
                    NodeList nList = elem.getChildNodes();
                    for (int j = 0; j < nList.getLength(); ++j) {
                        Node subNode = nList.item(j);
                        if (subNode.getNodeType() != 1) continue;
                        this.replaceSubElementName(type, (Element)subNode);
                    }
                    continue;
                }
                this.replaceSubElementName(" ", elem);
            }
        }
        return content;
    }

    private void replaceSubElementName(String type, Element elem) {
        if (elem.getAttributeNode("conref") != null) {
            this.hasConref = true;
        }
        if (elem.getAttributeNode("keyref") != null) {
            this.hasKeyref = true;
        }
        String generalizedElemName = elem.getNodeName();
        DitaClass cls = DitaClass.getInstance(elem);
        if (cls != null && cls.toString().contains(type) && !type.equals(" ")) {
            int index = cls.toString().indexOf("/");
            generalizedElemName = cls.toString().substring(index + 1, cls.toString().indexOf(" ", index)).trim();
        }
        elem.getOwnerDocument().renameNode(elem, elem.getNamespaceURI(), generalizedElemName);
        NodeList nodeList = elem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.replaceSubElementName(type, (Element)node);
        }
    }

    private ConrefPushReader.MoveKey hasAction(DitaClass classValue, String idPath, String defaultIdPath, String action) {
        ConrefPushReader.MoveKey containkey;
        if (this.movetable.containsKey(new ConrefPushReader.MoveKey(idPath, action))) {
            ConrefPushReader.MoveKey containkey2 = new ConrefPushReader.MoveKey(idPath, action);
            if (this.isPushedTypeMatch(classValue, this.movetable.get(containkey2))) {
                return containkey2;
            }
        } else if (this.movetable.containsKey(new ConrefPushReader.MoveKey(defaultIdPath, action)) && this.isPushedTypeMatch(classValue, this.movetable.get(containkey = new ConrefPushReader.MoveKey(defaultIdPath, action)))) {
            return containkey;
        }
        return null;
    }

    private void walk(Element elem, String parentTopicId) {
        String topicId = parentTopicId;
        String idValue = elem.getAttribute("id");
        if (idValue != null) {
            DitaClass cls = DitaClass.getInstance(elem);
            if (Constants.TOPIC_TOPIC.matches(cls)) {
                topicId = idValue;
            } else {
                ConrefPushReader.MoveKey pushReplace;
                ConrefPushReader.MoveKey pushAfter;
                String defaultidPath;
                String idPath = Constants.MAP_TOPICREF.matches(cls) || Constants.MAP_MAP.matches(cls) ? "#" + idValue : "#" + topicId + "/" + idValue;
                ConrefPushReader.MoveKey pushBefore = this.hasAction(cls, idPath, defaultidPath = "#" + idValue, "pushbefore");
                if (pushBefore != null) {
                    DocumentFragment fragment = this.movetable.remove(pushBefore);
                    XMLUtils.insertBefore(elem, this.replaceElementName(cls, fragment));
                }
                if ((pushAfter = this.hasAction(cls, idPath, defaultidPath, "pushafter")) != null) {
                    DocumentFragment fragment = this.movetable.remove(pushAfter);
                    XMLUtils.insertAfter(elem, this.replaceElementName(cls, fragment));
                }
                if ((pushReplace = this.hasAction(cls, idPath, defaultidPath, "pushreplace")) != null) {
                    DocumentFragment fragment = this.movetable.remove(pushReplace);
                    XMLUtils.insertBefore(elem, this.replaceElementName(cls, fragment));
                    elem.getParentNode().removeChild(elem);
                    return;
                }
            }
        }
        for (Element child : XMLUtils.getChildElements(elem)) {
            this.walk(child, topicId);
        }
    }
}

