/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.HashMap;
import java.util.Map;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class DebugFilter
extends AbstractXMLFilter {
    private Locator locator;
    private final Map<String, Integer> counterMap = new HashMap<String, Integer>();

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.getContentHandler().setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.getContentHandler().startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        DitaClass cls = DitaClass.getInstance(atts);
        AttributesImpl res = new AttributesImpl(atts);
        if (cls != null && !"dita".equals(localName)) {
            Integer nextValue;
            XMLUtils.addOrSetAttribute(res, "xtrf", this.currentFile.toString());
            if (this.counterMap.containsKey(qName)) {
                Integer value = this.counterMap.get(qName);
                nextValue = value + 1;
            } else {
                nextValue = 1;
            }
            this.counterMap.put(qName, nextValue);
            StringBuilder xtrc = new StringBuilder(qName).append(":").append(nextValue.toString());
            if (this.locator != null) {
                xtrc.append(';').append(Integer.toString(this.locator.getLineNumber())).append(":").append(Integer.toString(this.locator.getColumnNumber()));
            }
            XMLUtils.addOrSetAttribute(res, "xtrc", xtrc.toString());
        }
        super.startElement(uri, localName, qName, res);
    }
}

