/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.writer.AbstractDitaMetaWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DitaMetaWriter
extends AbstractDitaMetaWriter {
    private static final List<DitaClass> titlealtsPosition = Collections.unmodifiableList(Collections.singletonList(Constants.TOPIC_TITLE));
    private static final List<DitaClass> titlealtsOrder = Collections.unmodifiableList(Arrays.asList(Constants.TOPIC_NAVTITLE, Constants.MAP_SEARCHTITLE, Constants.TOPIC_SEARCHTITLE));
    private static final List<DitaClass> prologPosition = Collections.unmodifiableList(Arrays.asList(Constants.TOPIC_TITLE, Constants.TOPIC_TITLEALTS, Constants.TOPIC_SHORTDESC, Constants.TOPIC_ABSTRACT));
    private static final List<DitaClass> prologOrder = Collections.unmodifiableList(Arrays.asList(Constants.TOPIC_AUTHOR, Constants.TOPIC_SOURCE, Constants.TOPIC_PUBLISHER, Constants.TOPIC_COPYRIGHT, Constants.TOPIC_CRITDATES, Constants.TOPIC_PERMISSIONS, Constants.TOPIC_METADATA, Constants.TOPIC_RESOURCEID, Constants.TOPIC_DATA, Constants.TOPIC_DATA_ABOUT, Constants.TOPIC_FOREIGN, Constants.TOPIC_UNKNOWN));
    private static final List<DitaClass> metadataPosition = Collections.unmodifiableList(Arrays.asList(Constants.TOPIC_AUTHOR, Constants.TOPIC_SOURCE, Constants.TOPIC_PUBLISHER, Constants.TOPIC_COPYRIGHT, Constants.TOPIC_CRITDATES, Constants.TOPIC_PERMISSIONS));
    private static final List<DitaClass> metadataOrder = Collections.unmodifiableList(Arrays.asList(Constants.TOPIC_AUDIENCE, Constants.TOPIC_CATEGORY, Constants.TOPIC_KEYWORDS, Constants.TOPIC_PRODINFO, Constants.TOPIC_OTHERMETA));

    @Override
    public Document process(Document doc) {
        Element root = this.getMatchingTopicElement(doc.getDocumentElement());
        if (root == null) {
            return doc;
        }
        if (this.hasMetadata(titlealtsOrder)) {
            Element titlealts = this.findMetadataContainer(root, titlealtsPosition, Constants.TOPIC_TITLEALTS);
            this.processMetadata(titlealts, titlealtsOrder);
        }
        if (this.hasMetadata(prologOrder) || this.hasMetadata(metadataOrder)) {
            Element prolog = this.findMetadataContainer(root, prologPosition, Constants.TOPIC_PROLOG);
            this.processMetadata(prolog, prologOrder);
            if (this.hasMetadata(metadataOrder)) {
                Element metadata = this.findMetadataContainer(prolog, metadataPosition, Constants.TOPIC_METADATA);
                this.processMetadata(metadata, metadataOrder);
            }
        }
        return doc;
    }
}

