/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ExportAnchorsFilter
extends AbstractXMLFilter {
    private URI currentDir = null;
    private final Deque<String> stack = new LinkedList<String>();
    private boolean hasExport = false;
    private final List<ExportAnchor> exportAnchors = new ArrayList<ExportAnchor>();
    private ExportAnchor currentExportAnchor;
    private String topicId;
    private URI rootFilePath = null;
    private final Map<String, Set<String>> pluginMap = new HashMap<String, Set<String>>();
    private URI topicHref;
    private boolean shouldAppendEndTag = false;
    private DitaClass rootClass;

    public void setInputFile(URI inputFile) {
        assert (inputFile.isAbsolute());
        this.rootFilePath = inputFile;
    }

    @Override
    public void setCurrentFile(URI currentFile) {
        assert (currentFile.isAbsolute());
        super.setCurrentFile(currentFile);
        this.currentDir = currentFile.resolve(".");
    }

    public List<ExportAnchor> getExportAnchors() {
        return this.exportAnchors;
    }

    public Map<String, Set<String>> getPluginMap() {
        return this.pluginMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.rootClass = null;
        this.getContentHandler().startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String classValue = atts.getValue("class");
        this.stack.addFirst(classValue);
        if (classValue != null) {
            if (this.rootClass == null) {
                this.rootClass = DitaClass.getInstance(classValue);
            }
            if (Constants.TOPIC_TOPIC.matches(classValue)) {
                this.topicId = atts.getValue("id");
                String filename = this.currentFile.toString() + "?";
                for (ExportAnchor e : this.exportAnchors) {
                    if (!e.topicids.contains(filename)) continue;
                    e.topicids.add(this.topicId);
                    e.topicids.remove(filename);
                }
            } else if (Constants.MAP_TOPICREF.matches(classValue)) {
                this.parseAttribute(atts);
            } else if (Constants.MAP_MAP.matches(classValue)) {
                if (this.rootFilePath.equals(this.currentFile)) {
                    String pluginId = atts.getValue("id");
                    if (pluginId == null) {
                        pluginId = "org.sample.help.doc";
                    }
                    Set<String> set = StringUtils.restoreSet(pluginId, ",");
                    this.pluginMap.put("pluginId", set);
                }
            } else if (Constants.DELAY_D_EXPORTANCHORS.matches(classValue)) {
                this.hasExport = true;
                if (Constants.MAP_MAP.matches(this.rootClass)) {
                    this.currentExportAnchor = new ExportAnchor(this.topicHref);
                    this.currentExportAnchor.topicids.add(this.topicId);
                } else if (this.rootClass == null || Constants.TOPIC_TOPIC.matches(this.rootClass)) {
                    this.currentExportAnchor = new ExportAnchor(this.currentFile);
                    this.currentExportAnchor.topicids.add(this.topicId);
                    this.shouldAppendEndTag = true;
                }
            } else if (Constants.DELAY_D_ANCHORKEY.matches(classValue)) {
                String keyref = atts.getValue("keyref");
                this.currentExportAnchor.keys.add(keyref);
            } else if (Constants.DELAY_D_ANCHORID.matches(classValue)) {
                String id = atts.getValue("id");
                if (Constants.MAP_MAP.matches(this.rootClass)) {
                    if (!this.topicId.equals(id)) {
                        this.currentExportAnchor.ids.add(id);
                    }
                } else if ((this.rootClass == null || Constants.TOPIC_TOPIC.matches(this.rootClass)) && !this.topicId.equals(id)) {
                    this.currentExportAnchor.ids.add(id);
                }
            }
        }
        this.getContentHandler().startElement(uri, localName, qName, atts);
    }

    private void parseAttribute(Attributes atts) {
        URI attrValue = URLUtils.toURI(atts.getValue("href"));
        if (attrValue == null) {
            return;
        }
        String attrScope = atts.getValue("scope");
        if (this.isExternal(attrValue, attrScope)) {
            return;
        }
        String attrFormat = atts.getValue("format");
        if (attrFormat == null || "dita".equals(attrFormat)) {
            File target = URLUtils.toFile(attrValue);
            URI uRI = this.topicHref = target.isAbsolute() ? attrValue : this.currentDir.resolve(attrValue);
            if (attrValue.getFragment() != null) {
                this.topicId = attrValue.getFragment();
            } else if (attrFormat == null || attrFormat.equals("dita") || attrFormat.equals("ditamap")) {
                this.topicId = this.topicHref + "?";
            }
        } else {
            this.topicHref = null;
            this.topicId = null;
        }
    }

    private boolean isExternal(URI attrValue, String attrScope) {
        return "external".equals(attrScope) || "peer".equals(attrScope) || attrValue.toString().contains("://") || attrValue.toString().startsWith("#");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String classValue = this.stack.removeFirst();
        if (classValue != null && (Constants.MAP_TOPICMETA.matches(classValue) || Constants.TOPIC_PROLOG.matches(classValue)) && this.hasExport) {
            if (Constants.MAP_MAP.matches(this.rootClass)) {
                this.exportAnchors.add(this.currentExportAnchor);
                this.currentExportAnchor = null;
            }
            this.hasExport = false;
        }
        this.getContentHandler().endElement(uri, localName, qName);
    }

    @Override
    public void endDocument() throws SAXException {
        if ((this.rootClass == null || Constants.TOPIC_TOPIC.matches(this.rootClass)) && this.shouldAppendEndTag) {
            this.exportAnchors.add(this.currentExportAnchor);
            this.currentExportAnchor = null;
            this.shouldAppendEndTag = false;
        }
        this.getContentHandler().endDocument();
    }

    public static class ExportAnchor {
        public final URI file;
        public final Set<String> topicids = new HashSet<String>();
        public final Set<String> keys = new HashSet<String>();
        public final Set<String> ids = new HashSet<String>();

        public ExportAnchor(URI file) {
            this.file = file;
        }
    }
}

