/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dita.dost.util.Constants;
import org.dita.dost.util.SaxCache;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class NormalizeCodeblock
extends AbstractXMLFilter {
    private final Set<String> outputClass = new HashSet<String>(Collections.singletonList("normalize-space"));
    private int depth = 0;
    private final Collection<SaxCache.SaxEvent> buf = new ArrayList<SaxCache.SaxEvent>();

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.depth > 0) {
            this.buf.add(new SaxCache.StartPrefixMappingEvent(prefix, uri));
        } else {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.depth > 0) {
            this.buf.add(new SaxCache.EndPrefixMappingEvent(prefix));
        } else {
            super.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.depth > 0) {
            ++this.depth;
            this.buf.add(new SaxCache.StartElementEvent(uri, localName, qName, atts));
        } else if (Constants.PR_D_CODEBLOCK.matches(atts) && this.hasStripWhitespace(atts.getValue("outputclass"))) {
            this.depth = 1;
            super.startElement(uri, localName, qName, atts);
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasStripWhitespace(String value) {
        if (value == null) return false;
        if (!Arrays.stream(value.split("\\s+")).anyMatch(this.outputClass::contains)) return false;
        return true;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.depth > 0) {
            --this.depth;
            if (this.depth == 0) {
                for (SaxCache.SaxEvent event : this.normalizeSpace(this.mergeAdjacentText(this.buf))) {
                    event.write(this.getContentHandler());
                }
                this.buf.clear();
                super.endElement(uri, localName, qName);
            } else {
                this.buf.add(new SaxCache.EndElementEvent(uri, localName, qName));
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    private Collection<SaxCache.SaxEvent> mergeAdjacentText(Collection<SaxCache.SaxEvent> stream) {
        ArrayList<SaxCache.SaxEvent> res = new ArrayList<SaxCache.SaxEvent>();
        ArrayList<SaxCache.CharactersEvent> buf = new ArrayList<SaxCache.CharactersEvent>();
        for (SaxCache.SaxEvent event : stream) {
            if (event instanceof SaxCache.CharactersEvent) {
                buf.add((SaxCache.CharactersEvent)event);
                continue;
            }
            if (!buf.isEmpty()) {
                res.add(this.merge(buf));
                buf.clear();
            }
            res.add(event);
        }
        if (!buf.isEmpty()) {
            res.add(this.merge(buf));
        }
        return res;
    }

    private SaxCache.CharactersEvent merge(List<SaxCache.CharactersEvent> buf) {
        if (buf.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (buf.size() == 1) {
            return buf.get(0);
        }
        StringBuilder merged = new StringBuilder();
        for (SaxCache.CharactersEvent e : buf) {
            merged.append(e.ch, e.start, e.length);
        }
        char[] cs = merged.toString().toCharArray();
        return new SaxCache.CharactersEvent(cs, 0, cs.length);
    }

    private Collection<SaxCache.SaxEvent> normalizeSpace(Collection<SaxCache.SaxEvent> buf) {
        int min = this.getMinimumIndent(buf);
        if (min == 0) {
            return buf;
        }
        ArrayList<SaxCache.SaxEvent> res = new ArrayList<SaxCache.SaxEvent>(buf.size());
        boolean previousEndedInLinefeed = true;
        for (SaxCache.SaxEvent event : buf) {
            if (event instanceof SaxCache.CharactersEvent) {
                SaxCache.CharactersEvent e = (SaxCache.CharactersEvent)event;
                char[] ch = this.stripLeadingSpace(previousEndedInLinefeed, min, e.ch, e.start, e.length);
                res.add(new SaxCache.CharactersEvent(ch, 0, ch.length));
                previousEndedInLinefeed = ch.length != 0 && ch[ch.length - 1] == '\n';
                continue;
            }
            res.add(event);
        }
        return res;
    }

    private int getMinimumIndent(Collection<SaxCache.SaxEvent> buf) {
        String merged = this.getCharacters(buf);
        return Arrays.stream(merged.split("\n")).filter(str -> !str.isEmpty()).mapToInt(this::countLeadingSpace).min().orElse(0);
    }

    private String getCharacters(Collection<SaxCache.SaxEvent> buf) {
        StringBuilder merged = new StringBuilder();
        for (SaxCache.SaxEvent event : buf) {
            if (!(event instanceof SaxCache.CharactersEvent)) continue;
            SaxCache.CharactersEvent e = (SaxCache.CharactersEvent)event;
            merged.append(e.ch, e.start, e.length);
        }
        return merged.toString();
    }

    private char[] stripLeadingSpace(boolean first, int prefix, char[] ch, int start, int length) {
        String str = first ? new String(ch, start + prefix, length - prefix) : new String(ch, start, length);
        return str.replaceAll("\n {" + prefix + "}", "\n").toCharArray();
    }

    int countLeadingSpace(String ch) {
        for (int i = 0; i < ch.length(); ++i) {
            if (Character.isWhitespace(ch.charAt(i))) continue;
            return i;
        }
        return ch.length();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.depth > 0) {
            this.buf.add(new SaxCache.CharactersEvent(ch, start, length));
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.depth > 0) {
            this.buf.add(new SaxCache.CharactersEvent(ch, start, length));
        } else {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.depth > 0) {
            this.buf.add(new SaxCache.ProcessingInstructionEvent(target, data));
        } else {
            super.processingInstruction(target, data);
        }
    }
}

