/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractChunkTopicParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class SeparateChunkTopicParser
extends AbstractChunkTopicParser {
    private Element stub;
    private Element siblingStub;
    private final Deque<URI> outputFileNameStack = new ArrayDeque<URI>();
    private Element topicDoc = null;
    final Deque<Writer> outputStack = new ArrayDeque<Writer>();
    final Deque<Element> stubStack = new ArrayDeque<Element>();
    final Deque<String> lang = new LinkedList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(URI currentFile) {
        this.currentFile = currentFile;
        URI hrefValue = URLUtils.toURI(XMLUtils.getValue(this.rootTopicref, "href"));
        URI copytoValue = URLUtils.toURI(XMLUtils.getValue(this.rootTopicref, "copy-to"));
        String scopeValue = XMLUtils.getCascadeValue(this.rootTopicref, "scope");
        Collection<String> chunkValue = StringUtils.split(XMLUtils.getValue(this.rootTopicref, "chunk"));
        String processRoleValue = XMLUtils.getCascadeValue(this.rootTopicref, "processing-role");
        boolean dotchunk = false;
        URI parseFilePath = copytoValue != null ? (hrefValue != null && hrefValue.getFragment() != null ? URLUtils.setFragment(copytoValue, hrefValue.getFragment()) : copytoValue) : hrefValue;
        try {
            URI outputFileName;
            this.currentParsingFile = currentFile.resolve(parseFilePath);
            URI resolveBase = copytoValue == null ? this.currentParsingFile : currentFile;
            String id = null;
            String firstTopicID = null;
            if (parseFilePath.getFragment() != null) {
                id = parseFilePath.getFragment();
                if (chunkValue.contains("select-branch")) {
                    outputFileName = this.resolve(currentFile, id + ".dita");
                    this.targetTopicId = id;
                    this.startFromFirstTopic = false;
                    this.selectMethod = "select-branch";
                } else if (chunkValue.contains("select-document")) {
                    firstTopicID = this.getFirstTopicId(new File(URLUtils.stripFragment(currentFile.resolve(parseFilePath))));
                    this.topicDoc = this.getTopicDoc(currentFile.resolve(parseFilePath));
                    if (firstTopicID != null) {
                        outputFileName = this.resolve(currentFile, firstTopicID + ".dita");
                        this.targetTopicId = firstTopicID;
                    } else {
                        outputFileName = this.resolve(this.currentParsingFile, null);
                        dotchunk = true;
                        this.targetTopicId = null;
                    }
                    this.selectMethod = "select-document";
                } else {
                    outputFileName = this.resolve(currentFile, id + ".dita");
                    this.targetTopicId = id;
                    this.startFromFirstTopic = false;
                    this.selectMethod = "select-topic";
                }
            } else {
                firstTopicID = this.getFirstTopicId(new File(URLUtils.stripFragment(currentFile.resolve(parseFilePath))));
                this.topicDoc = this.getTopicDoc(currentFile.resolve(parseFilePath));
                if (firstTopicID != null) {
                    outputFileName = this.resolve(resolveBase, firstTopicID + ".dita");
                    this.targetTopicId = firstTopicID;
                } else {
                    outputFileName = this.resolve(resolveBase, null);
                    dotchunk = true;
                    this.targetTopicId = null;
                }
                this.selectMethod = "select-document";
            }
            if (copytoValue != null) {
                outputFileName = this.resolve(resolveBase, copytoValue.toString());
            }
            if (this.job.getStore().exists(outputFileName)) {
                URI t = outputFileName;
                outputFileName = this.resolve(resolveBase, this.generateFilename());
                this.conflictTable.put(outputFileName, t);
                dotchunk = false;
            }
            OutputStream out = this.job.getStore().getOutputStream(outputFileName);
            this.output = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            this.outputFile = outputFileName;
            if (!dotchunk) {
                Job.FileInfo fi = this.generateFileInfo(this.outputFile);
                this.job.add(fi);
                this.changeTable.put(currentFile.resolve(parseFilePath), URLUtils.setFragment(outputFileName, id));
                this.changeTable.put(outputFileName, outputFileName);
            }
            URI newHref = URLUtils.setFragment(URLUtils.getRelativePath(currentFile.resolve("stub.ditamap"), outputFileName), firstTopicID != null ? firstTopicID : id);
            this.rootTopicref.setAttribute("href", newHref.toString());
            this.include = false;
            this.addStubElements();
            if (this.rootTopicref.getNextSibling() != null) {
                this.rootTopicref.getParentNode().insertBefore(this.siblingStub, this.rootTopicref.getNextSibling());
            } else {
                this.rootTopicref.getParentNode().appendChild(this.siblingStub);
            }
            this.logger.info("Processing " + this.currentParsingFile);
            this.job.getStore().transform(this.currentParsingFile, this);
            this.output.flush();
            this.removeStubElements();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        finally {
            try {
                if (this.output != null) {
                    this.output.close();
                    this.output = null;
                    if (dotchunk) {
                        if (this.job.getStore().exists(this.currentParsingFile)) {
                            this.logger.debug("Delete " + this.currentParsingFile);
                            this.job.getStore().delete(this.currentParsingFile);
                        }
                        this.logger.debug("Move " + this.outputFile + " to " + this.currentParsingFile);
                        this.job.getStore().move(this.outputFile, this.currentParsingFile);
                        Job.FileInfo fi = this.job.getFileInfo(this.outputFile);
                        if (fi != null) {
                            this.job.remove(fi);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), ex);
            }
        }
    }

    private void addStubElements() {
        this.stub = this.rootTopicref.getOwnerDocument().createElement("stub");
        this.siblingStub = this.rootTopicref.getOwnerDocument().createElement("stub");
        if (this.rootTopicref.hasChildNodes()) {
            NodeList list = this.rootTopicref.getElementsByTagName(Constants.MAP_TOPICMETA.localName);
            if (list.getLength() > 0) {
                Node node = list.item(0);
                Node nextSibling = node.getNextSibling();
                if (nextSibling == null) {
                    node.getParentNode().appendChild(this.stub);
                } else {
                    node.getParentNode().insertBefore(this.stub, nextSibling);
                }
            } else {
                this.rootTopicref.insertBefore(this.stub, this.rootTopicref.getFirstChild());
            }
        } else {
            this.rootTopicref.appendChild(this.stub);
        }
    }

    private void removeStubElements() {
        this.stub.getParentNode().removeChild(this.stub);
        this.siblingStub.getParentNode().removeChild(this.siblingStub);
    }

    private Element getTopicDoc(URI absolutePathToFile) {
        try {
            Document doc = this.job.getStore().getDocument(absolutePathToFile);
            return doc.getDocumentElement();
        }
        catch (IOException e) {
            this.logger.error("Failed to parse " + absolutePathToFile + ": " + e.getMessage(), e);
            return null;
        }
    }

    private URI resolve(URI base, String file) {
        assert (base.isAbsolute());
        assert (base.toString().startsWith(this.job.tempDirURI.toString()));
        Job.FileInfo srcFi = this.job.getFileInfo(base);
        URI dst = file != null ? srcFi.result.resolve(file) : URLUtils.setPath(srcFi.result, srcFi.result.getPath() + ".chunk");
        URI tmp = this.tempFileNameScheme.generateTempFileName(dst);
        if (this.job.getFileInfo(tmp) == null) {
            this.job.add(new Job.FileInfo.Builder(srcFi).result(dst).uri(tmp).build());
        }
        return this.job.tempDirURI.resolve(tmp);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String cls = atts.getValue("class");
        String id = atts.getValue("id");
        AttributesImpl attsMod = new AttributesImpl(atts);
        String xmlLang = atts.getValue("xml:lang");
        if (this.skip && this.skipLevel > 0) {
            ++this.skipLevel;
        }
        String currentLang = xmlLang != null ? xmlLang : (!this.lang.isEmpty() ? this.lang.peek() : null);
        this.lang.push(currentLang);
        try {
            if (Constants.TOPIC_TOPIC.matches(cls)) {
                this.topicSpecSet.add(qName);
                if (this.include && !"select-topic".equals(this.selectMethod)) {
                    this.outputStack.push(this.output);
                    this.outputFileNameStack.push(this.outputFile);
                    this.outputFile = this.generateOutputFilename(id);
                    OutputStream out = this.job.getStore().getOutputStream(this.outputFile);
                    this.output = new OutputStreamWriter(out, StandardCharsets.UTF_8);
                    if (atts.getIndex("xml:lang") < 0 && currentLang != null) {
                        attsMod.addAttribute("", "lang", "xml:lang", "CDATA", currentLang);
                    }
                    this.changeTable.put(this.outputFile, this.outputFile);
                    if (id != null) {
                        this.changeTable.put(URLUtils.setFragment(this.currentParsingFile, id), URLUtils.setFragment(this.outputFile, id));
                    } else {
                        this.changeTable.put(this.currentParsingFile, this.outputFile);
                    }
                    this.writeStartDocument(this.output);
                    if (!Constants.OS_NAME.toLowerCase().contains("windows")) {
                        this.writeProcessingInstruction(this.output, "workdir", new File(this.currentFile).getParentFile().getAbsolutePath());
                    } else {
                        this.writeProcessingInstruction(this.output, "workdir", "/" + this.currentFile.resolve("."));
                    }
                    this.writeProcessingInstruction(this.output, "workdir-uri", this.currentFile.resolve(".").toString());
                    Element newTopicref = this.rootTopicref.getOwnerDocument().createElement(Constants.MAP_TOPICREF.localName);
                    newTopicref.setAttribute("class", Constants.MAP_TOPICREF.toString());
                    newTopicref.setAttribute("xtrf", "generated_by_chunk");
                    newTopicref.setAttribute("href", URLUtils.getRelativePath(this.currentFile.resolve("stub.ditamap"), this.outputFile).toString());
                    Element topic = XMLUtils.searchForNode(this.topicDoc, id, "id", Constants.TOPIC_TOPIC);
                    Element topicmeta = this.createTopicMeta(topic);
                    newTopicref.appendChild(topicmeta);
                    if (this.stub != null) {
                        if (this.includelevel == 0 && this.siblingStub != null) {
                            this.siblingStub.getParentNode().insertBefore(newTopicref, this.siblingStub);
                        } else {
                            this.stub.getParentNode().insertBefore(newTopicref, this.stub);
                        }
                        this.stubStack.push(this.stub);
                        this.stub = (Element)this.stub.cloneNode(false);
                        newTopicref.appendChild(this.stub);
                    }
                }
                this.processSelect(id);
            }
            if (this.include) {
                ++this.includelevel;
                Attributes resAtts = this.processAttributes(attsMod);
                this.writeStartElement(this.output, qName, resAtts);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.skip && this.skipLevel > 0) {
            --this.skipLevel;
        } else if (this.skip) {
            this.include = true;
            this.skip = false;
            this.skipLevel = 0;
        }
        if (this.include) {
            --this.includelevel;
            if (this.includelevel >= 0) {
                this.writeEndElement(this.output, qName);
            }
            if (this.includelevel == 0 && !"select-document".equals(this.selectMethod)) {
                this.include = false;
            }
            if (this.topicSpecSet.contains(qName) && !this.outputStack.isEmpty()) {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), e);
                }
                this.output = this.outputStack.pop();
                this.outputFile = this.outputFileNameStack.pop();
                this.stub.getParentNode().removeChild(this.stub);
                this.stub = this.stubStack.pop();
            }
        }
        this.lang.pop();
    }
}

