/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.dita.dost.chunk.ChunkModule;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ValidationFilter
extends AbstractXMLFilter {
    private final Set<String> topicIds = new HashSet<String>();
    private Map<QName, Map<String, Set<String>>> validateMap = null;
    private Locator locator;
    private final Deque<QName[][]> domains = new LinkedList<QName[][]>();
    private Configuration.Mode processingMode;

    public void setValidateMap(Map<QName, Map<String, Set<String>>> validateMap) {
        this.validateMap = validateMap;
    }

    public void setProcessingMode(Configuration.Mode processingMode) {
        this.processingMode = processingMode;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String d = atts.getValue("domains");
        if (d != null) {
            this.domains.addFirst(StringUtils.getExtProps(d));
        } else {
            String s = atts.getValue("specializations");
            if (s != null) {
                this.domains.addFirst(StringUtils.getExtPropsFromSpecializations(s));
            } else {
                this.domains.addFirst(this.domains.peekFirst());
            }
        }
        AttributesImpl modified = this.validateLang(atts, null);
        modified = this.validateId(localName, atts, modified);
        modified = this.validateReference("href", atts, modified);
        modified = this.validateReference("conref", atts, modified);
        modified = this.validateScope(atts, modified);
        modified = this.processFormatDitamap(atts, modified);
        this.validateKeys(atts);
        this.validateKeyscope(atts);
        this.validateAttributeValues(qName, atts);
        this.validateAttributeGeneralization(atts);
        super.startElement(uri, localName, qName, modified != null ? modified : atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.domains.removeFirst();
        super.endElement(uri, localName, qName);
    }

    private AttributesImpl validateLang(Attributes atts, AttributesImpl modified) throws SAXException {
        int i;
        AttributesImpl res = modified;
        String lang = atts.getValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (lang != null && (i = lang.indexOf(95)) != -1) {
            if (this.processingMode == Configuration.Mode.STRICT) {
                throw new SAXException(MessageUtils.getMessage("DOTJ056E", lang).setLocation(this.locator).toString());
            }
            this.logger.error(MessageUtils.getMessage("DOTJ056E", lang).setLocation(this.locator).toString());
            if (this.processingMode == Configuration.Mode.LAX) {
                if (res == null) {
                    res = new AttributesImpl(atts);
                }
                res.setValue(res.getIndex("http://www.w3.org/XML/1998/namespace", "lang"), lang.replace('_', '-'));
            }
        }
        return res;
    }

    private AttributesImpl validateId(String localName, Attributes atts, AttributesImpl modified) throws SAXException {
        String id;
        AttributesImpl res = modified;
        String cls = atts.getValue("class");
        if (Constants.MAP_MAP.matches(cls)) {
            this.topicIds.clear();
        } else if (Constants.TOPIC_TOPIC.matches(cls)) {
            String id2 = atts.getValue("id");
            if (id2 == null) {
                switch (this.processingMode) {
                    case STRICT: {
                        throw new SAXException(MessageUtils.getMessage("DOTJ067E", localName).setLocation(this.locator).toString());
                    }
                    case LAX: {
                        if (res == null) {
                            res = new AttributesImpl(atts);
                        }
                        String gen = "gen_" + UUID.randomUUID().toString();
                        XMLUtils.addOrSetAttribute(res, "id", gen);
                        this.logger.error(MessageUtils.getMessage("DOTJ066E", localName, gen).setLocation(this.locator).toString());
                        break;
                    }
                    case SKIP: {
                        this.logger.error(MessageUtils.getMessage("DOTJ067E", localName).setLocation(this.locator).toString());
                    }
                }
            }
            this.topicIds.clear();
        } else if (!Constants.TOPIC_RESOURCEID.matches(cls) && !Constants.DELAY_D_ANCHORID.matches(cls) && (id = atts.getValue("id")) != null) {
            if (this.topicIds.contains(id)) {
                if (this.processingMode == Configuration.Mode.STRICT) {
                    throw new SAXException(MessageUtils.getMessage("DOTJ057E", id).setLocation(this.locator).toString());
                }
                this.logger.warn(MessageUtils.getMessage("DOTJ057E", id).setLocation(this.locator).toString());
            }
            this.topicIds.add(id);
        }
        return res;
    }

    private AttributesImpl validateReference(String attrName, Attributes atts, AttributesImpl modified) {
        AttributesImpl res;
        block20: {
            res = modified;
            String href = atts.getValue(attrName);
            if (href != null) {
                try {
                    URI uri = new URI(href);
                    URI abs = this.currentFile.resolve(uri).normalize();
                    if (!Objects.equals(abs.getScheme(), "file")) break block20;
                    File p = new File(URLUtils.setQuery(URLUtils.stripFragment(abs), null));
                    try {
                        File canFile = p.getCanonicalFile();
                        String absPath = p.getAbsolutePath();
                        String canPath = canFile.toString();
                        if (!Objects.equals(absPath, canPath) && Objects.equals(absPath.toLowerCase(), canPath.toLowerCase())) {
                            switch (this.processingMode) {
                                case STRICT: {
                                    throw new RuntimeException(MessageUtils.getMessage("DOTJ083E", abs.toString()).setLocation(this.locator).toString());
                                }
                                case SKIP: {
                                    this.logger.error(MessageUtils.getMessage("DOTJ083E", abs.toString()).setLocation(this.locator).toString() + ", using authored value.");
                                    break;
                                }
                                case LAX: {
                                    URI corrected = URLUtils.setFragment(this.currentFile.relativize(canFile.toURI()), uri.getFragment());
                                    if (res == null) {
                                        res = new AttributesImpl(atts);
                                    }
                                    res.setValue(res.getIndex(attrName), this.currentFile.toString());
                                    this.logger.error(MessageUtils.getMessage("DOTJ083E", abs.toString()).setLocation(this.locator).toString() + ", using " + corrected + ".");
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        this.logger.debug(String.format("Failed to resolve real path for %s: %s", p, e.getMessage()), e);
                    }
                }
                catch (URISyntaxException e) {
                    switch (this.processingMode) {
                        case STRICT: {
                            throw new RuntimeException(MessageUtils.getMessage("DOTJ054E", attrName, href).setLocation(this.locator) + ": " + e.getMessage(), e);
                        }
                        case SKIP: {
                            this.logger.error(MessageUtils.getMessage("DOTJ054E", attrName, href).setLocation(this.locator) + ", using invalid value.");
                            break;
                        }
                        case LAX: {
                            try {
                                URI uri = new URI(URLUtils.clean(href.trim()));
                                if (res == null) {
                                    res = new AttributesImpl(atts);
                                }
                                res.setValue(res.getIndex(attrName), uri.toASCIIString());
                                this.logger.error(MessageUtils.getMessage("DOTJ054E", attrName, href).setLocation(this.locator) + ", using '" + uri.toASCIIString() + "'.");
                                break;
                            }
                            catch (URISyntaxException e1) {
                                this.logger.error(MessageUtils.getMessage("DOTJ054E", attrName, href).setLocation(this.locator) + ", using invalid value.");
                            }
                        }
                    }
                }
            }
        }
        return res;
    }

    private AttributesImpl validateScope(Attributes atts, AttributesImpl modified) {
        AttributesImpl res = modified;
        String scope = atts.getValue("scope");
        URI href = URLUtils.toURI(atts.getValue("href"));
        if (scope == null && href != null && href.isAbsolute()) {
            boolean sameScheme = Objects.equals(this.currentFile.getScheme(), href.getScheme());
            boolean sameAuthority = Objects.equals(this.currentFile.getRawAuthority(), href.getRawAuthority());
            if (!sameScheme || !sameAuthority) {
                switch (this.processingMode) {
                    case LAX: {
                        if (res == null) {
                            res = new AttributesImpl(atts);
                        }
                        XMLUtils.addOrSetAttribute(res, "scope", "external");
                        this.logger.warn(MessageUtils.getMessage("DOTJ075W", href.toString()).setLocation(this.locator).toString());
                        break;
                    }
                    default: {
                        this.logger.warn(MessageUtils.getMessage("DOTJ076W", href.toString()).setLocation(this.locator) + ", using invalid value.");
                    }
                }
            }
        }
        return res;
    }

    private void validateAttributeValues(String qName, Attributes atts) {
        if (this.validateMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String[] keylist;
            QName attrName = new QName(atts.getURI(i), atts.getLocalName(i));
            Map<String, Set<String>> valueMap = this.validateMap.get(attrName);
            if (valueMap == null) continue;
            Set<String> valueSet = valueMap.get(qName);
            if (valueSet == null) {
                valueSet = valueMap.get("*");
            }
            if (valueSet == null) continue;
            String attrValue = atts.getValue(i);
            for (String s : keylist = attrValue.trim().split("\\s+")) {
                if (StringUtils.isEmptyString(s) || valueSet.contains(s)) continue;
                this.logger.warn(MessageUtils.getMessage("DOTJ049W", attrName.toString(), qName, attrValue, StringUtils.join(valueSet, ",")).setLocation(atts).toString());
            }
        }
    }

    private void validateKeys(Attributes atts) {
        String keys = atts.getValue("keys");
        if (keys != null) {
            for (String key : keys.split(" ")) {
                if (this.isValidKeyName(key)) continue;
                this.logger.error(MessageUtils.getMessage("DOTJ055E", key).toString());
            }
        }
    }

    private void validateKeyscope(Attributes atts) {
        String keys = atts.getValue("keyscope");
        if (keys != null) {
            for (String key : keys.trim().split("\\s+")) {
                if (this.isValidKeyName(key)) continue;
                this.logger.error(MessageUtils.getMessage("DOTJ059E", key).toString());
            }
        }
    }

    private boolean isValidKeyName(String key) {
        block4: for (char c : key.toCharArray()) {
            switch (c) {
                case '#': 
                case '/': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '_': 
                case '~': {
                    continue block4;
                }
                default: {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    private void validateAttributeGeneralization(Attributes atts) {
        QName[][] d = this.domains.peekFirst();
        if (d != null) {
            for (QName[] spec : d) {
                for (int i = spec.length - 1; i > -1; --i) {
                    if (atts.getValue(spec[i].getNamespaceURI(), spec[i].getLocalPart()) == null) continue;
                    for (int j = i - 1; j > -1; --j) {
                        if (atts.getValue(spec[j].getNamespaceURI(), spec[j].getLocalPart()) == null) continue;
                        this.logger.error(MessageUtils.getMessage("DOTJ058E", spec[j].toString(), spec[i].toString()).toString());
                    }
                }
            }
        }
    }

    private AttributesImpl processFormatDitamap(Attributes atts, AttributesImpl modified) {
        if (this.job == null) {
            return modified;
        }
        AttributesImpl res = modified;
        String cls = atts.getValue("class");
        if (Constants.MAP_TOPICREF.matches(cls)) {
            URI target;
            Job.FileInfo fi;
            String format = atts.getValue("format");
            String scope = atts.getValue("scope");
            URI href = URLUtils.toURI(atts.getValue("href"));
            if (format == null && ChunkModule.isLocalScope(scope) && href != null && (fi = this.job.getFileInfo(target = this.currentFile.resolve(href))) != null && "ditamap".equals(fi.format)) {
                switch (this.processingMode) {
                    case STRICT: {
                        throw new RuntimeException(MessageUtils.getMessage("DOTJ061E", new String[0]).setLocation(this.locator).toString());
                    }
                    case SKIP: {
                        this.logger.error(MessageUtils.getMessage("DOTJ061E", new String[0]).setLocation(this.locator).toString());
                        break;
                    }
                    case LAX: {
                        this.logger.error(MessageUtils.getMessage("DOTJ061E", new String[0]).setLocation(this.locator).toString());
                        if (res == null) {
                            res = new AttributesImpl(atts);
                        }
                        XMLUtils.addOrSetAttribute(res, "format", fi.format);
                    }
                }
            }
        }
        return res;
    }
}

