/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer.include;

import java.io.BufferedReader;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.include.AllRange;
import org.dita.dost.writer.include.AnchorRange;
import org.dita.dost.writer.include.LineNumberRange;
import org.dita.dost.writer.include.Range;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

final class IncludeText {
    private final Job job;
    private final URI currentFile;
    private final ContentHandler contentHandler;
    private final DITAOTLogger logger;

    IncludeText(Job job, URI currentFile, ContentHandler contentHandler, DITAOTLogger logger) {
        this.job = job;
        this.currentFile = currentFile;
        this.contentHandler = contentHandler;
        this.logger = logger;
    }

    boolean include(Attributes atts) {
        URI hrefValue = URLUtils.toURI(atts.getValue("href"));
        Charset charset = this.getCharset(atts);
        Range range = this.getRange(hrefValue);
        File codeFile = this.getFile(hrefValue);
        if (codeFile != null) {
            try (BufferedReader codeReader = Files.newBufferedReader(codeFile.toPath(), charset);){
                range.copyLines(codeReader);
            }
            catch (Exception e) {
                this.logger.error("Failed to process include {0}", codeFile, e);
                return false;
            }
        }
        return true;
    }

    private File getFile(URI hrefValue) {
        File tempFile = URLUtils.toFile(URLUtils.stripFragment(this.currentFile.resolve(hrefValue))).getAbsoluteFile();
        URI rel = this.job.tempDirURI.relativize(tempFile.toURI());
        Job.FileInfo fi = this.job.getFileInfo(rel);
        if (fi != null && "file".equals(fi.src.getScheme())) {
            return new File(fi.src);
        }
        return null;
    }

    private Range getRange(URI uri) {
        int start = 0;
        int end = Integer.MAX_VALUE;
        String startId = null;
        String endId = null;
        String fragment = uri.getFragment();
        if (fragment != null) {
            Matcher m = Pattern.compile("^line=(?:(\\d+)|(\\d+)?,(\\d+)?)$").matcher(fragment);
            if (m.matches()) {
                if (m.group(1) != null) {
                    end = start = Integer.parseInt(m.group(1));
                } else {
                    if (m.group(2) != null) {
                        start = Integer.parseInt(m.group(2));
                    }
                    if (m.group(3) != null) {
                        end = Integer.parseInt(m.group(3)) - 1;
                    }
                }
                return new LineNumberRange(start, end).handler(this.contentHandler);
            }
            Matcher mc = Pattern.compile("^line-range\\((\\d+)(?:,\\s*(\\d+))?\\)$").matcher(fragment);
            if (mc.matches()) {
                start = Integer.parseInt(mc.group(1)) - 1;
                if (mc.group(2) != null) {
                    end = Integer.parseInt(mc.group(2)) - 1;
                }
                return new LineNumberRange(start, end).handler(this.contentHandler);
            }
            Matcher mi = Pattern.compile("^token=([^,\\s)]*)(?:,\\s*([^,\\s)]+))?$").matcher(fragment);
            if (mi.matches()) {
                if (mi.group(1) != null && mi.group(1).length() != 0) {
                    startId = mi.group(1);
                }
                if (mi.group(2) != null) {
                    endId = mi.group(2);
                }
                return new AnchorRange(startId, endId).handler(this.contentHandler);
            }
        }
        return new AllRange().handler(this.contentHandler);
    }

    private Charset getCharset(Attributes atts) {
        String format = atts.getValue("format");
        String encoding = atts.getValue("encoding");
        Charset c = null;
        try {
            String[] tokens;
            if (encoding != null) {
                c = Charset.forName(encoding);
            } else if (format != null && (tokens = format.trim().split("[;=]")).length >= 3 && tokens[1].trim().equals("charset")) {
                c = Charset.forName(tokens[2].trim());
            }
        }
        catch (RuntimeException e) {
            this.logger.error(MessageUtils.getMessage("DOTJ052E", encoding).setLocation(atts).toString());
        }
        if (c == null) {
            String defaultCharset = Configuration.configuration.get("default.coderef-charset");
            c = defaultCharset != null ? Charset.forName(defaultCharset) : Charset.defaultCharset();
        }
        return c;
    }
}

