/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.pattern.FeasibleTransform;
import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.IdTypeMapBuilder;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.CombineSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.impl.FeasibleIdTypeMapSchema;
import com.thaiopensource.validate.rng.impl.IdTypeMapSchema;
import com.thaiopensource.validate.rng.impl.PatternSchema;
import com.thaiopensource.validate.rng.impl.SchemaReaderImpl;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class OxygenRelaxNGSchemaReader
extends SchemaReaderImpl {
    private static final PropertyId<?>[] supportedPropertyIds = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, RngProperty.DATATYPE_LIBRARY_FACTORY, RngProperty.CHECK_ID_IDREF, RngProperty.FEASIBLE, WrapProperty.ATTRIBUTE_OWNER};

    public Schema createSchema(SAXSource source, PropertyMap properties) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder spb = new SchemaPatternBuilder();
        SAXResolver resolver = ResolverFactory.createResolver((PropertyMap)properties);
        ErrorHandler eh = (ErrorHandler)properties.get(ValidateProperty.ERROR_HANDLER);
        DatatypeLibraryFactory dlf = (DatatypeLibraryFactory)properties.get(RngProperty.DATATYPE_LIBRARY_FACTORY);
        if (dlf == null) {
            dlf = new DatatypeLibraryLoader();
        }
        try {
            Pattern start = SchemaBuilderImpl.parse((Parseable)this.createParseable(source, resolver, eh, properties), (ErrorHandler)eh, (DatatypeLibraryFactory)dlf, (SchemaPatternBuilder)spb, (boolean)properties.contains(WrapProperty.ATTRIBUTE_OWNER));
            return OxygenRelaxNGSchemaReader.wrapPattern2(start, spb, properties);
        }
        catch (IllegalSchemaException e) {
            throw new IncorrectSchemaException();
        }
    }

    private static SchemaWrapper wrapPattern2(Pattern start, SchemaPatternBuilder spb, PropertyMap properties) throws SAXException, IncorrectSchemaException {
        if (properties.contains((PropertyId)RngProperty.FEASIBLE)) {
            start = FeasibleTransform.transform((SchemaPatternBuilder)spb, (Pattern)start);
        }
        properties = AbstractSchema.filterProperties((PropertyMap)properties, supportedPropertyIds);
        PatternSchema schema = new PatternSchema(spb, start, properties);
        IdTypeMap idTypeMap = null;
        if (spb.hasIdTypes() && properties.contains((PropertyId)RngProperty.CHECK_ID_IDREF)) {
            ErrorHandler eh = (ErrorHandler)properties.get(ValidateProperty.ERROR_HANDLER);
            idTypeMap = new IdTypeMapBuilder(eh, start).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            Object idSchema = properties.contains((PropertyId)RngProperty.FEASIBLE) ? new FeasibleIdTypeMapSchema(idTypeMap, properties) : new IdTypeMapSchema(idTypeMap, properties);
            schema = new CombineSchema((Schema)schema, (Schema)idSchema, properties);
        }
        SchemaWrapper sw = new SchemaWrapper((Schema)schema);
        sw.setStart(start);
        sw.setIdTypeMap(idTypeMap);
        return sw;
    }

    public static class SchemaWrapper
    implements Schema {
        private Schema schema;
        private Pattern start;
        private IdTypeMap idTypeMap;

        public Pattern getStart() {
            return this.start;
        }

        public void setStart(Pattern start) {
            this.start = start;
        }

        public SchemaWrapper(Schema wrapped) {
            this.schema = wrapped;
        }

        public Validator createValidator(PropertyMap properties) {
            return this.schema.createValidator(properties);
        }

        public PropertyMap getProperties() {
            return this.schema.getProperties();
        }

        private IdTypeMap getIdTypeMap() {
            return this.idTypeMap;
        }

        public void setIdTypeMap(IdTypeMap idTypeMap) {
            this.idTypeMap = idTypeMap;
        }
    }
}

