/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.relaxng.pattern.DefaultValuesExtractor;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ditang.relaxng.defaults.OxygenRelaxNGSchemaReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class RelaxNGDefaultValues {
    private ErrorHandler eh;
    private final Resolver resolver;
    private DefaultValuesCollector defaultValuesCollector = null;

    public RelaxNGDefaultValues(Resolver resolver, ErrorHandler eh) {
        this.resolver = resolver;
        this.eh = eh;
    }

    protected abstract SchemaReader getSchemaReader();

    public void update(InputSource in) throws SAXException {
        this.defaultValuesCollector = null;
        PropertyMapBuilder builder = new PropertyMapBuilder();
        builder.put(ValidateProperty.RESOLVER, (Object)this.resolver);
        builder.put(ValidateProperty.ERROR_HANDLER, (Object)this.eh);
        PropertyMap properties = builder.toPropertyMap();
        try {
            OxygenRelaxNGSchemaReader.SchemaWrapper sw = (OxygenRelaxNGSchemaReader.SchemaWrapper)this.getSchemaReader().createSchema(in, properties);
            Pattern start = sw.getStart();
            this.defaultValuesCollector = new DefaultValuesCollector(start);
        }
        catch (Exception e) {
            this.eh.warning(new SAXParseException("Error loading defaults: " + e.getMessage(), null, e));
        }
        catch (StackOverflowError e) {
            this.eh.warning(new SAXParseException("Error loading defaults: " + e.getMessage(), null, null));
        }
    }

    public List<Attribute> getDefaultAttributes(String localName, String namespace) {
        if (this.defaultValuesCollector != null) {
            return this.defaultValuesCollector.getDefaultAttributes(localName, namespace);
        }
        return null;
    }

    class Attribute {
        String localName;
        String namespace;
        String value;

        public Attribute(String localName, String namespace, String value) {
            this.localName = localName;
            this.namespace = namespace;
            this.value = value;
        }
    }

    class DefaultValuesCollector
    implements DefaultValuesExtractor.DefaultValuesListener {
        private HashMap<String, List<Attribute>> defaults = new HashMap();

        public DefaultValuesCollector(Pattern start) {
            new DefaultValuesExtractor((DefaultValuesExtractor.DefaultValuesListener)this).parsePattern(start);
        }

        private String getKey(String elementLocalName, String elementNamespace) {
            return elementLocalName + "#" + (elementNamespace == null ? "" : elementNamespace);
        }

        List<Attribute> getDefaultAttributes(String elementLocalName, String elementNamespace) {
            return this.defaults.get(this.getKey(elementLocalName, elementNamespace));
        }

        public void defaultValue(String elementLocalName, String elementNamespace, String attributeLocalName, String attributeNamepsace, String value) {
            String key = this.getKey(elementLocalName, elementNamespace);
            List list = this.defaults.computeIfAbsent(key, k -> new ArrayList());
            list.add(new Attribute(attributeLocalName, attributeNamepsace, value));
        }
    }
}

