/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.ditang.relaxng.defaults.RNCDefaultValues;
import org.ditang.relaxng.defaults.RNGDefaultValues;
import org.ditang.relaxng.defaults.RelaxNGDefaultValues;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RelaxNGDefaultsComponent
implements XMLDocumentHandler,
XMLComponent,
XMLDocumentSource {
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String[] RECOGNIZED_FEATURES = new String[0];
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[0];
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null};
    private XMLDocumentHandler documentHandler;
    private XMLDocumentSource documentSource;
    private boolean detecting = false;
    private String schema = null;
    private String type = null;
    private String baseSystemId = null;
    private RelaxNGDefaultValues defaults;
    private NamespaceContext context;
    private SymbolTable fSymbolTable;
    private XMLEntityResolver fResolver;
    public static boolean DEBUG = false;
    private Resolver resolver;

    public RelaxNGDefaultsComponent(Resolver resolver) {
        this.resolver = resolver;
        if (this.resolver == null) {
            this.resolver = new Resolver(){

                public void resolve(Identifier id, Input input) throws IOException, ResolverException {
                    if (RelaxNGDefaultsComponent.this.fResolver != null) {
                        String expanded = id.getUriReference();
                        try {
                            expanded = new URL(new URL(id.getBase()), id.getUriReference()).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        XMLResourceIdentifierImpl identifier = new XMLResourceIdentifierImpl(null, id.getUriReference(), id.getBase(), expanded);
                        XMLInputSource resolved = RelaxNGDefaultsComponent.this.fResolver.resolveEntity((XMLResourceIdentifier)identifier);
                        if (resolved != null) {
                            input.setUri(resolved.getSystemId());
                            input.setByteStream(resolved.getByteStream());
                            input.setCharacterStream(resolved.getCharacterStream());
                            input.setEncoding(resolved.getEncoding());
                        }
                    }
                }

                public void open(Input input) throws IOException, ResolverException {
                    BasicResolver.getInstance().open(input);
                }
            };
        }
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.baseSystemId = null;
        this.detecting = false;
        this.schema = null;
        this.type = null;
        this.context = null;
        this.defaults = null;
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
    }

    public void startDocument(XMLLocator locator, String enc, NamespaceContext nc, Augmentations aug) throws XNIException {
        this.context = nc;
        this.baseSystemId = locator.getBaseSystemId();
        this.detecting = true;
        this.schema = null;
        this.type = null;
        if (this.documentHandler != null) {
            this.documentHandler.startDocument(locator, enc, nc, aug);
        }
    }

    public void startElement(QName name, XMLAttributes atts, Augmentations aug) throws XNIException {
        this.onStartElement(name, atts);
        if (this.documentHandler != null) {
            this.documentHandler.startElement(name, atts, aug);
        }
    }

    private void onStartElement(QName name, XMLAttributes atts) {
        if (this.detecting) {
            this.detecting = false;
            this.loadDefaults();
        }
        if (this.defaults != null) {
            this.checkAndAddDefaults(name, atts);
        }
    }

    private void loadDefaults() {
        block13: {
            this.defaults = null;
            ErrorHandler eh = new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                }
            };
            if (this.schema != null) {
                if ("xml".equals(this.type)) {
                    this.defaults = new RNGDefaultValues(this.resolver, eh);
                }
                if ("compact".equals(this.type)) {
                    this.defaults = new RNCDefaultValues(this.resolver, eh);
                }
                if (this.defaults != null) {
                    Input input;
                    block12: {
                        Identifier id = new Identifier(this.schema, this.baseSystemId);
                        input = new Input();
                        try {
                            this.resolver.resolve(id, input);
                        }
                        catch (ResolverException | IOException e1) {
                            if (!DEBUG) break block12;
                            e1.printStackTrace();
                        }
                    }
                    InputSource in = null;
                    if (input.isResolved()) {
                        in = new InputSource(input.getUri());
                        in.setByteStream(input.getByteStream());
                        in.setCharacterStream(input.getCharacterStream());
                        in.setEncoding(input.getEncoding());
                    } else {
                        String expanded = this.schema;
                        try {
                            expanded = new URL(new URL(this.baseSystemId), this.schema).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        in = new InputSource(expanded);
                    }
                    try {
                        this.defaults.update(in);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block13;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void checkAndAddDefaults(QName name, XMLAttributes atts) {
        List<RelaxNGDefaultValues.Attribute> def = this.defaults.getDefaultAttributes(name.localpart, name.uri);
        if (def != null) {
            for (RelaxNGDefaultValues.Attribute a : def) {
                boolean alreadyDeclared = false;
                boolean bl = alreadyDeclared = atts.getIndex(a.namespace, a.localName) >= 0;
                if (!alreadyDeclared && "".equals(a.namespace)) {
                    boolean bl2 = alreadyDeclared = atts.getIndex(null, a.localName) >= 0;
                }
                if (alreadyDeclared) continue;
                String prefix = null;
                String rawname = a.localName;
                if (a.namespace != null && a.namespace.length() > 0) {
                    prefix = this.context.getPrefix(a.namespace);
                    if (prefix == null) {
                        for (int i = 0; i < atts.getLength(); ++i) {
                            String attname = atts.getQName(i);
                            if (!attname.startsWith("xmlns:") || !a.namespace.equals(atts.getValue(i))) continue;
                            prefix = attname.substring(6);
                        }
                    }
                    if (prefix != null && prefix.length() > 0) {
                        rawname = prefix + ":" + a.localName;
                        if (atts.getIndex(rawname) >= 0) continue;
                        QName attName = new QName(this.fSymbolTable.addSymbol(prefix), this.fSymbolTable.addSymbol(a.localName), this.fSymbolTable.addSymbol(rawname), this.fSymbolTable.addSymbol(a.namespace));
                        atts.addAttribute(attName, "CDATA", a.value);
                        int attrIndex = atts.getIndex(attName.uri, attName.localpart);
                        atts.setSpecified(attrIndex, false);
                        continue;
                    }
                    int k = 1;
                    prefix = "http://dita.oasis-open.org/architecture/2005/".equals(a.namespace) ? "ditaarch" : "ns" + k;
                    while (this.context.getURI(prefix) != null || atts.getValue("xmlns:" + prefix) != null) {
                        prefix = "ns" + ++k;
                    }
                    rawname = prefix + ":" + a.localName;
                    QName attNs = new QName(this.fSymbolTable.addSymbol("xmlns"), this.fSymbolTable.addSymbol(prefix), this.fSymbolTable.addSymbol("xmlns:" + prefix), this.fSymbolTable.addSymbol("http://www.w3.org/2000/xmlns/"));
                    atts.addAttribute(attNs, "CDATA", a.namespace);
                    this.context.declarePrefix(prefix, a.namespace);
                    QName attName = new QName(this.fSymbolTable.addSymbol(prefix), this.fSymbolTable.addSymbol(a.localName), this.fSymbolTable.addSymbol(rawname), this.fSymbolTable.addSymbol(a.namespace));
                    atts.addAttribute(attName, "CDATA", a.value);
                    int attrIndex = atts.getIndex(attName.uri, attName.localpart);
                    atts.setSpecified(attrIndex, false);
                    continue;
                }
                String attname = this.fSymbolTable.addSymbol(a.localName);
                QName attName = new QName(null, attname, attname, null);
                atts.addAttribute(attName, "CDATA", a.value);
                int attrIndex = atts.getIndex(attname);
                atts.setSpecified(attrIndex, false);
            }
        }
    }

    public void xmlDecl(String arg0, String arg1, String arg2, Augmentations arg3) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.xmlDecl(arg0, arg1, arg2, arg3);
        }
    }

    public void doctypeDecl(String arg0, String arg1, String arg2, Augmentations arg3) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.doctypeDecl(arg0, arg1, arg2, arg3);
        }
    }

    public void comment(XMLString arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.comment(arg0, arg1);
        }
    }

    public void processingInstruction(String name, XMLString content, Augmentations arg2) throws XNIException {
        String data;
        if (this.detecting && this.schema == null && "oxygen".equals(name)) {
            data = content.toString();
            this.schema = this.getFromPIDataPseudoAttribute(data, "RNGSchema", true);
            this.type = this.getFromPIDataPseudoAttribute(data, "type", true);
        }
        if (this.detecting && this.schema == null && "xml-model".equals(name)) {
            data = content.toString();
            this.schema = this.getFromPIDataPseudoAttribute(data, "href", true);
            this.type = this.getFromPIDataPseudoAttribute(data, "type", true);
            String schemaTypeNs = this.getFromPIDataPseudoAttribute(data, "schematypens", true);
            if (this.schema != null) {
                if (this.schema.toLowerCase().endsWith(".rng")) {
                    if (this.nullOrValue(schemaTypeNs, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/xml")) {
                        this.type = "xml";
                    } else {
                        this.schema = null;
                    }
                } else if (this.schema.toLowerCase().endsWith(".rnc")) {
                    if (this.nullOrValue(schemaTypeNs, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/relax-ng-compact-syntax")) {
                        this.type = "compact";
                    } else {
                        this.schema = null;
                    }
                } else if ("http://relaxng.org/ns/structure/1.0".equals(schemaTypeNs) && this.nullOrValue(this.type, "application/xml")) {
                    this.type = "xml";
                } else if ("application/relax-ng-compact-syntax".equals(this.type) && this.nullOrValue(schemaTypeNs, "http://relaxng.org/ns/structure/1.0")) {
                    this.type = "compact";
                } else {
                    this.schema = null;
                }
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(name, content, arg2);
        }
    }

    private boolean nullOrValue(String test, String value) {
        if (test == null) {
            return true;
        }
        return test.equals(value);
    }

    private String getFromPIDataPseudoAttribute(String data, String name, boolean unescapeValue) {
        int pos = 0;
        while (pos <= data.length() - 4) {
            int nextQuote = -1;
            for (int q = pos; q < data.length(); ++q) {
                if (data.charAt(q) != '\"' && data.charAt(q) != '\'') continue;
                nextQuote = q;
                break;
            }
            if (nextQuote < 0) {
                return null;
            }
            int closingQuote = data.indexOf(data.charAt(nextQuote), nextQuote + 1);
            if (closingQuote < 0) {
                return null;
            }
            int nextName = data.indexOf(name, pos);
            if (nextName < 0) {
                return null;
            }
            if (nextName < nextQuote) {
                boolean found = true;
                for (int s = nextName + name.length(); s < nextQuote; ++s) {
                    char c = data.charAt(s);
                    if (Character.isWhitespace(c) || c == '=') continue;
                    found = false;
                    break;
                }
                if (found) {
                    String val = data.substring(nextQuote + 1, closingQuote);
                    return unescapeValue ? this.unescape(val) : val;
                }
            }
            pos = closingQuote + 1;
        }
        return null;
    }

    private String unescape(String value) {
        if (value.indexOf(38) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                if (i + 2 < value.length() && value.charAt(i + 1) == '#') {
                    int digit;
                    int x;
                    int charval;
                    if (value.charAt(i + 2) == 'x') {
                        charval = 0;
                        for (x = i + 3; x < value.length() && value.charAt(x) != ';'; ++x) {
                            digit = "0123456789abcdef".indexOf(value.charAt(x));
                            if (digit < 0) {
                                digit = "0123456789ABCDEF".indexOf(value.charAt(x));
                            }
                            if (digit < 0) {
                                return null;
                            }
                            charval = charval * 16 + digit;
                        }
                        char hexchar = (char)charval;
                        sb.append(hexchar);
                        i = x;
                        continue;
                    }
                    charval = 0;
                    for (x = i + 2; x < value.length() && value.charAt(x) != ';'; ++x) {
                        digit = "0123456789".indexOf(value.charAt(x));
                        if (digit < 0) {
                            return null;
                        }
                        charval = charval * 10 + digit;
                    }
                    char decchar = (char)charval;
                    sb.append(decchar);
                    i = x;
                    continue;
                }
                if (value.substring(i + 1).startsWith("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("amp;")) {
                    sb.append('&');
                    i += 4;
                    continue;
                }
                if (value.substring(i + 1).startsWith("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                if (value.substring(i + 1).startsWith("apos;")) {
                    sb.append('\'');
                    i += 5;
                    continue;
                }
                return null;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void emptyElement(QName name, XMLAttributes atts, Augmentations arg2) throws XNIException {
        this.onStartElement(name, atts);
        if (this.documentHandler != null) {
            this.documentHandler.emptyElement(name, atts, arg2);
        }
    }

    public void startGeneralEntity(String arg0, XMLResourceIdentifier arg1, String arg2, Augmentations arg3) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startGeneralEntity(arg0, arg1, arg2, arg3);
        }
    }

    public void textDecl(String arg0, String arg1, Augmentations arg2) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.textDecl(arg0, arg1, arg2);
        }
    }

    public void endGeneralEntity(String arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endGeneralEntity(arg0, arg1);
        }
    }

    public void characters(XMLString arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(arg0, arg1);
        }
    }

    public void ignorableWhitespace(XMLString arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(arg0, arg1);
        }
    }

    public void endElement(QName arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(arg0, arg1);
        }
    }

    public void startCDATA(Augmentations arg0) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startCDATA(arg0);
        }
    }

    public void endCDATA(Augmentations arg0) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endCDATA(arg0);
        }
    }

    public void endDocument(Augmentations arg0) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument(arg0);
        }
    }

    public void setDocumentSource(XMLDocumentSource arg0) {
        this.documentSource = arg0;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.documentSource;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String arg0, boolean arg1) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            int suffixLength = propertyId.length() - "http://apache.org/xml/properties/".length();
            if (suffixLength == "internal/symbol-table".length() && propertyId.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
            } else if (suffixLength == "internal/entity-resolver".length() && propertyId.endsWith("internal/entity-resolver")) {
                this.fResolver = (XMLEntityResolver)value;
            }
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.documentHandler = handler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }
}

