/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.mvstore.MVStoreConfig;
import org.dizitart.no2.mvstore.MVStoreUtils;
import org.dizitart.no2.mvstore.NitriteMVMap;
import org.dizitart.no2.mvstore.NitriteMVRTreeMap;
import org.dizitart.no2.store.AbstractNitriteStore;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteRTree;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.events.StoreEventListener;
import org.dizitart.no2.store.events.StoreEvents;
import org.h2.engine.Constants;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.rtree.MVRTreeMap;

public class NitriteMVStore
extends AbstractNitriteStore<MVStoreConfig> {
    private MVStore mvStore;
    private final Map<String, NitriteMap<?, ?>> nitriteMapRegistry = new ConcurrentHashMap();
    private final Map<String, NitriteRTree<?, ?>> nitriteRTreeMapRegistry = new ConcurrentHashMap();

    public void openOrCreate() {
        this.mvStore = MVStoreUtils.openOrCreate((MVStoreConfig)this.getStoreConfig());
        this.initEventBus();
        this.alert(StoreEvents.Opened);
    }

    public boolean isClosed() {
        return this.mvStore == null || this.mvStore.isClosed();
    }

    public boolean hasUnsavedChanges() {
        return this.mvStore != null && this.mvStore.hasUnsavedChanges();
    }

    public boolean isReadOnly() {
        return this.mvStore.isReadOnly();
    }

    public void commit() {
        this.mvStore.commit();
        this.alert(StoreEvents.Commit);
    }

    public void close() {
        for (NitriteMap<?, ?> nitriteMap : this.nitriteMapRegistry.values()) {
            nitriteMap.close();
        }
        for (NitriteRTree nitriteRTree : this.nitriteRTreeMapRegistry.values()) {
            nitriteRTree.close();
        }
        this.nitriteMapRegistry.clear();
        this.nitriteRTreeMapRegistry.clear();
        if (((MVStoreConfig)this.getStoreConfig()).autoCompact()) {
            this.mvStore.close(-1);
        } else {
            this.mvStore.close();
        }
        this.alert(StoreEvents.Closed);
        this.eventBus.close();
    }

    public boolean hasMap(String mapName) {
        return this.mvStore.hasMap(mapName);
    }

    public <Key, Value> NitriteMap<Key, Value> openMap(String mapName, Class<?> keyType, Class<?> valueType) {
        if (this.nitriteMapRegistry.containsKey(mapName)) {
            return (NitriteMVMap)this.nitriteMapRegistry.get(mapName);
        }
        MVMap mvMap = this.mvStore.openMap(mapName);
        NitriteMVMap nitriteMVMap = new NitriteMVMap(mvMap, (NitriteStore<?>)this);
        this.nitriteMapRegistry.put(mapName, nitriteMVMap);
        return nitriteMVMap;
    }

    public void closeMap(String mapName) {
        if (!StringUtils.isNullOrEmpty((String)mapName)) {
            this.nitriteMapRegistry.remove(mapName);
        }
    }

    public void closeRTree(String rTreeName) {
        if (!StringUtils.isNullOrEmpty((String)rTreeName)) {
            this.nitriteRTreeMapRegistry.remove(rTreeName);
        }
    }

    public void removeMap(String name) {
        MVMap mvMap = this.mvStore.openMap(name);
        this.mvStore.removeMap(mvMap);
        this.getCatalog().remove(name);
        this.nitriteMapRegistry.remove(name);
    }

    public void removeRTree(String rTreeName) {
        MVMap mvMap = this.mvStore.openMap(rTreeName, (MVMap.MapBuilder)new MVRTreeMap.Builder());
        this.mvStore.removeMap(mvMap);
        this.getCatalog().remove(rTreeName);
        this.nitriteRTreeMapRegistry.remove(rTreeName);
    }

    public <Key extends BoundingBox, Value> NitriteRTree<Key, Value> openRTree(String mapName, Class<?> keyType, Class<?> valueType) {
        if (this.nitriteRTreeMapRegistry.containsKey(mapName)) {
            return (NitriteMVRTreeMap)this.nitriteRTreeMapRegistry.get(mapName);
        }
        MVRTreeMap map = (MVRTreeMap)this.mvStore.openMap(mapName, (MVMap.MapBuilder)new MVRTreeMap.Builder());
        NitriteMVRTreeMap nitriteMVRTreeMap = new NitriteMVRTreeMap(map, (NitriteStore<?>)this);
        this.nitriteRTreeMapRegistry.put(mapName, nitriteMVRTreeMap);
        return nitriteMVRTreeMap;
    }

    public String getStoreVersion() {
        return "MVStore/" + Constants.VERSION;
    }

    private void initEventBus() {
        if (((MVStoreConfig)this.getStoreConfig()).eventListeners() != null) {
            for (StoreEventListener eventListener : ((MVStoreConfig)this.getStoreConfig()).eventListeners()) {
                this.eventBus.register((Object)eventListener);
            }
        }
    }
}

