/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.DBNull;
import org.dizitart.no2.common.DBValue;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexMeta;
import org.dizitart.no2.mvstore.MVStoreConfig;
import org.dizitart.no2.mvstore.compat.v1.Compat;
import org.dizitart.no2.mvstore.compat.v1.MVMapBuilder;
import org.dizitart.no2.mvstore.compat.v1.mvstore.MVMap;
import org.dizitart.no2.mvstore.compat.v1.mvstore.MVStore;
import org.dizitart.no2.store.UserCredential;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite-mvstore");

    private UpgradeUtil() {
    }

    public static void tryUpgrade(MVStore.Builder newBuilder, MVStoreConfig oldStoreConfig) {
        log.info("Upgrading old database format to new database format");
        MVStore.Builder oldBuilder = UpgradeUtil.createBuilder(oldStoreConfig);
        try (MVStore oldStore = oldBuilder.open();
             org.h2.mvstore.MVStore newStore = newBuilder.open();){
            UpgradeUtil.upgrade(newStore, oldStore);
        }
    }

    private static void upgrade(org.h2.mvstore.MVStore newStore, MVStore oldStore) {
        try {
            UpgradeUtil.validateOldStore(oldStore);
            Set<String> mapNames = oldStore.getMapNames();
            for (String mapName : mapNames) {
                Object oldMap = oldStore.openMap(mapName, new MVMapBuilder());
                org.h2.mvstore.MVMap newMap = newStore.openMap(mapName);
                UpgradeUtil.copyData(oldMap, newMap);
            }
            oldStore.commit();
            newStore.commit();
        }
        catch (Throwable t) {
            throw new NitriteIOException("Upgrade of old database has failed", t);
        }
    }

    private static void copyData(MVMap oldMap, org.h2.mvstore.MVMap newMap) {
        if (oldMap != null) {
            Set entrySet = oldMap.entrySet();
            for (Map.Entry entry : entrySet) {
                Object key = entry.getKey();
                Object newKey = entry.getKey();
                if (key instanceof Compat.NitriteId) {
                    newKey = UpgradeUtil.nitriteId((Compat.NitriteId)key);
                } else if (oldMap.getName().contains("$nitrite_index")) {
                    newKey = newKey == null ? DBNull.getInstance() : new DBValue((Comparable)newKey);
                }
                Object newValue = UpgradeUtil.migrateValue(entry.getValue());
                newMap.put(newKey, newValue);
            }
        }
    }

    private static Object migrateValue(Object value) {
        if (value != null) {
            if (value instanceof Compat.UserCredential) {
                return UpgradeUtil.credential((Compat.UserCredential)value);
            }
            if (value instanceof Compat.NitriteId) {
                return UpgradeUtil.nitriteId((Compat.NitriteId)value);
            }
            if (value instanceof Compat.Index) {
                return UpgradeUtil.indexEntry((Compat.Index)value);
            }
            if (value instanceof Compat.IndexMeta) {
                return UpgradeUtil.indexMeta((Compat.IndexMeta)value);
            }
            if (value instanceof Compat.Document) {
                return UpgradeUtil.document((Compat.Document)value);
            }
            if (value instanceof Compat.Attributes) {
                return UpgradeUtil.attributes((Compat.Attributes)value);
            }
            if (value instanceof ConcurrentSkipListSet) {
                return UpgradeUtil.arrayList((ConcurrentSkipListSet)value);
            }
            if (value instanceof Iterable) {
                return UpgradeUtil.iterable((Iterable)value);
            }
            if (value.getClass().isArray()) {
                return UpgradeUtil.array(ObjectUtils.convertToObjectArray((Object)value));
            }
            return value;
        }
        return null;
    }

    private static Object[] array(Object[] array) {
        Object[] newArray = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = UpgradeUtil.migrateValue(array[i]);
        }
        return newArray;
    }

    private static Iterable<?> iterable(Iterable<?> value) {
        AbstractCollection collection = null;
        if (value instanceof List) {
            collection = new ArrayList();
        } else if (value instanceof Set) {
            collection = new HashSet();
        }
        if (collection != null) {
            for (Object object : value) {
                Object newValue = UpgradeUtil.migrateValue(object);
                collection.add(newValue);
            }
        }
        return collection;
    }

    private static CopyOnWriteArrayList<?> arrayList(ConcurrentSkipListSet<?> value) {
        CopyOnWriteArrayList<Object> newList = new CopyOnWriteArrayList<Object>();
        for (Object object : value) {
            Object newValue = UpgradeUtil.migrateValue(object);
            newList.add(newValue);
        }
        return newList;
    }

    private static Attributes attributes(Compat.Attributes value) {
        Attributes attributes = new Attributes();
        attributes.set("created_at", Long.toString(value.getCreatedTime()));
        attributes.set("last_modified_at", Long.toString(value.getLastModifiedTime()));
        if (value.getCollection() != null) {
            attributes.set("owner", value.getCollection());
        }
        if (value.getUuid() != null) {
            attributes.set("uuid", value.getUuid());
        }
        return attributes;
    }

    private static Document document(Compat.Document value) {
        Document document = Document.createDocument();
        for (Map.Entry entry : value.entrySet()) {
            Object val = entry.getValue();
            Object migratedVal = UpgradeUtil.migrateValue(val);
            document.put((String)entry.getKey(), migratedVal);
        }
        return document;
    }

    private static IndexMeta indexMeta(Compat.IndexMeta value) {
        Compat.Index index = value.getIndex();
        IndexDescriptor indexDescriptor = UpgradeUtil.indexEntry(index);
        IndexMeta indexMeta = new IndexMeta();
        indexMeta.setIndexDescriptor(indexDescriptor);
        indexMeta.setIndexMap(value.getIndexMap());
        indexMeta.setIsDirty(value.getIsDirty());
        return indexMeta;
    }

    private static IndexDescriptor indexEntry(Compat.Index value) {
        String indexType = value.getIndexType().name();
        return new IndexDescriptor(indexType, Fields.withNames((String[])new String[]{value.getField()}), value.getCollectionName());
    }

    private static NitriteId nitriteId(Compat.NitriteId value) {
        return NitriteId.createId((String)Long.toString(value.getIdValue()));
    }

    private static UserCredential credential(Compat.UserCredential value) {
        UserCredential userCredential = new UserCredential();
        userCredential.setPasswordHash(value.getPasswordHash());
        userCredential.setPasswordSalt(value.getPasswordSalt());
        return userCredential;
    }

    private static void validateOldStore(MVStore store) {
        if (store.hasMap("$nitrite_store_info")) {
            throw new ValidationException("Database file is corrupted");
        }
    }

    private static MVStore.Builder createBuilder(MVStoreConfig mvStoreConfig) {
        MVStore.Builder builder = new MVStore.Builder();
        builder.autoCompactFillRate(0);
        if (!StringUtils.isNullOrEmpty((String)mvStoreConfig.filePath())) {
            builder = builder.fileName(mvStoreConfig.filePath());
        }
        if (!mvStoreConfig.autoCommit()) {
            builder = builder.autoCommitDisabled();
        }
        if (mvStoreConfig.autoCommitBufferSize() > 0) {
            builder = builder.autoCommitBufferSize(mvStoreConfig.autoCommitBufferSize());
        }
        if (mvStoreConfig.isReadOnly().booleanValue()) {
            if (StringUtils.isNullOrEmpty((String)mvStoreConfig.filePath())) {
                throw new InvalidOperationException("Unable create readonly in-memory database");
            }
            builder = builder.readOnly();
        }
        if (mvStoreConfig.compress()) {
            builder = builder.compress();
        }
        return builder;
    }
}

