/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore;

import java.io.File;
import org.h2.util.MathUtils;
import org.h2.util.Utils;

public class SysProperties {
    public static final String H2_SCRIPT_DIRECTORY = "h2.scriptDirectory";
    public static final String H2_BROWSER = "h2.browser";
    public static final String FILE_SEPARATOR = File.separator;
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String USER_HOME = Utils.getProperty((String)"user.home", (String)"");
    public static final boolean PREVIEW = Utils.getProperty((String)"h2.preview", (boolean)false);
    public static final String ALLOWED_CLASSES = Utils.getProperty((String)"h2.allowedClasses", (String)"*");
    public static final boolean ENABLE_ANONYMOUS_TLS = Utils.getProperty((String)"h2.enableAnonymousTLS", (boolean)true);
    public static final String BIND_ADDRESS = Utils.getProperty((String)"h2.bindAddress", (String)null);
    public static final boolean CHECK = Utils.getProperty((String)"h2.check", (!"0.9".equals(Utils.getProperty((String)"java.specification.version", (String)null)) ? 1 : 0) != 0);
    public static final String CLIENT_TRACE_DIRECTORY = Utils.getProperty((String)"h2.clientTraceDirectory", (String)"trace.db/");
    public static final int COLLATOR_CACHE_SIZE = Utils.getProperty((String)"h2.collatorCacheSize", (int)32000);
    public static final int CONSOLE_MAX_TABLES_LIST_INDEXES = Utils.getProperty((String)"h2.consoleTableIndexes", (int)100);
    public static final int CONSOLE_MAX_TABLES_LIST_COLUMNS = Utils.getProperty((String)"h2.consoleTableColumns", (int)500);
    public static final int CONSOLE_MAX_PROCEDURES_LIST_COLUMNS = Utils.getProperty((String)"h2.consoleProcedureColumns", (int)300);
    public static final boolean CONSOLE_STREAM = Utils.getProperty((String)"h2.consoleStream", (boolean)true);
    public static final int CONSOLE_TIMEOUT = Utils.getProperty((String)"h2.consoleTimeout", (int)1800000);
    public static final int DATASOURCE_TRACE_LEVEL = Utils.getProperty((String)"h2.dataSourceTraceLevel", (int)1);
    public static final int DELAY_WRONG_PASSWORD_MIN = Utils.getProperty((String)"h2.delayWrongPasswordMin", (int)250);
    public static final int DELAY_WRONG_PASSWORD_MAX = Utils.getProperty((String)"h2.delayWrongPasswordMax", (int)4000);
    public static final boolean JAVA_SYSTEM_COMPILER = Utils.getProperty((String)"h2.javaSystemCompiler", (boolean)true);
    public static boolean lobCloseBetweenReads = Utils.getProperty((String)"h2.lobCloseBetweenReads", (boolean)false);
    public static final int LOB_FILES_PER_DIRECTORY = Utils.getProperty((String)"h2.lobFilesPerDirectory", (int)256);
    public static final int LOB_CLIENT_MAX_SIZE_MEMORY = Utils.getProperty((String)"h2.lobClientMaxSizeMemory", (int)0x100000);
    public static final int MAX_FILE_RETRY = Math.max(1, Utils.getProperty((String)"h2.maxFileRetry", (int)16));
    public static final int MAX_RECONNECT = Utils.getProperty((String)"h2.maxReconnect", (int)3);
    public static final int MAX_MEMORY_ROWS = SysProperties.getAutoScaledForMemoryProperty("h2.maxMemoryRows", 40000);
    public static final long MAX_TRACE_DATA_LENGTH = Utils.getProperty((String)"h2.maxTraceDataLength", (int)65535);
    public static final boolean MODIFY_ON_WRITE = Utils.getProperty((String)"h2.modifyOnWrite", (boolean)false);
    public static final boolean NIO_LOAD_MAPPED = Utils.getProperty((String)"h2.nioLoadMapped", (boolean)false);
    public static final boolean NIO_CLEANER_HACK = Utils.getProperty((String)"h2.nioCleanerHack", (boolean)false);
    public static final boolean OBJECT_CACHE = Utils.getProperty((String)"h2.objectCache", (boolean)true);
    public static final int OBJECT_CACHE_MAX_PER_ELEMENT_SIZE = Utils.getProperty((String)"h2.objectCacheMaxPerElementSize", (int)4096);
    public static final int OBJECT_CACHE_SIZE;
    public static final boolean OLD_RESULT_SET_GET_OBJECT;
    public static final boolean BIG_DECIMAL_IS_DECIMAL;
    public static final boolean RETURN_OFFSET_DATE_TIME;
    public static final String PG_DEFAULT_CLIENT_ENCODING;
    public static final String PREFIX_TEMP_FILE;
    public static boolean FORCE_AUTOCOMMIT_OFF_ON_COMMIT;
    public static final int SERVER_CACHED_OBJECTS;
    public static final int SERVER_RESULT_SET_FETCH_SIZE;
    public static final int SOCKET_CONNECT_RETRY;
    public static final int SOCKET_CONNECT_TIMEOUT;
    public static final boolean SORT_BINARY_UNSIGNED;
    public static final boolean SORT_UUID_UNSIGNED;
    public static final boolean SORT_NULLS_HIGH;
    public static final long SPLIT_FILE_SIZE_SHIFT;
    public static final String SYNC_METHOD;
    public static final boolean TRACE_IO;
    public static final boolean THREAD_DEADLOCK_DETECTOR;
    public static final boolean IMPLICIT_RELATIVE_PATH;
    public static final String URL_MAP;
    public static final boolean USE_THREAD_CONTEXT_CLASS_LOADER;
    public static boolean serializeJavaObject;
    public static final String JAVA_OBJECT_SERIALIZER;
    public static final String CUSTOM_DATA_TYPES_HANDLER;
    public static final String AUTH_CONFIG_FILE;
    private static final String H2_BASE_DIR = "h2.baseDir";

    private SysProperties() {
    }

    public static void setBaseDir(String var0) {
        if (!((String)var0).endsWith("/")) {
            var0 = (String)var0 + "/";
        }
        System.setProperty(H2_BASE_DIR, (String)var0);
    }

    public static String getBaseDir() {
        return Utils.getProperty((String)H2_BASE_DIR, (String)null);
    }

    public static String getScriptDirectory() {
        return Utils.getProperty((String)H2_SCRIPT_DIRECTORY, (String)"");
    }

    private static int getAutoScaledForMemoryProperty(String var0, int var1) {
        String var2 = Utils.getProperty((String)var0, (String)null);
        if (var2 != null) {
            try {
                return Integer.decode(var2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Utils.scaleForAvailableMemory((int)var1);
    }

    static {
        try {
            OBJECT_CACHE_SIZE = MathUtils.nextPowerOf2((int)Utils.getProperty((String)"h2.objectCacheSize", (int)1024));
        }
        catch (IllegalArgumentException var1) {
            throw new IllegalStateException("Invalid h2.objectCacheSize", var1);
        }
        OLD_RESULT_SET_GET_OBJECT = Utils.getProperty((String)"h2.oldResultSetGetObject", (!PREVIEW ? 1 : 0) != 0);
        BIG_DECIMAL_IS_DECIMAL = Utils.getProperty((String)"h2.bigDecimalIsDecimal", (!PREVIEW ? 1 : 0) != 0);
        RETURN_OFFSET_DATE_TIME = Utils.getProperty((String)"h2.returnOffsetDateTime", (boolean)PREVIEW);
        PG_DEFAULT_CLIENT_ENCODING = Utils.getProperty((String)"h2.pgClientEncoding", (String)"UTF-8");
        PREFIX_TEMP_FILE = Utils.getProperty((String)"h2.prefixTempFile", (String)"h2.temp");
        FORCE_AUTOCOMMIT_OFF_ON_COMMIT = Utils.getProperty((String)"h2.forceAutoCommitOffOnCommit", (boolean)false);
        SERVER_CACHED_OBJECTS = Utils.getProperty((String)"h2.serverCachedObjects", (int)64);
        SERVER_RESULT_SET_FETCH_SIZE = Utils.getProperty((String)"h2.serverResultSetFetchSize", (int)100);
        SOCKET_CONNECT_RETRY = Utils.getProperty((String)"h2.socketConnectRetry", (int)16);
        SOCKET_CONNECT_TIMEOUT = Utils.getProperty((String)"h2.socketConnectTimeout", (int)2000);
        SORT_BINARY_UNSIGNED = Utils.getProperty((String)"h2.sortBinaryUnsigned", (boolean)true);
        SORT_UUID_UNSIGNED = Utils.getProperty((String)"h2.sortUuidUnsigned", (boolean)PREVIEW);
        SORT_NULLS_HIGH = Utils.getProperty((String)"h2.sortNullsHigh", (boolean)false);
        SPLIT_FILE_SIZE_SHIFT = Utils.getProperty((String)"h2.splitFileSizeShift", (int)30);
        SYNC_METHOD = Utils.getProperty((String)"h2.syncMethod", (String)"sync");
        TRACE_IO = Utils.getProperty((String)"h2.traceIO", (boolean)false);
        THREAD_DEADLOCK_DETECTOR = Utils.getProperty((String)"h2.threadDeadlockDetector", (boolean)false);
        IMPLICIT_RELATIVE_PATH = Utils.getProperty((String)"h2.implicitRelativePath", (boolean)false);
        URL_MAP = Utils.getProperty((String)"h2.urlMap", (String)null);
        USE_THREAD_CONTEXT_CLASS_LOADER = Utils.getProperty((String)"h2.useThreadContextClassLoader", (boolean)false);
        serializeJavaObject = Utils.getProperty((String)"h2.serializeJavaObject", (boolean)true);
        JAVA_OBJECT_SERIALIZER = Utils.getProperty((String)"h2.javaObjectSerializer", (String)null);
        CUSTOM_DATA_TYPES_HANDLER = Utils.getProperty((String)"h2.customDataTypesHandler", (String)null);
        AUTH_CONFIG_FILE = Utils.getProperty((String)"h2.authConfigFile", (String)null);
    }
}

