/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.dizitart.no2.mvstore.compat.v1.mvstore.SysProperties;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FileDisk;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FilePath;
import org.dizitart.no2.mvstore.compat.v1.mvstore.fs.FileUtils;
import org.dizitart.no2.mvstore.compat.v1.mvstore.util.IOUtils;
import org.h2.message.DbException;

public class FilePathDisk
extends FilePath {
    private static final String CLASSPATH_PREFIX = "classpath:";

    @Override
    public FilePathDisk getPath(String var1) {
        FilePathDisk var2 = new FilePathDisk();
        var2.name = FilePathDisk.translateFileName(var1);
        return var2;
    }

    @Override
    public long size() {
        if (this.name.startsWith(CLASSPATH_PREFIX)) {
            try {
                URL var2;
                Object var1 = this.name.substring(CLASSPATH_PREFIX.length());
                if (!((String)var1).startsWith("/")) {
                    var1 = "/" + (String)var1;
                }
                return (var2 = this.getClass().getResource((String)var1)) != null ? new File(var2.getPath()).length() : 0L;
            }
            catch (Exception var3) {
                return 0L;
            }
        }
        return new File(this.name).length();
    }

    protected static String translateFileName(String var0) {
        if ((var0 = var0.replace('\\', '/')).startsWith("file:")) {
            var0 = var0.substring("file:".length());
        }
        return FilePathDisk.expandUserHomeDirectory(var0);
    }

    public static String expandUserHomeDirectory(String var0) {
        if (((String)var0).startsWith("~") && (((String)var0).length() == 1 || ((String)var0).startsWith("~/"))) {
            String var1 = SysProperties.USER_HOME;
            var0 = var1 + ((String)var0).substring(1);
        }
        return var0;
    }

    @Override
    public void moveTo(FilePath var1, boolean var2) {
        File var3 = new File(this.name);
        File var4 = new File(var1.name);
        if (!var3.getAbsolutePath().equals(var4.getAbsolutePath())) {
            if (!var3.exists()) {
                throw DbException.get((int)90024, (String[])new String[]{this.name + " (not found)", var1.name});
            }
            if (var2) {
                boolean var7 = var3.renameTo(var4);
                if (!var7) {
                    throw DbException.get((int)90024, (String[])new String[]{this.name, var1.name});
                }
            } else {
                if (var4.exists()) {
                    throw DbException.get((int)90024, (String[])new String[]{this.name, var1 + " (exists)"});
                }
                for (int var5 = 0; var5 < SysProperties.MAX_FILE_RETRY; ++var5) {
                    IOUtils.trace("rename", this.name + " >" + var1, null);
                    boolean var6 = var3.renameTo(var4);
                    if (var6) {
                        return;
                    }
                    FilePathDisk.wait(var5);
                }
                throw DbException.get((int)90024, (String[])new String[]{this.name, var1.name});
            }
        }
    }

    private static void wait(int var0) {
        if (var0 == 8) {
            System.gc();
        }
        try {
            long var1 = Math.min(256, var0 * var0);
            Thread.sleep(var1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean createFile() {
        File var1 = new File(this.name);
        for (int var2 = 0; var2 < SysProperties.MAX_FILE_RETRY; ++var2) {
            try {
                return var1.createNewFile();
            }
            catch (IOException var4) {
                FilePathDisk.wait(var2);
                continue;
            }
        }
        return false;
    }

    @Override
    public boolean exists() {
        return new File(this.name).exists();
    }

    @Override
    public void delete() {
        File var1 = new File(this.name);
        for (int var2 = 0; var2 < SysProperties.MAX_FILE_RETRY; ++var2) {
            IOUtils.trace("delete", this.name, null);
            boolean var3 = var1.delete();
            if (var3 || !var1.exists()) {
                return;
            }
            FilePathDisk.wait(var2);
        }
        throw DbException.get((int)90025, (String)this.name);
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        ArrayList<FilePath> var1 = new ArrayList<FilePath>();
        File var2 = new File(this.name);
        try {
            String[] var3 = var2.list();
            if (var3 != null) {
                Object var4 = var2.getCanonicalPath();
                if (!((String)var4).endsWith(SysProperties.FILE_SEPARATOR)) {
                    var4 = (String)var4 + SysProperties.FILE_SEPARATOR;
                }
                var1.ensureCapacity(var3.length);
                String[] var5 = var3;
                int var6 = var3.length;
                for (int var7 = 0; var7 < var6; ++var7) {
                    String var8 = var5[var7];
                    var1.add(this.getPath((String)var4 + var8));
                }
            }
            return var1;
        }
        catch (IOException var9) {
            throw DbException.convertIOException((IOException)var9, (String)this.name);
        }
    }

    @Override
    public boolean canWrite() {
        return FilePathDisk.canWriteInternal(new File(this.name));
    }

    @Override
    public boolean setReadOnly() {
        File var1 = new File(this.name);
        return var1.setReadOnly();
    }

    @Override
    public FilePathDisk toRealPath() {
        try {
            String var1 = new File(this.name).getCanonicalPath();
            return this.getPath(var1);
        }
        catch (IOException var2) {
            throw DbException.convertIOException((IOException)var2, (String)this.name);
        }
    }

    @Override
    public FilePath getParent() {
        String var1 = new File(this.name).getParent();
        return var1 == null ? null : this.getPath(var1);
    }

    @Override
    public boolean isDirectory() {
        return new File(this.name).isDirectory();
    }

    @Override
    public boolean isAbsolute() {
        return new File(this.name).isAbsolute();
    }

    @Override
    public long lastModified() {
        return new File(this.name).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWriteInternal(File var0) {
        boolean var3;
        try {
            if (!var0.canWrite()) {
                return false;
            }
        }
        catch (Exception var16) {
            return false;
        }
        RandomAccessFile var1 = null;
        try {
            boolean var2;
            var1 = new RandomAccessFile(var0, "rw");
            boolean bl = var2 = true;
            return bl;
        }
        catch (FileNotFoundException var14) {
            var3 = false;
        }
        finally {
            if (var1 != null) {
                try {
                    var1.close();
                }
                catch (IOException iOException) {}
            }
        }
        return var3;
    }

    @Override
    public void createDirectory() {
        File var1 = new File(this.name);
        for (int var2 = 0; var2 < SysProperties.MAX_FILE_RETRY; ++var2) {
            if (var1.exists()) {
                if (var1.isDirectory()) {
                    return;
                }
                throw DbException.get((int)90062, (String)(this.name + " (a file with this name already exists)"));
            }
            if (var1.mkdir()) {
                return;
            }
            FilePathDisk.wait(var2);
        }
        throw DbException.get((int)90062, (String)this.name);
    }

    @Override
    public OutputStream newOutputStream(boolean var1) throws IOException {
        try {
            File var2 = new File(this.name);
            File var3 = var2.getParentFile();
            if (var3 != null) {
                FileUtils.createDirectories(var3.getAbsolutePath());
            }
            FileOutputStream var4 = new FileOutputStream(this.name, var1);
            IOUtils.trace("openFileOutputStream", this.name, var4);
            return var4;
        }
        catch (IOException var5) {
            FilePathDisk.freeMemoryAndFinalize();
            return new FileOutputStream(this.name);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        if (this.name.matches("[a-zA-Z]{2,19}:.*")) {
            if (this.name.startsWith(CLASSPATH_PREFIX)) {
                InputStream var2;
                Object var4 = this.name.substring(CLASSPATH_PREFIX.length());
                if (!((String)var4).startsWith("/")) {
                    var4 = "/" + (String)var4;
                }
                if ((var2 = this.getClass().getResourceAsStream((String)var4)) == null) {
                    var2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(((String)var4).substring(1));
                }
                if (var2 == null) {
                    throw new FileNotFoundException("resource " + (String)var4);
                }
                return var2;
            }
            URL var3 = new URL(this.name);
            return var3.openStream();
        }
        FileInputStream var1 = new FileInputStream(this.name);
        IOUtils.trace("openFileInputStream", this.name, var1);
        return var1;
    }

    static void freeMemoryAndFinalize() {
        IOUtils.trace("freeMemoryAndFinalize", null, null);
        Runtime var0 = Runtime.getRuntime();
        long var1 = var0.freeMemory();
        for (int var3 = 0; var3 < 16; ++var3) {
            var0.gc();
            long var4 = var0.freeMemory();
            var0.runFinalization();
            if (var4 == var1) break;
            var1 = var4;
        }
    }

    @Override
    public FileChannel open(String var1) throws IOException {
        FileDisk var2;
        try {
            var2 = new FileDisk(this.name, var1);
            IOUtils.trace("open", this.name, var2);
        }
        catch (IOException var6) {
            FilePathDisk.freeMemoryAndFinalize();
            try {
                var2 = new FileDisk(this.name, var1);
            }
            catch (IOException var5) {
                throw var6;
            }
        }
        return var2;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public FilePath createTempFile(String var1, boolean var2) throws IOException {
        String var3 = this.name + ".";
        String var4 = new File(var3).getName();
        File var5 = var2 ? new File(System.getProperty("java.io.tmpdir", ".")) : new File(var3).getAbsoluteFile().getParentFile();
        FileUtils.createDirectories(var5.getAbsolutePath());
        File var6;
        while ((var6 = new File(var5, var4 + FilePathDisk.getNextTempFileNamePart(false) + var1)).exists() || !var6.createNewFile()) {
            FilePathDisk.getNextTempFileNamePart(true);
        }
        return FilePathDisk.get(var6.getCanonicalPath());
    }
}

